/*
 * Decompiled with CFR 0.152.
 */
package dns;

import common.CommonUtils;
import common.MudgeSanity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SleeveSecurity {
    private IvParameterSpec B;
    private Cipher A;
    private Cipher C;
    private Mac F;
    private SecretKeySpec E;
    private SecretKeySpec D;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerKey(byte[] byArray) {
        SleeveSecurity sleeveSecurity = this;
        synchronized (sleeveSecurity) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                byte[] byArray2 = messageDigest.digest(byArray);
                byte[] byArray3 = Arrays.copyOfRange(byArray2, 0, 16);
                byte[] byArray4 = Arrays.copyOfRange(byArray2, 16, 32);
                this.E = new SecretKeySpec(byArray3, "AES");
                this.D = new SecretKeySpec(byArray4, "HmacSHA256");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public SleeveSecurity() {
        try {
            byte[] byArray = "abcdefghijklmnop".getBytes();
            this.B = new IvParameterSpec(byArray);
            this.A = Cipher.getInstance("AES/CBC/NoPadding");
            this.C = Cipher.getInstance("AES/CBC/NoPadding");
            this.F = Mac.getInstance("HmacSHA256");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected byte[] do_encrypt(SecretKey secretKey, byte[] byArray) throws Exception {
        this.A.init(1, (Key)secretKey, this.B);
        return this.A.doFinal(byArray);
    }

    protected byte[] do_decrypt(SecretKey secretKey, byte[] byArray) throws Exception {
        this.C.init(2, (Key)secretKey, this.B);
        return this.C.doFinal(byArray, 0, byArray.length);
    }

    protected void pad(ByteArrayOutputStream byteArrayOutputStream) {
        for (int i = byteArrayOutputStream.size() % 16; i < 16; ++i) {
            byteArrayOutputStream.write(65);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length + 1024);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            byteArrayOutputStream.reset();
            dataOutputStream.writeInt(CommonUtils.rand(Integer.MAX_VALUE));
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            this.pad(byteArrayOutputStream);
            byte[] byArray2 = null;
            Object object = this;
            synchronized (object) {
                byArray2 = this.do_encrypt(this.E, byteArrayOutputStream.toByteArray());
            }
            object = null;
            Object object2 = this;
            synchronized (object2) {
                this.F.init(this.D);
                object = this.F.doFinal(byArray2);
            }
            object2 = new ByteArrayOutputStream();
            ((OutputStream)object2).write(byArray2);
            ((ByteArrayOutputStream)object2).write((byte[])object, 0, 16);
            byte[] byArray3 = ((ByteArrayOutputStream)object2).toByteArray();
            return byArray3;
        }
        catch (InvalidKeyException invalidKeyException) {
            MudgeSanity.logException("[Sleeve] encrypt failure", invalidKeyException, false);
            CommonUtils.print_error_file("resources/crypto.txt");
            MudgeSanity.debugJava();
            if (this.E != null) {
                CommonUtils.print_info("[Sleeve] Key's algorithm is: '" + this.E.getAlgorithm() + "' ivspec is: " + this.B);
            }
        }
        catch (Exception exception) {
            MudgeSanity.logException("[Sleeve] encrypt failure", exception, false);
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] byArray) {
        try {
            byte[] byArray2 = Arrays.copyOfRange(byArray, 0, byArray.length - 16);
            byte[] byArray3 = Arrays.copyOfRange(byArray, byArray.length - 16, byArray.length);
            byte[] byArray4 = null;
            Object object = this;
            synchronized (object) {
                this.F.init(this.D);
                byArray4 = this.F.doFinal(byArray2);
            }
            object = Arrays.copyOfRange(byArray4, 0, 16);
            if (!MessageDigest.isEqual(byArray3, (byte[])object)) {
                CommonUtils.print_error("[Sleeve] Bad HMAC on " + byArray.length + " byte message from resource");
                return new byte[0];
            }
            byte[] byArray5 = null;
            Object object2 = this;
            synchronized (object2) {
                byArray5 = this.do_decrypt(this.E, byArray2);
            }
            object2 = new DataInputStream(new ByteArrayInputStream(byArray5));
            int n = ((DataInputStream)object2).readInt();
            int n2 = ((DataInputStream)object2).readInt();
            if (n2 < 0 || n2 > byArray.length) {
                CommonUtils.print_error("[Sleeve] Impossible message length: " + n2);
                return new byte[0];
            }
            byte[] byArray6 = new byte[n2];
            ((DataInputStream)object2).readFully(byArray6, 0, n2);
            return byArray6;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new byte[0];
        }
    }
}

