/*
 * Decompiled with CFR 0.152.
 */
package encoders;

import common.CommonUtils;
import common.DataParser;
import common.MudgeSanity;

public class MaskEncoder {
    public static byte[] decode(byte[] byArray) {
        try {
            byte[] byArray2 = new byte[byArray.length - 4];
            DataParser dataParser = new DataParser(byArray);
            byte[] byArray3 = dataParser.readBytes(4);
            for (int i = 0; i < byArray2.length && dataParser.more(); ++i) {
                byArray2[i] = (byte)(dataParser.readByte() ^ byArray3[i % 4]);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            MudgeSanity.logException("'mask' decode [" + byArray.length + " bytes] failed", throwable, false);
            return new byte[0];
        }
    }

    public static byte[] encode(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = new byte[]{(byte)CommonUtils.rand(255), (byte)CommonUtils.rand(255), (byte)CommonUtils.rand(255), (byte)CommonUtils.rand(255)};
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = (byte)(byArray[i] ^ byArray3[i % 4]);
        }
        return CommonUtils.join(byArray3, byArray2);
    }

    public static void main(String[] stringArray) {
        String string = "\u00ccthis is a test and should show up after decoding.";
        byte[] byArray = CommonUtils.toBytes(string);
        System.err.println(CommonUtils.toNasmHexString(MaskEncoder.encode(byArray)));
    }
}

