/*
 * Decompiled with CFR 0.152.
 */
package graph;

import aggressor.AggressorClient;
import aggressor.Prefs;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxFastOrganicLayout;
import com.mxgraph.layout.mxStackLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.view.mxInteractiveCanvas;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import common.CommonUtils;
import console.StatusBar;
import dialog.DialogUtils;
import graph.CircleLayout;
import graph.GraphPopup;
import graph.TouchMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;

public class NetworkGraph
extends JComponent
implements ActionListener {
    protected AggressorClient client = null;
    protected mxGraph graph;
    protected mxGraphComponent component;
    protected Object parent;
    protected boolean isAlive = true;
    protected String layout = null;
    protected boolean showDisconnected = true;
    protected Map nodeImages = new HashMap();
    protected GraphPopup popup = null;
    protected double zoom = 1.0;
    protected TouchMap nodes = new TouchMap();
    protected LinkedList edges = new LinkedList();
    public static final int DIRECTION_NONE = 0;
    public static final int DIRECTION_INBOUND = 1;
    public static final int DIRECTION_OUTBOUND = 2;
    protected Map tooltips = new HashMap();
    protected Set disconnected = new HashSet();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.isAlive = false;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void setShowDisconnected(boolean bl) {
        this.showDisconnected = bl;
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : NetworkGraph.this.nodes.entrySet()) {
                    String string = (String)entry.getKey();
                    mxCell mxCell2 = (mxCell)entry.getValue();
                    if (!NetworkGraph.this.disconnected.contains(string)) continue;
                    mxCell2.setVisible(NetworkGraph.this.showDisconnected);
                }
                NetworkGraph.this.autoLayout();
                NetworkGraph.this.graph.refresh();
            }
        });
    }

    public GraphPopup getGraphPopup() {
        return this.popup;
    }

    public void setGraphPopup(GraphPopup graphPopup) {
        this.popup = graphPopup;
    }

    public Image getScreenshot() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object v : this.nodes.values()) {
            linkedList.addAll(Arrays.asList(this.graph.getEdges(v)));
        }
        linkedList.addAll(this.nodes.values());
        return mxCellRenderer.createBufferedImage(this.graph, linkedList.toArray(), this.zoom, null, true, null, new _A());
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        this.component.setTransferHandler(transferHandler);
    }

    public void clearSelection() {
        this.graph.clearSelection();
    }

    public void selectAll() {
        this.graph.selectAll();
    }

    public NetworkGraph() {
        this(null);
    }

    public NetworkGraph(AggressorClient aggressorClient) {
        this.client = aggressorClient;
        mxConstants.VERTEX_SELECTION_COLOR = Prefs.getPreferences().getColor("graph.selection.color", "#00ff00");
        mxConstants.EDGE_SELECTION_COLOR = Prefs.getPreferences().getColor("graph.edge.color", "#3c6318");
        StatusBar.StatusBarHelper.setupStatusBar(this.getClass());
        this.graph = new mxGraph(){

            @Override
            public String getToolTipForCell(Object object) {
                if (NetworkGraph.this.tooltips.get(object) == null) {
                    return "";
                }
                return NetworkGraph.this.tooltips.get(object) + "";
            }
        };
        this.graph.setAutoOrigin(true);
        this.graph.setCellsEditable(false);
        this.graph.setCellsResizable(false);
        this.graph.setCellsBendable(false);
        this.graph.setAllowDanglingEdges(false);
        this.graph.setSplitEnabled(false);
        this.graph.setKeepEdgesInForeground(false);
        this.graph.setKeepEdgesInBackground(true);
        this.parent = this.graph.getDefaultParent();
        this.component = new _B(this.graph);
        this.component.setFoldingEnabled(true);
        this.component.setConnectable(false);
        this.component.setCenterPage(true);
        this.component.setToolTips(true);
        this.graph.setDropEnabled(true);
        new mxRubberband(this.component);
        this.B();
        this.layout = Prefs.getPreferences().getString("graph.default_layout.layout", "none");
        this.component.getViewport().setOpaque(false);
        this.component.setOpaque(true);
        this.component.setBackground(Prefs.getPreferences().getColor("graph.background.color", "#111111"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.component, "Center");
        this.A();
    }

    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        this.component.getActionMap().put(keyStroke.toString(), action);
        this.component.getInputMap().put(keyStroke, keyStroke.toString());
    }

    public void addActionForKey(String string, Action action) {
        this.addActionForKeyStroke(KeyStroke.getKeyStroke(string), action);
    }

    public void addActionForKeySetting(String string, String string2, Action action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
        if (keyStroke != null) {
            this.addActionForKeyStroke(keyStroke, action);
        }
    }

    public void doStackLayout() {
        if (this.layout != null) {
            this.layout = "stack";
        }
        mxStackLayout mxStackLayout2 = new mxStackLayout(this.graph, true, 25);
        mxStackLayout2.execute(this.parent);
    }

    public void doTreeLeftLayout() {
        if (this.layout != null) {
            this.layout = "tree-left";
        }
        mxHierarchicalLayout mxHierarchicalLayout2 = new mxHierarchicalLayout(this.graph, 7);
        mxHierarchicalLayout2.execute(this.parent);
    }

    public void doTreeRightLayout() {
        if (this.layout != null) {
            this.layout = "tree-right";
        }
        mxHierarchicalLayout mxHierarchicalLayout2 = new mxHierarchicalLayout(this.graph, 3);
        mxHierarchicalLayout2.execute(this.parent);
    }

    public void doTreeTopLayout() {
        if (this.layout != null) {
            this.layout = "tree-top";
        }
        mxHierarchicalLayout mxHierarchicalLayout2 = new mxHierarchicalLayout(this.graph, 1);
        mxHierarchicalLayout2.execute(this.parent);
    }

    public void doTreeBottomLayout() {
        if (this.layout != null) {
            this.layout = "tree-bottom";
        }
        mxHierarchicalLayout mxHierarchicalLayout2 = new mxHierarchicalLayout(this.graph, 5);
        mxHierarchicalLayout2.execute(this.parent);
    }

    public void doCircleLayout() {
        if (this.layout != null) {
            this.layout = "circle";
        }
        CircleLayout circleLayout = new CircleLayout(this.graph, 1.0);
        circleLayout.execute(this.parent);
    }

    public void doTreeLayout() {
        mxFastOrganicLayout mxFastOrganicLayout2 = new mxFastOrganicLayout(this.graph);
        mxFastOrganicLayout2.execute(this.parent);
    }

    private void A() {
        this.addActionForKeySetting("graph.clear_selection.shortcut", "pressed ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkGraph.this.clearSelection();
            }
        });
        this.addActionForKeySetting("graph.select_all.shortcut", "ctrl pressed A", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkGraph.this.selectAll();
            }
        });
        this.addActionForKeySetting("graph.zoom_in.shortcut", "ctrl pressed EQUALS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkGraph.this.zoom(0.1);
            }
        });
        this.addActionForKeySetting("graph.zoom_out.shortcut", "ctrl pressed MINUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkGraph.this.zoom(-0.1);
            }
        });
        this.addActionForKeySetting("graph.zoom_reset.shortcut", "ctrl pressed 0", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkGraph.this.resetZoom();
            }
        });
        this.addActionForKeySetting("graph.arrange_icons_stack.shortcut", "ctrl pressed S", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkGraph.this.doStackLayout();
            }
        });
        this.addActionForKeySetting("graph.arrange_icons_circle.shortcut", "ctrl pressed C", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkGraph.this.doCircleLayout();
            }
        });
        this.addActionForKeySetting("graph.arrange_icons_hierarchical.shortcut", "ctrl pressed H", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkGraph.this.doTreeLeftLayout();
            }
        });
    }

    public String getCellAt(Point point) {
        Point point2 = this.component.getViewport().getViewPosition();
        Point point3 = new Point((int)(point.getX() + point2.getX()), (int)(point.getY() + point2.getY()));
        mxCell mxCell2 = (mxCell)this.component.getCellAt((int)point3.getX(), (int)point3.getY());
        if (mxCell2 != null) {
            return mxCell2.getId();
        }
        return null;
    }

    public String[] getSelectedHosts() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Object[] objectArray = this.graph.getSelectionCells();
        for (int i = 0; i < objectArray.length; ++i) {
            mxCell mxCell2 = (mxCell)objectArray[i];
            if (!this.nodes.containsKey(mxCell2.getId()) || "".equals(mxCell2.getId())) continue;
            linkedList.add(mxCell2.getId());
        }
        String[] stringArray = new String[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next() + "";
            ++n;
        }
        return stringArray;
    }

    private void B() {
        this.component.getGraphControl().addMouseListener(new MouseAdapter(){

            public void A(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && NetworkGraph.this.getGraphPopup() != null) {
                    NetworkGraph.this.getGraphPopup().showGraphPopup(NetworkGraph.this.getSelectedHosts(), mouseEvent);
                    mouseEvent.consume();
                } else if (mouseEvent.getClickCount() >= 2 && !mouseEvent.isConsumed()) {
                    boolean bl = false;
                    String[] stringArray = NetworkGraph.this.getSelectedHosts();
                    if (stringArray.length > 0 && NetworkGraph.this.client != null) {
                        DialogUtils.openOrActivate(NetworkGraph.this.client, stringArray[0]);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }
        });
    }

    public void resetZoom() {
        this.zoom = 1.0;
        this.zoom(0.0);
    }

    public void zoom(double d) {
        this.zoom += d;
        this.component.zoomTo(this.zoom, true);
    }

    public void start() {
        this.graph.getModel().beginUpdate();
        this.nodes.startUpdates();
        for (Object object : this.edges) {
            this.graph.getModel().remove(object);
        }
        for (mxCell mxCell2 : this.nodes.values()) {
            mxCell2.setVisible(true);
        }
        this.edges = new LinkedList();
        this.disconnected = new HashSet();
    }

    public void setAutoLayout(String string) {
        this.layout = string;
        this.autoLayout();
    }

    public void autoLayout() {
        if (this.layout == null) {
            return;
        }
        if (this.layout.equals("circle")) {
            this.doCircleLayout();
        }
        if (this.layout.equals("stack")) {
            this.doStackLayout();
        }
        if (this.layout.equals("tree-left")) {
            this.doTreeLeftLayout();
        }
        if (this.layout.equals("tree-top")) {
            this.doTreeTopLayout();
        }
        if (this.layout.equals("tree-right")) {
            this.doTreeRightLayout();
        }
        if (this.layout.equals("tree-bottom")) {
            this.doTreeBottomLayout();
        }
    }

    public void end() {
        this.graph.getModel().endUpdate();
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                NetworkGraph.this.autoLayout();
                NetworkGraph.this.graph.refresh();
            }
        });
    }

    public void deleteNodes(String[] stringArray) {
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.nodes.remove(stringArray[i]);
        }
        this.graph.removeCells(objectArray, true);
    }

    public void deleteNodes() {
        List list = this.nodes.clearUntouched();
        Object[] objectArray = new Object[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            objectArray[n] = entry.getValue();
            ++n;
        }
        this.graph.removeCells(objectArray, true);
    }

    public void addEdge(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        mxCell mxCell2 = (mxCell)this.nodes.get(string);
        mxCell mxCell3 = (mxCell)this.nodes.get(string2);
        mxCell mxCell4 = (mxCell)this.graph.insertEdge(this.parent, null, string6, mxCell2, mxCell3);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("fontColor=" + Prefs.getPreferences().getString("graph.foreground.color", "#cccccc") + ";");
        Font font = Prefs.getPreferences().getFont("graph.font.font", "Monospaced BOLD 14");
        stringBuffer.append("fontSize=" + font.getSize() + ";");
        stringBuffer.append("fontFamily=" + font.getFamily() + ";");
        stringBuffer.append("fontStyle=" + font.getStyle() + ";");
        stringBuffer.append("strokeColor=" + string3 + ";strokeWidth=" + string4 + ";dashed=" + string5);
        if (n == 2) {
            stringBuffer.append(";startArrow=classic;endArrow=none");
        } else if (n == 1) {
            stringBuffer.append(";startArrow=none;endArrow=classic");
        } else if (n == 0) {
            stringBuffer.append(";startArrow=none;endArrow=none");
        }
        mxCell4.setStyle(stringBuffer.toString());
        this.edges.add(mxCell4);
    }

    public void disconnected(String string) {
        this.disconnected.add(string);
        mxCell mxCell2 = (mxCell)this.nodes.get(string);
        if (mxCell2 != null) {
            mxCell2.setVisible(this.showDisconnected);
        }
    }

    public Object addNode(String string, String string2, String string3, Image image, String string4, String string5) {
        mxCell mxCell2;
        this.nodeImages.put(string, image);
        if (string2.length() > 0) {
            string3 = string3.length() > 0 ? string3 + "\n" + string2 : string2;
        }
        if (!this.nodes.containsKey(string)) {
            mxCell2 = (mxCell)this.graph.insertVertex(this.parent, string, string3, 0.0, 0.0, 125.0, 97.0);
            this.nodes.put(string, mxCell2);
        } else {
            mxCell2 = (mxCell)this.nodes.get(string);
            mxCell2.setValue(string3);
        }
        this.nodes.touch(string);
        this.tooltips.put(mxCell2, string4);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("shape=image;image=" + string + ";");
        if ("good".equals(string5)) {
            stringBuffer.append("fontColor=#c6efce;");
        } else if ("bad".equals(string5)) {
            stringBuffer.append("fontColor=#ffc7ce;");
        } else if ("neutral".equals(string5)) {
            stringBuffer.append("fontColor=#ffeb9c;");
        } else if ("ignore".equals(string5)) {
            stringBuffer.append("fontColor=#a5a5a5;");
        } else if ("cancel".equals(string5)) {
            stringBuffer.append("fontColor=#3d579e;");
        } else {
            stringBuffer.append("fontColor=" + Prefs.getPreferences().getString("graph.foreground.color", "#cccccc") + ";");
        }
        Font font = Prefs.getPreferences().getFont("graph.font.font", "Monospaced BOLD 14");
        stringBuffer.append("fontSize=" + font.getSize() + ";");
        stringBuffer.append("fontFamily=" + font.getFamily() + ";");
        stringBuffer.append("fontStyle=" + font.getStyle() + ";");
        stringBuffer.append("verticalLabelPosition=bottom;verticalAlign=top");
        mxCell2.setStyle(stringBuffer.toString());
        return mxCell2;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.component.requestFocusInWindow();
    }

    private class _B
    extends mxGraphComponent {
        public _B(mxGraph mxGraph2) {
            super(mxGraph2);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.getHorizontalScrollBar().setUnitIncrement(15);
            this.getHorizontalScrollBar().setBlockIncrement(60);
            this.getVerticalScrollBar().setUnitIncrement(15);
            this.getVerticalScrollBar().setBlockIncrement(60);
        }

        @Override
        public mxInteractiveCanvas createCanvas() {
            return new _A();
        }
    }

    private class _A
    extends mxInteractiveCanvas {
        private _A() {
        }

        @Override
        public Image loadImage(String string) {
            if (NetworkGraph.this.nodeImages.containsKey(string)) {
                return (Image)NetworkGraph.this.nodeImages.get(string);
            }
            return super.loadImage(string);
        }
    }
}

