/*
 * Decompiled with CFR 0.152.
 */
package importers;

import common.CommonUtils;
import importers.ImportHandler;
import importers.Importer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class FlatFile
extends Importer {
    public FlatFile(ImportHandler importHandler) {
        super(importHandler);
    }

    public boolean isHostAndPort(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length == 2 && CommonUtils.isIP(stringArray[0])) {
            this.host(stringArray[0], null, null, 0.0);
            this.service(stringArray[0], stringArray[1], null);
            return true;
        }
        return false;
    }

    @Override
    public boolean parse(File file) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = bufferedReader.readLine();
        while (string != null) {
            if (!(string = string.trim()).startsWith("# ")) {
                if (CommonUtils.isIP(string)) {
                    this.host(string, null, null, 0.0);
                } else if (!this.isHostAndPort(string) && !"".equals(string)) {
                    bufferedReader.close();
                    return false;
                }
            }
            string = bufferedReader.readLine();
        }
        return true;
    }
}

