/*
 * Decompiled with CFR 0.152.
 */
package kerberos;

import common.DataParser;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import kerberos.Address;
import kerberos.AuthData;
import kerberos.KeyBlock;
import kerberos.Principal;
import kerberos.Times;

public class Credential {
    protected Principal client;
    protected Principal server;
    protected KeyBlock key;
    protected Times time;
    protected byte is_skey;
    protected int tktflags;
    protected List addresses = new LinkedList();
    protected List authdata = new LinkedList();
    protected String ticket;
    protected String second_ticket;

    public Credential(DataParser dataParser) throws IOException {
        int n;
        this.client = new Principal(dataParser);
        this.server = new Principal(dataParser);
        this.key = new KeyBlock(dataParser);
        this.time = new Times(dataParser);
        this.is_skey = (byte)dataParser.readChar();
        this.tktflags = dataParser.readInt();
        int n2 = dataParser.readInt();
        for (n = 0; n < n2; ++n) {
            this.addresses.add(new Address(dataParser));
        }
        n = dataParser.readInt();
        for (int i = 0; i < n; ++i) {
            this.authdata.add(new AuthData(dataParser));
        }
        this.ticket = dataParser.readCountedString();
        this.second_ticket = dataParser.readCountedString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Credential\n");
        stringBuffer.append("\tclient: " + this.client + "\n");
        stringBuffer.append("\tserver: " + this.client + "\n");
        stringBuffer.append("\tkey:    " + this.key + "\n");
        stringBuffer.append("\tticket: " + this.ticket.length() + "\n");
        stringBuffer.append("\tsecond: " + this.second_ticket.length() + "\n");
        return stringBuffer.toString();
    }
}

