/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;

public class KeyStoreUtils {
    private KeyStoreUtils() {
    }

    public static KeyStore load(File keystore, String storetype, String storepass, Provider provider) throws KeyStoreException {
        boolean filebased;
        KeyStore ks;
        if (keystore != null && storetype == null) {
            String filename = keystore.getName().toLowerCase();
            storetype = filename.endsWith(".p12") || filename.endsWith(".pfx") ? "PKCS12" : (filename.endsWith(".jceks") ? "JCEKS" : "JKS");
        }
        try {
            ks = provider != null ? KeyStore.getInstance(storetype, provider) : KeyStore.getInstance(storetype);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreException("keystore type '" + storetype + "' is not supported", e);
        }
        boolean bl = filebased = "JKS".equals(storetype) || "JCEKS".equals(storetype) || "PKCS12".equals(storetype);
        if (filebased && (keystore == null || !keystore.exists())) {
            throw new KeyStoreException("The keystore " + keystore + " couldn't be found");
        }
        try (FileInputStream in = !filebased ? null : new FileInputStream(keystore);){
            ks.load(in, storepass != null ? storepass.toCharArray() : null);
        }
        catch (Exception e) {
            throw new KeyStoreException("Unable to load the keystore " + keystore, e);
        }
        return ks;
    }
}

