/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.asn1.sec;

import java.util.Enumeration;
import net.jsign.bouncycastle.asn1.ASN1Encodable;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.ASN1Primitive;
import net.jsign.bouncycastle.asn1.ASN1Sequence;
import net.jsign.bouncycastle.asn1.ASN1TaggedObject;
import net.jsign.bouncycastle.asn1.DERBitString;

public class ECPrivateKey
extends ASN1Object {
    private ASN1Sequence seq;

    private ECPrivateKey(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
    }

    public static ECPrivateKey getInstance(Object object) {
        if (object instanceof ECPrivateKey) {
            return (ECPrivateKey)object;
        }
        if (object != null) {
            return new ECPrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public DERBitString getPublicKey() {
        return (DERBitString)this.getObjectInTag(1);
    }

    public ASN1Primitive getParameters() {
        return this.getObjectInTag(0);
    }

    private ASN1Primitive getObjectInTag(int n) {
        Enumeration enumeration = this.seq.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject;
            ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
            if (!(aSN1Encodable instanceof ASN1TaggedObject) || (aSN1TaggedObject = (ASN1TaggedObject)aSN1Encodable).getTagNo() != n) continue;
            return aSN1TaggedObject.getObject().toASN1Primitive();
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

