/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import net.jsign.bouncycastle.asn1.ASN1Encodable;
import net.jsign.bouncycastle.asn1.ASN1EncodableVector;
import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.asn1.ASN1OctetString;
import net.jsign.bouncycastle.asn1.ASN1Sequence;
import net.jsign.bouncycastle.asn1.ASN1Set;
import net.jsign.bouncycastle.asn1.BERSequence;
import net.jsign.bouncycastle.asn1.DLSet;
import net.jsign.bouncycastle.asn1.cms.ContentInfo;
import net.jsign.bouncycastle.asn1.cms.SignedData;
import net.jsign.bouncycastle.asn1.cms.SignerInfo;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.cert.X509CertificateHolder;
import net.jsign.bouncycastle.cms.CMSException;
import net.jsign.bouncycastle.cms.CMSProcessable;
import net.jsign.bouncycastle.cms.CMSProcessableByteArray;
import net.jsign.bouncycastle.cms.CMSSignedHelper;
import net.jsign.bouncycastle.cms.CMSTypedData;
import net.jsign.bouncycastle.cms.CMSUtils;
import net.jsign.bouncycastle.cms.PKCS7ProcessableObject;
import net.jsign.bouncycastle.cms.SignerInformation;
import net.jsign.bouncycastle.cms.SignerInformationStore;
import net.jsign.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import net.jsign.bouncycastle.util.Encodable;
import net.jsign.bouncycastle.util.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMSSignedData
implements Encodable {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    private static final DefaultDigestAlgorithmIdentifierFinder dgstAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
    SignedData signedData;
    ContentInfo contentInfo;
    CMSTypedData signedContent;
    SignerInformationStore signerInfoStore;
    private Map hashes;

    private CMSSignedData(CMSSignedData cMSSignedData) {
        this.signedData = cMSSignedData.signedData;
        this.contentInfo = cMSSignedData.contentInfo;
        this.signedContent = cMSSignedData.signedContent;
        this.signerInfoStore = cMSSignedData.signerInfoStore;
    }

    public CMSSignedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSSignedData(final CMSProcessable cMSProcessable, ContentInfo contentInfo) throws CMSException {
        this.signedContent = cMSProcessable instanceof CMSTypedData ? (CMSTypedData)cMSProcessable : new CMSTypedData(){

            public ASN1ObjectIdentifier getContentType() {
                return CMSSignedData.this.signedData.getEncapContentInfo().getContentType();
            }

            public void write(OutputStream outputStream) throws IOException, CMSException {
                cMSProcessable.write(outputStream);
            }

            public Object getContent() {
                return cMSProcessable.getContent();
            }
        };
        this.contentInfo = contentInfo;
        this.signedData = this.getSignedData();
    }

    public CMSSignedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        this.signedData = this.getSignedData();
        ASN1Encodable aSN1Encodable = this.signedData.getEncapContentInfo().getContent();
        this.signedContent = aSN1Encodable != null ? (aSN1Encodable instanceof ASN1OctetString ? new CMSProcessableByteArray(this.signedData.getEncapContentInfo().getContentType(), ((ASN1OctetString)aSN1Encodable).getOctets()) : new PKCS7ProcessableObject(this.signedData.getEncapContentInfo().getContentType(), aSN1Encodable)) : null;
    }

    private SignedData getSignedData() throws CMSException {
        try {
            return SignedData.getInstance(this.contentInfo.getContent());
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public SignerInformationStore getSignerInfos() {
        if (this.signerInfoStore == null) {
            ASN1Set aSN1Set = this.signedData.getSignerInfos();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            for (int i = 0; i != aSN1Set.size(); ++i) {
                SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
                ASN1ObjectIdentifier aSN1ObjectIdentifier = this.signedData.getEncapContentInfo().getContentType();
                if (this.hashes == null) {
                    arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, this.signedContent, null));
                    continue;
                }
                Object k = this.hashes.keySet().iterator().next();
                byte[] byArray = k instanceof String ? (byte[])this.hashes.get(signerInfo.getDigestAlgorithm().getAlgorithm().getId()) : (byte[])this.hashes.get(signerInfo.getDigestAlgorithm().getAlgorithm());
                arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, null, byArray));
            }
            this.signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this.signerInfoStore;
    }

    public Store<X509CertificateHolder> getCertificates() {
        return HELPER.getCertificates(this.signedData.getCertificates());
    }

    public String getSignedContentTypeOID() {
        return this.signedData.getEncapContentInfo().getContentType().getId();
    }

    public CMSTypedData getSignedContent() {
        return this.signedContent;
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public static CMSSignedData replaceSigners(CMSSignedData cMSSignedData, SignerInformationStore signerInformationStore) {
        CMSSignedData cMSSignedData2 = new CMSSignedData(cMSSignedData);
        cMSSignedData2.signerInfoStore = signerInformationStore;
        HashSet<AlgorithmIdentifier> hashSet = new HashSet<AlgorithmIdentifier>();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (SignerInformation object2 : signerInformationStore.getSigners()) {
            CMSUtils.addDigestAlgs(hashSet, object2, dgstAlgFinder);
            aSN1EncodableVector.add(object2.toASN1Structure());
        }
        ASN1Set aSN1Set = CMSUtils.convertToBERSet(hashSet);
        DLSet dLSet = new DLSet(aSN1EncodableVector);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)cMSSignedData.signedData.toASN1Primitive();
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(aSN1Sequence.getObjectAt(0));
        aSN1EncodableVector.add(aSN1Set);
        for (int i = 2; i != aSN1Sequence.size() - 1; ++i) {
            aSN1EncodableVector.add(aSN1Sequence.getObjectAt(i));
        }
        aSN1EncodableVector.add(dLSet);
        cMSSignedData2.signedData = SignedData.getInstance(new BERSequence(aSN1EncodableVector));
        cMSSignedData2.contentInfo = new ContentInfo(cMSSignedData2.contentInfo.getContentType(), cMSSignedData2.signedData);
        return cMSSignedData2;
    }
}

