/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.msi;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.SpcAttributeTypeAndOptionalValue;
import net.jsign.asn1.authenticode.SpcIndirectDataContent;
import net.jsign.asn1.authenticode.SpcSipInfo;
import net.jsign.asn1.authenticode.SpcUuid;
import net.jsign.bouncycastle.asn1.ASN1Encodable;
import net.jsign.bouncycastle.asn1.ASN1InputStream;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.DERNull;
import net.jsign.bouncycastle.asn1.cms.Attribute;
import net.jsign.bouncycastle.asn1.cms.AttributeTable;
import net.jsign.bouncycastle.asn1.cms.ContentInfo;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.asn1.x509.DigestInfo;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.bouncycastle.cms.SignerInformation;
import net.jsign.msi.MSIStreamName;
import net.jsign.poi.poifs.filesystem.DocumentEntry;
import net.jsign.poi.poifs.filesystem.DocumentInputStream;
import net.jsign.poi.poifs.filesystem.POIFSDocument;
import net.jsign.poi.poifs.filesystem.POIFSFileSystem;
import net.jsign.poi.poifs.property.DirectoryProperty;
import net.jsign.poi.poifs.property.DocumentProperty;
import net.jsign.poi.poifs.property.Property;
import net.jsign.poi.util.IOUtils;

public class MSIFile
implements Closeable,
Signable {
    private static final long MSI_HEADER = -3400479537158350111L;
    private static final String DIGITAL_SIGNATURE_ENTRY_NAME = "\u0005DigitalSignature";
    private static final String MSI_DIGITAL_SIGNATURE_EX_ENTRY_NAME = "\u0005MsiDigitalSignatureEx";
    private final POIFSFileSystem fs;
    private SeekableByteChannel channel;

    public static boolean isMSIFile(File file) throws IOException {
        try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
            boolean bl = in.readLong() == -3400479537158350111L;
            return bl;
        }
    }

    public MSIFile(File file) throws IOException {
        this.fs = new POIFSFileSystem(file, false);
    }

    public MSIFile(SeekableByteChannel channel) throws IOException {
        this.channel = channel;
        FilterInputStream in = new FilterInputStream(Channels.newInputStream(channel)){

            @Override
            public void close() {
            }
        };
        this.fs = new POIFSFileSystem(in);
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public boolean hasExtendedSignature() {
        try {
            this.fs.getRoot().getEntry(MSI_DIGITAL_SIGNATURE_EX_ENTRY_NAME);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    private List<Property> getSortedProperties() {
        ArrayList<Property> entries = new ArrayList<Property>();
        this.append(this.fs.getPropertyTable().getRoot(), entries);
        return entries;
    }

    private void append(DirectoryProperty node, List<Property> entries) {
        TreeMap<MSIStreamName, Property> sortedEntries = new TreeMap<MSIStreamName, Property>();
        for (Property entry : node) {
            sortedEntries.put(new MSIStreamName(entry.getName()), entry);
        }
        for (Property property : sortedEntries.values()) {
            if (!property.isDirectory()) {
                entries.add(property);
                continue;
            }
            this.append((DirectoryProperty)property, entries);
        }
    }

    @Override
    public byte[] computeDigest(MessageDigest digest) {
        for (Property property : this.getSortedProperties()) {
            String name = new MSIStreamName(property.getName()).decode();
            if (name.equals(DIGITAL_SIGNATURE_ENTRY_NAME) || name.equals(MSI_DIGITAL_SIGNATURE_EX_ENTRY_NAME)) continue;
            POIFSDocument document = new POIFSDocument((DocumentProperty)property, this.fs);
            long remaining = document.getSize();
            for (ByteBuffer buffer : document) {
                int size = buffer.remaining();
                buffer.limit(buffer.position() + (int)Math.min(remaining, (long)size));
                digest.update(buffer);
                remaining -= (long)size;
            }
        }
        byte[] classId = new byte[16];
        this.fs.getRoot().getStorageClsid().write(classId, 0);
        digest.update(classId);
        return digest.digest();
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgorithm.oid, DERNull.INSTANCE);
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, this.computeDigest(digestAlgorithm.getMessageDigest()));
        SpcUuid uuid = new SpcUuid("F1100C00-0000-0000-C000-000000000046");
        SpcAttributeTypeAndOptionalValue data = new SpcAttributeTypeAndOptionalValue(AuthenticodeObjectIdentifiers.SPC_SIPINFO_OBJID, new SpcSipInfo(1, uuid));
        return new SpcIndirectDataContent(data, digestInfo);
    }

    @Override
    public List<CMSSignedData> getSignatures() throws IOException {
        ArrayList<CMSSignedData> signatures;
        block7: {
            signatures = new ArrayList<CMSSignedData>();
            try {
                DocumentEntry digitalSignature = (DocumentEntry)this.fs.getRoot().getEntry(DIGITAL_SIGNATURE_ENTRY_NAME);
                if (digitalSignature == null) break block7;
                byte[] signatureBytes = IOUtils.toByteArray(new DocumentInputStream(digitalSignature));
                try {
                    Attribute nestedSignatures;
                    CMSSignedData signedData = new CMSSignedData(null, ContentInfo.getInstance(new ASN1InputStream(signatureBytes).readObject()));
                    signatures.add(signedData);
                    SignerInformation signerInformation = signedData.getSignerInfos().getSigners().iterator().next();
                    AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
                    if (unsignedAttributes != null && (nestedSignatures = unsignedAttributes.get(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID)) != null) {
                        for (ASN1Encodable nestedSignature : nestedSignatures.getAttrValues()) {
                            signatures.add(new CMSSignedData(null, ContentInfo.getInstance(nestedSignature)));
                        }
                    }
                }
                catch (UnsupportedOperationException signedData) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return signatures;
    }

    @Override
    public void setSignature(CMSSignedData signature) throws IOException {
        byte[] signatureBytes = signature.toASN1Structure().getEncoded("DER");
        this.fs.getRoot().createOrUpdateDocument(DIGITAL_SIGNATURE_ENTRY_NAME, new ByteArrayInputStream(signatureBytes));
    }

    @Override
    public void save() throws IOException {
        if (this.channel == null) {
            this.fs.writeFilesystem();
        } else {
            this.channel.position(0L);
            this.fs.writeFilesystem(Channels.newOutputStream(this.channel));
            this.channel.truncate(this.channel.position());
        }
    }
}

