/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.poi.poifs.filesystem;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import net.jsign.poi.poifs.filesystem.DirectoryNode;
import net.jsign.poi.poifs.filesystem.DocumentNode;
import net.jsign.poi.poifs.filesystem.POIFSFileSystem;
import net.jsign.poi.poifs.filesystem.POIFSStream;
import net.jsign.poi.poifs.property.DocumentProperty;
import net.jsign.poi.util.IOUtils;

public final class POIFSDocument
implements Iterable<ByteBuffer> {
    private DocumentProperty _property;
    private POIFSFileSystem _filesystem;
    private POIFSStream _stream;
    private int _block_size;

    public POIFSDocument(DocumentNode document) {
        this((DocumentProperty)document.getProperty(), ((DirectoryNode)document.getParent()).getFileSystem());
    }

    public POIFSDocument(DocumentProperty property, POIFSFileSystem filesystem) {
        this._property = property;
        this._filesystem = filesystem;
        if (property.getSize() < 4096) {
            this._stream = new POIFSStream(this._filesystem.getMiniStore(), property.getStartBlock());
            this._block_size = this._filesystem.getMiniStore().getBlockStoreBlockSize();
        } else {
            this._stream = new POIFSStream(this._filesystem, property.getStartBlock());
            this._block_size = this._filesystem.getBlockStoreBlockSize();
        }
    }

    public POIFSDocument(String name, POIFSFileSystem filesystem, InputStream stream) throws IOException {
        this._filesystem = filesystem;
        int length = this.store(stream);
        this._property = new DocumentProperty(name, length);
        this._property.setStartBlock(this._stream.getStartBlock());
        this._property.setDocument(this);
    }

    private int store(InputStream stream) throws IOException {
        long length;
        int bigBlockSize = 4096;
        BufferedInputStream bis = new BufferedInputStream(stream, 4097);
        bis.mark(4096);
        long streamBlockSize = IOUtils.skipFully(bis, 4096L);
        if (streamBlockSize < 4096L) {
            this._stream = new POIFSStream(this._filesystem.getMiniStore());
            this._block_size = this._filesystem.getMiniStore().getBlockStoreBlockSize();
        } else {
            this._stream = new POIFSStream(this._filesystem);
            this._block_size = this._filesystem.getBlockStoreBlockSize();
        }
        bis.reset();
        try (OutputStream os = this._stream.getOutputStream();){
            length = IOUtils.copy(bis, os);
            int usedInBlock = (int)(length % (long)this._block_size);
            if (usedInBlock != 0 && usedInBlock != this._block_size) {
                int toBlockEnd = this._block_size - usedInBlock;
                byte[] padding = IOUtils.safelyAllocate(toBlockEnd, 100000);
                Arrays.fill(padding, (byte)-1);
                os.write(padding);
            }
        }
        return Math.toIntExact(length);
    }

    void free() throws IOException {
        this._stream.free();
        this._property.setStartBlock(-2);
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.getBlockIterator();
    }

    Iterator<ByteBuffer> getBlockIterator() {
        return (this.getSize() > 0 ? this._stream : Collections.emptyList()).iterator();
    }

    public int getSize() {
        return this._property.getSize();
    }

    public void replaceContents(InputStream stream) throws IOException {
        this.free();
        int size = this.store(stream);
        this._property.setStartBlock(this._stream.getStartBlock());
        this._property.updateSize(size);
    }

    DocumentProperty getDocumentProperty() {
        return this._property;
    }
}

