/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework;

import java.io.Serializable;
import java.util.StringTokenizer;

public final class Version
implements Comparable,
Serializable {
    private int m_major;
    private int m_minor;
    private int m_micro;

    public static Version getVersion(String version) throws NumberFormatException, IllegalArgumentException {
        if (version == null) {
            throw new NullPointerException("version");
        }
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        String[] levels = new String[tokenizer.countTokens()];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = tokenizer.nextToken();
        }
        int major = -1;
        if (0 < levels.length) {
            major = Integer.parseInt(levels[0]);
        }
        int minor = 0;
        if (1 < levels.length) {
            minor = Integer.parseInt(levels[1]);
        }
        int micro = 0;
        if (2 < levels.length) {
            micro = Integer.parseInt(levels[2]);
        }
        return new Version(major, minor, micro);
    }

    public Version(int major, int minor, int micro) {
        this.m_major = major;
        this.m_minor = minor;
        this.m_micro = micro;
    }

    public int getMajor() {
        return this.m_major;
    }

    public int getMinor() {
        return this.m_minor;
    }

    public int getMicro() {
        return this.m_micro;
    }

    public boolean equals(Version other) {
        boolean isEqual;
        if (other == null) {
            return false;
        }
        boolean bl = isEqual = this.getMajor() == other.getMajor();
        if (isEqual) {
            boolean bl2 = isEqual = this.getMinor() == other.getMinor();
        }
        if (isEqual) {
            isEqual = this.getMicro() == other.getMicro();
        }
        return isEqual;
    }

    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other instanceof Version) {
            isEqual = this.equals((Version)other);
        }
        return isEqual;
    }

    public int hashCode() {
        int hash2 = this.getMajor();
        hash2 >>>= 17;
        hash2 += this.getMinor();
        hash2 >>>= 17;
        return hash2 += this.getMicro();
    }

    public boolean complies(Version other) {
        if (other == null) {
            return false;
        }
        if (other.m_major == -1) {
            return true;
        }
        if (this.m_major != other.m_major) {
            return false;
        }
        if (this.m_minor < other.m_minor) {
            return false;
        }
        return this.m_minor != other.m_minor || this.m_micro >= other.m_micro;
    }

    public String toString() {
        return this.m_major + "." + this.m_minor + "." + this.m_micro;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        Version other = (Version)o;
        int val = 0;
        if (this.getMajor() < other.getMajor()) {
            val = -1;
        }
        if (0 == val && this.getMajor() > other.getMajor()) {
            val = 1;
        }
        if (0 == val && this.getMinor() < other.getMinor()) {
            val = -1;
        }
        if (0 == val && this.getMinor() > other.getMinor()) {
            val = 1;
        }
        if (0 == val && this.getMicro() < other.getMicro()) {
            val = -1;
        }
        if (0 == val && this.getMicro() > other.getMicro()) {
            val = 1;
        }
        return val;
    }
}

