/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.net.URI;

public class AFPResourceLevel {
    private URI extUri;
    private final ResourceType resourceType;

    public static AFPResourceLevel valueOf(String levelString) {
        ResourceType resType = ResourceType.getValueOf(levelString);
        return resType != null ? new AFPResourceLevel(resType) : null;
    }

    public AFPResourceLevel(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public boolean isPage() {
        return this.resourceType == ResourceType.PAGE;
    }

    public boolean isPageGroup() {
        return this.resourceType == ResourceType.PAGE_GROUP;
    }

    public boolean isDocument() {
        return this.resourceType == ResourceType.DOCUMENT;
    }

    public boolean isExternal() {
        return this.resourceType == ResourceType.EXTERNAL;
    }

    public boolean isPrintFile() {
        return this.resourceType == ResourceType.PRINT_FILE;
    }

    public boolean isInline() {
        return this.resourceType == ResourceType.INLINE;
    }

    public URI getExternalURI() {
        return this.extUri;
    }

    public void setExternalUri(URI uri) {
        this.extUri = uri;
    }

    public String toString() {
        return (Object)((Object)this.resourceType) + (this.isExternal() ? ", uri=" + this.extUri : "");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AFPResourceLevel)) {
            return false;
        }
        AFPResourceLevel rl = (AFPResourceLevel)obj;
        return this.resourceType == rl.resourceType && (this.extUri == rl.extUri || this.extUri != null && this.extUri.equals(rl.extUri));
    }

    public int hashCode() {
        int hash2 = 7;
        hash2 = 31 * hash2 + this.resourceType.hashCode();
        hash2 = 31 * hash2 + (null == this.extUri ? 0 : this.extUri.hashCode());
        return hash2;
    }

    public static enum ResourceType {
        INLINE("inline"),
        PAGE("page"),
        PAGE_GROUP("page-group"),
        DOCUMENT("document"),
        PRINT_FILE("print-file"),
        EXTERNAL("external");

        private final String name;

        private ResourceType(String name) {
            this.name = name;
        }

        public static ResourceType getValueOf(String levelString) {
            for (ResourceType resType : ResourceType.values()) {
                if (!resType.name.equalsIgnoreCase(levelString)) continue;
                return resType;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

