/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.intermediate.GraphicsPainter;
import org.apache.fop.render.java2d.Java2DGraphicsState;
import org.apache.fop.render.java2d.Java2DPainter;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.ColorUtil;

class Java2DGraphicsPainter
implements GraphicsPainter {
    static final Log log = LogFactory.getLog(Java2DGraphicsPainter.class);
    private GeneralPath currentPath;
    private final Java2DPainter painter;

    Java2DGraphicsPainter(Java2DPainter painter) {
        this.painter = painter;
    }

    private Java2DGraphicsState getG2DState() {
        return this.painter.g2dState;
    }

    private Graphics2D getG2D() {
        return this.getG2DState().getGraph();
    }

    @Override
    public void drawBorderLine(int x1, int y1, int x2, int y2, boolean horz, boolean startOrBefore, int style, Color color) throws IOException {
        float w = x2 - x1;
        float h = y2 - y1;
        if (w < 0.0f || h < 0.0f) {
            log.error("Negative extent received. Border won't be painted.");
            return;
        }
        switch (style) {
            case 31: {
                this.getG2D().setColor(color);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    float ym = (float)y1 + h / 2.0f;
                    BasicStroke s = new BasicStroke(h, 0, 0, 10.0f, new float[]{unit}, 0.0f);
                    this.getG2D().setStroke(s);
                    this.getG2D().draw(new Line2D.Float(x1, ym, x2, ym));
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                float xm = (float)x1 + w / 2.0f;
                BasicStroke s = new BasicStroke(w, 0, 0, 10.0f, new float[]{unit}, 0.0f);
                this.getG2D().setStroke(s);
                this.getG2D().draw(new Line2D.Float(xm, y1, xm, y2));
                break;
            }
            case 36: {
                this.getG2D().setColor(color);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    float ym = (float)y1 + h / 2.0f;
                    BasicStroke s = new BasicStroke(h, 1, 0, 10.0f, new float[]{0.0f, unit}, 0.0f);
                    this.getG2D().setStroke(s);
                    this.getG2D().draw(new Line2D.Float(x1, ym, x2, ym));
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                float xm = (float)x1 + w / 2.0f;
                BasicStroke s = new BasicStroke(w, 1, 0, 10.0f, new float[]{0.0f, unit}, 0.0f);
                this.getG2D().setStroke(s);
                this.getG2D().draw(new Line2D.Float(xm, y1, xm, y2));
                break;
            }
            case 37: {
                this.getG2D().setColor(color);
                if (horz) {
                    float h3 = h / 3.0f;
                    float ym1 = (float)y1 + h3 / 2.0f;
                    float ym2 = ym1 + h3 + h3;
                    BasicStroke s = new BasicStroke(h3);
                    this.getG2D().setStroke(s);
                    this.getG2D().draw(new Line2D.Float(x1, ym1, x2, ym1));
                    this.getG2D().draw(new Line2D.Float(x1, ym2, x2, ym2));
                    break;
                }
                float w3 = w / 3.0f;
                float xm1 = (float)x1 + w3 / 2.0f;
                float xm2 = xm1 + w3 + w3;
                BasicStroke s = new BasicStroke(w3);
                this.getG2D().setStroke(s);
                this.getG2D().draw(new Line2D.Float(xm1, y1, xm1, y2));
                this.getG2D().draw(new Line2D.Float(xm2, y1, xm2, y2));
                break;
            }
            case 55: 
            case 119: {
                float colFactor;
                float f = colFactor = style == 55 ? 0.4f : -0.4f;
                if (horz) {
                    Color uppercol = ColorUtil.lightenColor(color, -colFactor);
                    Color lowercol = ColorUtil.lightenColor(color, colFactor);
                    float h3 = h / 3.0f;
                    float ym1 = (float)y1 + h3 / 2.0f;
                    this.getG2D().setStroke(new BasicStroke(h3));
                    this.getG2D().setColor(uppercol);
                    this.getG2D().draw(new Line2D.Float(x1, ym1, x2, ym1));
                    this.getG2D().setColor(color);
                    this.getG2D().draw(new Line2D.Float(x1, ym1 + h3, x2, ym1 + h3));
                    this.getG2D().setColor(lowercol);
                    this.getG2D().draw(new Line2D.Float(x1, ym1 + h3 + h3, x2, ym1 + h3 + h3));
                    break;
                }
                Color leftcol = ColorUtil.lightenColor(color, -colFactor);
                Color rightcol = ColorUtil.lightenColor(color, colFactor);
                float w3 = w / 3.0f;
                float xm1 = (float)x1 + w3 / 2.0f;
                this.getG2D().setStroke(new BasicStroke(w3));
                this.getG2D().setColor(leftcol);
                this.getG2D().draw(new Line2D.Float(xm1, y1, xm1, y2));
                this.getG2D().setColor(color);
                this.getG2D().draw(new Line2D.Float(xm1 + w3, y1, xm1 + w3, y2));
                this.getG2D().setColor(rightcol);
                this.getG2D().draw(new Line2D.Float(xm1 + w3 + w3, y1, xm1 + w3 + w3, y2));
                break;
            }
            case 67: 
            case 101: {
                float colFactor;
                float f = colFactor = style == 101 ? 0.4f : -0.4f;
                if (horz) {
                    color = ColorUtil.lightenColor(color, (float)(startOrBefore ? 1 : -1) * colFactor);
                    this.getG2D().setStroke(new BasicStroke(h));
                    float ym1 = (float)y1 + h / 2.0f;
                    this.getG2D().setColor(color);
                    this.getG2D().draw(new Line2D.Float(x1, ym1, x2, ym1));
                    break;
                }
                color = ColorUtil.lightenColor(color, (float)(startOrBefore ? 1 : -1) * colFactor);
                float xm1 = (float)x1 + w / 2.0f;
                this.getG2D().setStroke(new BasicStroke(w));
                this.getG2D().setColor(color);
                this.getG2D().draw(new Line2D.Float(xm1, y1, xm1, y2));
                break;
            }
            case 57: {
                break;
            }
            default: {
                this.getG2D().setColor(color);
                if (horz) {
                    float ym = (float)y1 + h / 2.0f;
                    this.getG2D().setStroke(new BasicStroke(h));
                    this.getG2D().draw(new Line2D.Float(x1, ym, x2, ym));
                    break;
                }
                float xm = (float)x1 + w / 2.0f;
                this.getG2D().setStroke(new BasicStroke(w));
                this.getG2D().draw(new Line2D.Float(xm, y1, xm, y2));
            }
        }
    }

    @Override
    public void drawLine(Point start, Point end, int width, Color color, RuleStyle style) throws IOException {
        if (start.y != end.y) {
            throw new UnsupportedOperationException("Can only deal with horizontal lines right now");
        }
        this.saveGraphicsState();
        int half = width / 2;
        int starty = start.y - half;
        Rectangle boundingRect = new Rectangle(start.x, start.y - half, end.x - start.x, width);
        this.getG2DState().updateClip(boundingRect);
        switch (style.getEnumValue()) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(start.x, start.y - half, end.x, end.y + half, true, true, style.getEnumValue(), color);
                break;
            }
            case 36: {
                int shift2 = half;
                this.drawBorderLine(start.x + shift2, start.y - half, end.x + shift2, end.y + half, true, true, style.getEnumValue(), color);
                break;
            }
            case 55: 
            case 119: {
                this.getG2DState().updateColor(ColorUtil.lightenColor(color, 0.6f));
                this.moveTo(start.x, starty);
                this.lineTo(end.x, starty);
                this.lineTo(end.x, starty + 2 * half);
                this.lineTo(start.x, starty + 2 * half);
                this.closePath();
                this.getG2D().fill(this.currentPath);
                this.currentPath = null;
                this.getG2DState().updateColor(color);
                if (style.getEnumValue() == 55) {
                    this.moveTo(start.x, starty);
                    this.lineTo(end.x, starty);
                    this.lineTo(end.x, starty + half);
                    this.lineTo(start.x + half, starty + half);
                    this.lineTo(start.x, starty + 2 * half);
                } else {
                    this.moveTo(end.x, starty);
                    this.lineTo(end.x, starty + 2 * half);
                    this.lineTo(start.x, starty + 2 * half);
                    this.lineTo(start.x, starty + half);
                    this.lineTo(end.x - half, starty + half);
                }
                this.closePath();
                this.getG2D().fill(this.currentPath);
                this.currentPath = null;
                break;
            }
            case 95: {
                break;
            }
        }
        this.restoreGraphicsState();
    }

    @Override
    public void moveTo(int x, int y) throws IOException {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.moveTo(x, y);
    }

    @Override
    public void lineTo(int x, int y) throws IOException {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.lineTo(x, y);
    }

    @Override
    public void arcTo(double startAngle, double endAngle, int cx, int cy, int width, int height) throws IOException {
    }

    @Override
    public void rotateCoordinates(double angle) throws IOException {
    }

    @Override
    public void translateCoordinates(int xTranslate, int yTranslate) throws IOException {
    }

    @Override
    public void scaleCoordinates(float xScale, float yScale) throws IOException {
    }

    @Override
    public void closePath() throws IOException {
        this.currentPath.closePath();
    }

    @Override
    public void clip() throws IOException {
        if (this.currentPath == null) {
            throw new IllegalStateException("No current path available!");
        }
        this.getG2DState().updateClip(this.currentPath);
        this.currentPath = null;
    }

    @Override
    public void saveGraphicsState() throws IOException {
        this.painter.saveGraphicsState();
    }

    @Override
    public void restoreGraphicsState() throws IOException {
        this.painter.restoreGraphicsState();
        this.currentPath = null;
    }
}

