/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.ps.NativeTextHandler;
import org.apache.fop.render.ps.PSBridgeContext;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.apache.fop.svg.PDFDocumentGraphics2DConfigurator;
import org.apache.fop.svg.font.FOPFontFamilyResolverImpl;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.AbstractPSDocumentGraphics2D;
import org.w3c.dom.Document;

public abstract class AbstractPSTranscoder
extends AbstractFOPTranscoder {
    protected AbstractPSDocumentGraphics2D graphics;
    private FontInfo fontInfo;

    protected abstract AbstractPSDocumentGraphics2D createDocumentGraphics2D();

    @Override
    protected boolean getAutoFontsDefault() {
        return false;
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        this.graphics = this.createDocumentGraphics2D();
        if (!this.isTextStroked()) {
            try {
                boolean useComplexScriptFeatures = false;
                this.fontInfo = PDFDocumentGraphics2DConfigurator.createFontInfo(this.getEffectiveConfiguration(), useComplexScriptFeatures);
                this.graphics.setCustomTextHandler(new NativeTextHandler(this.graphics, this.fontInfo));
                ((AbstractFOPTranscoder.FOPTranscoderUserAgent)((Object)this.userAgent)).setFontFamilyResolver(new FOPFontFamilyResolverImpl(this.fontInfo));
            }
            catch (FOPException fe) {
                throw new TranscoderException((Exception)fe);
            }
        }
        super.transcode(document, uri, output);
        this.getLogger().trace("document size: " + this.width + " x " + this.height);
        UnitProcessor.Context uctx = UnitProcessor.createContext(this.ctx, document.getDocumentElement());
        float widthInPt = UnitProcessor.userSpaceToSVG(this.width, (short)9, (short)2, uctx);
        int w = (int)((double)widthInPt + 0.5);
        float heightInPt = UnitProcessor.userSpaceToSVG(this.height, (short)9, (short)2, uctx);
        int h = (int)((double)heightInPt + 0.5);
        this.getLogger().trace("document size: " + w + "pt x " + h + "pt");
        try {
            OutputStream out = output.getOutputStream();
            if (!(out instanceof BufferedOutputStream)) {
                out = new BufferedOutputStream(out);
            }
            this.graphics.setupDocument(out, w, h);
            this.graphics.setViewportDimension(this.width, this.height);
            if (this.hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
                this.graphics.setBackgroundColor((Color)this.hints.get((Object)ImageTranscoder.KEY_BACKGROUND_COLOR));
            }
            this.graphics.setGraphicContext(new GraphicContext());
            this.graphics.setTransform(this.curTxf);
            this.root.paint(this.graphics);
            this.graphics.finish();
        }
        catch (IOException ex) {
            throw new TranscoderException((Exception)ex);
        }
    }

    protected BridgeContext createBridgeContext() {
        return this.createBridgeContext("1.x");
    }

    public BridgeContext createBridgeContext(String version) {
        PSBridgeContext ctx = new PSBridgeContext(this.userAgent, this.isTextStroked() ? null : this.fontInfo, this.getImageManager(), this.getImageSessionContext());
        return ctx;
    }
}

