/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.Version;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.apache.fop.svg.PDFBridgeContext;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFDocumentGraphics2DConfigurator;
import org.apache.fop.svg.font.FOPFontFamilyResolverImpl;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.w3c.dom.Document;

public class PDFTranscoder
extends AbstractFOPTranscoder {
    protected PDFDocumentGraphics2D graphics;

    public PDFTranscoder() {
        this.handler = new AbstractFOPTranscoder.FOPErrorHandler();
    }

    @Override
    protected AbstractFOPTranscoder.FOPTranscoderUserAgent createUserAgent() {
        return new AbstractFOPTranscoder.FOPTranscoderUserAgent(){

            @Override
            public float getPixelUnitToMillimeter() {
                return super.getPixelUnitToMillimeter();
            }
        };
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        this.graphics = new PDFDocumentGraphics2D(this.isTextStroked());
        this.graphics.getPDFDocument().getInfo().setProducer("Apache FOP Version " + Version.getVersion() + ": PDF Transcoder for Batik");
        if (this.hints.containsKey((Object)KEY_DEVICE_RESOLUTION)) {
            this.graphics.setDeviceDPI(this.getDeviceResolution());
        }
        this.setupImageInfrastructure(uri);
        try {
            Configuration effCfg = this.getEffectiveConfiguration();
            if (effCfg != null) {
                PDFDocumentGraphics2DConfigurator configurator = new PDFDocumentGraphics2DConfigurator();
                boolean useComplexScriptFeatures = false;
                configurator.configure(this.graphics, effCfg, useComplexScriptFeatures);
            } else {
                this.graphics.setupDefaultFontInfo();
            }
            ((AbstractFOPTranscoder.FOPTranscoderUserAgent)((Object)this.userAgent)).setFontFamilyResolver(new FOPFontFamilyResolverImpl(this.graphics.getFontInfo()));
        }
        catch (Exception e) {
            throw new TranscoderException("Error while setting up PDFDocumentGraphics2D", e);
        }
        super.transcode(document, uri, output);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("document size: " + this.width + " x " + this.height);
        }
        UnitProcessor.Context uctx = UnitProcessor.createContext(this.ctx, document.getDocumentElement());
        float widthInPt = UnitProcessor.userSpaceToSVG(this.width, (short)9, (short)2, uctx);
        int w = (int)((double)widthInPt + 0.5);
        float heightInPt = UnitProcessor.userSpaceToSVG(this.height, (short)9, (short)2, uctx);
        int h = (int)((double)heightInPt + 0.5);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("document size: " + w + "pt x " + h + "pt");
        }
        try {
            OutputStream out = output.getOutputStream();
            if (!(out instanceof BufferedOutputStream)) {
                out = new BufferedOutputStream(out);
            }
            this.graphics.setupDocument(out, w, h);
            this.graphics.setSVGDimension(this.width, this.height);
            if (this.hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
                this.graphics.setBackgroundColor((Color)this.hints.get((Object)ImageTranscoder.KEY_BACKGROUND_COLOR));
            }
            this.graphics.setGraphicContext(new GraphicContext());
            this.graphics.preparePainting();
            this.graphics.transform(this.curTxf);
            this.graphics.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, "Vector");
            this.root.paint(this.graphics);
            this.graphics.finish();
        }
        catch (IOException ex) {
            throw new TranscoderException((Exception)ex);
        }
    }

    protected BridgeContext createBridgeContext() {
        return this.createBridgeContext("1.x");
    }

    public BridgeContext createBridgeContext(String version) {
        FontInfo fontInfo = this.graphics.getFontInfo();
        if (this.isTextStroked()) {
            fontInfo = null;
        }
        PDFBridgeContext ctx = new PDFBridgeContext(this.userAgent, fontInfo, this.getImageManager(), this.getImageSessionContext());
        return ctx;
    }
}

