/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import org.apache.james.mime4j.util.LangUtils;

public final class NameValuePair {
    private final String name;
    private final String value;

    public NameValuePair(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return this.name;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name);
        buffer.append("=");
        buffer.append("\"");
        buffer.append(this.value);
        buffer.append("\"");
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NameValuePair) {
            NameValuePair that = (NameValuePair)object;
            return this.name.equals(that.name) && LangUtils.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = LangUtils.hashCode(hash2, this.name);
        hash2 = LangUtils.hashCode(hash2, this.value);
        return hash2;
    }
}

