/*
 * Decompiled with CFR 0.152.
 */
package pe;

import common.Manipulator;
import common.MudgeSanity;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import pe.OBJParser;
import pe.Relocation;

public class OBJExecutableSimple {
    protected OBJParser info = null;
    protected Manipulator data;
    protected List errors = new LinkedList();
    protected String exesect = "";

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public String getErrors() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.errors) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void error(String string) {
        this.errors.add(string);
    }

    public OBJExecutableSimple(byte[] byArray) {
        this.data = new Manipulator(byArray);
        this.data.little();
    }

    public OBJParser getInfo() {
        return this.info;
    }

    public void parse() {
        try {
            this.info = OBJParser.load(this.data.getBytes());
            this.exesect = this.info.hasSection(".text") ? ".text" : this.info.getExeSect();
        }
        catch (Exception exception) {
            this.error(exception.getMessage());
            MudgeSanity.logException("Error parsing object file", exception, false);
            return;
        }
    }

    public byte[] getCode() {
        int n = this.info.sectionStart(this.exesect);
        int n2 = this.info.sectionSize(this.exesect);
        if (n2 == 0) {
            this.error("No .text section in object file");
        }
        return Arrays.copyOfRange(this.data.getBytes(), n, n + n2);
    }

    public int getCodeSize() {
        return this.info.sectionSize(this.exesect);
    }

    public void processRelocations() {
        for (int i = 0; i < this.info.relocationsCount(this.exesect); ++i) {
            Relocation relocation = this.info.getRelocation(this.exesect, i);
            if (this.exesect.equals(relocation.getSection())) {
                if (relocation.getType() == 20 || relocation.getType() == 4) {
                    int n = this.info.sectionStart(this.exesect);
                    int n2 = this.data.getInt(n + relocation.getOffset());
                    int n3 = relocation.getOffsetInSection() - (relocation.getOffset() + 4);
                    this.data.setLong(n + relocation.getOffset(), n3);
                    continue;
                }
                this.error("Unknown relocation type: " + relocation.getType() + " for " + relocation.getSymbol() + " in " + relocation.getSection());
                continue;
            }
            this.error("Unknown symbol '" + relocation.getSymbol() + "' from: " + relocation.getSection());
        }
    }
}

