/*
 * Decompiled with CFR 0.152.
 */
package pe;

import common.AssertUtils;
import common.CommonUtils;
import common.MudgeSanity;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import pe.Relocation;

public class OBJParser {
    protected DataInputStream content = null;
    protected byte[] bdata = new byte[8];
    protected ByteBuffer buffer = null;
    protected Map values = new HashMap();
    protected byte[] original;
    protected Stack frames = new Stack();
    protected Map locations = new HashMap();
    protected LinkedList strings = new LinkedList();
    protected boolean procassembly = false;
    protected String exesect = "";

    public boolean isProcessAssembly() {
        return this.procassembly;
    }

    protected void parseDirectory(int n) throws IOException {
        long l = this.readLong();
        long l2 = this.readLong();
        this.put("DataDirectory." + n + ".VirtualAddress", l);
        this.put("DataDirectory." + n + ".Size", l2);
    }

    protected void parseFunctionNameHint(int n, int n2, int n3, List list) throws IOException {
        this.jump(n3 - n2 + n);
        int n4 = this.readShort();
        String string = this.readString();
        list.add(string + "@" + n4);
        this.complete();
    }

    protected List parseFunctionNameList(int n, int n2, int n3) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        this.jump(n - n2 + n3);
        while (true) {
            if (this.is64()) {
                long l = this.readQWord();
                if ((l & Long.MIN_VALUE) == Long.MIN_VALUE) {
                    linkedList.add("<ordinal>@" + (l &= Long.MAX_VALUE));
                    continue;
                }
                if (l <= 0L) break;
                this.parseFunctionNameHint(n3, n2, (int)l, linkedList);
                continue;
            }
            int n4 = this.readInt();
            if ((n4 & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                linkedList.add("<ordinal>@" + (n4 &= Integer.MAX_VALUE));
                continue;
            }
            if (n4 <= 0) break;
            this.parseFunctionNameHint(n3, n2, n4, linkedList);
        }
        this.complete();
        return linkedList;
    }

    protected boolean parseImport(int n) throws IOException {
        int n2 = this.dirEntry(1);
        int n3 = this.get("DataDirectory.1.VirtualAddress");
        long l = this.readInt();
        this.consume(8);
        long l2 = this.readInt();
        long l3 = this.readInt();
        if (l == 0L && l2 == 0L && l3 == 0L) {
            return false;
        }
        this.put("Import." + n + ".RVAFunctionNameList", l);
        this.put("Import." + n + ".RVAFunctionNameList.X", this.parseFunctionNameList((int)l, n3, n2));
        this.put("Import." + n + ".RVAModuleName", l2);
        this.put("Import." + n + ".RVAModuleName.X", this.getStringFromPointer((int)l2, n3, n2));
        this.put("Import." + n + ".RVAFunctionAddressList", l3);
        return true;
    }

    public int getPointerForLocation(int n, int n2) {
        int n3 = this.dirEntry(n);
        int n4 = this.get("DataDirectory." + n + ".VirtualAddress");
        return n2 - n3 + n4;
    }

    protected String getStringFromPointer(int n, int n2, int n3) throws IOException {
        this.jump(n - n2 + n3);
        String string = this.readString();
        this.complete();
        return string;
    }

    public List getExportedFunctions() {
        return (List)this.values.get("Export.FunctionNames");
    }

    public List getSectionsTable() {
        return (List)this.values.get("SectionsTable");
    }

    public byte[] carveExportedFunction(String string) {
        int n = this.getFunctionOffset(string);
        int n2 = this.getNextFunctionOffset(string);
        if (n == -1) {
            CommonUtils.print_error("Could not find '" + string + "' in DLL");
            return new byte[0];
        }
        return Arrays.copyOfRange(this.original, n, n2);
    }

    public int getFunctionOffset(String string) {
        List list = this.getExportedFunctions();
        List list2 = (List)this.values.get("Export.FunctionAddressesFixed");
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            String string2 = (String)iterator.next();
            Long l = (Long)iterator2.next();
            if (!string.equals(string2)) continue;
            return (int)l.longValue();
        }
        return -1;
    }

    public int getNextFunctionOffset(String string) {
        long l = this.getFunctionOffset(string);
        List list = this.getExportedFunctions();
        List list2 = (List)this.values.get("Export.FunctionAddressesFixed");
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Long l2 = (Long)iterator2.next();
            if (l2 <= l) continue;
            return (int)l2.longValue();
        }
        int n = this.get(".text.PointerToRawData");
        int n2 = this.get(".text.SizeOfRawData");
        return n + n2;
    }

    protected void printSymbol(int n) {
        int n2 = this.get("Symbol." + n + ".e_value");
        int n3 = this.get("Symbol." + n + ".e_scnum");
        int n4 = this.get("Symbol." + n + ".e_type");
        int n5 = this.get("Symbol." + n + ".e_sclass");
        int n6 = this.get("Symbol." + n + ".e_numaux");
        String string = this.getString("Symbol." + n + ".e_auxval");
        CommonUtils.print_stat("Symbol " + n + ": " + this.getString("Symbol." + n + ".e") + "\n\te_value:  " + n2 + "\n\te_scnum:  " + n3 + "\n\te_sclass: " + n5 + "\n\te_type:   " + n4 + "\n\te_numaux: " + n6 + "\n\te_auxval: " + string);
    }

    public String readStringTableOffset(int n) throws IOException {
        this.jump(this.get("PointerToSymbolTable") + this.get("NumberOfSymbols") * 18);
        this.consume(n);
        String string = this.readString();
        this.complete();
        return string;
    }

    protected String readSymbolName() throws IOException {
        this.jump(this.here());
        long l = this.readLong();
        this.complete();
        if (l == 0L) {
            this.consume(4);
            int n = this.readInt();
            return this.readStringTableOffset(n);
        }
        return this.readString(8);
    }

    protected void parseSymbol(int n) throws IOException {
        this.put("Symbol." + n + ".e", this.readSymbolName());
        this.put("Symbol." + n + ".e_value", this.readLong());
        this.put("Symbol." + n + ".e_scnum", this.readShort());
        this.put("Symbol." + n + ".e_type", this.readShort());
        this.put("Symbol." + n + ".e_sclass", this.readByte());
        this.put("Symbol." + n + ".e_numaux", this.readByte());
        if (this.get("Symbol." + n + ".e_sclass") == 103) {
            this.put("Symbol." + n + ".e_auxval", this.readString(18));
        } else if (this.get("Symbol." + n + ".e_numaux") > 0) {
            this.consume(18 * this.get("Symbol." + n + ".e_numaux"));
        }
    }

    protected void parseSymbols() throws IOException {
        int n = this.get("NumberOfSymbols");
        for (int i = 0; i < n; ++i) {
            this.parseSymbol(i);
            i += this.get("Symbol." + i + ".e_numaux");
        }
    }

    protected void parseExport() throws IOException {
        int n;
        int n2 = this.dirEntry(0);
        int n3 = this.get("DataDirectory.0.VirtualAddress");
        this.consume(12);
        this.report("Export.Name");
        this.put("Export.Name", this.getStringFromPointer(this.readInt(), n3, n2));
        this.put("Export.Base", this.readInt());
        this.put("Export.NumberOfFunctions", this.readInt());
        this.put("Export.NumberOfNames", this.readInt());
        this.put("Export.AddressOfFunctions", this.readInt());
        this.put("Export.AddressOfNames", this.readInt());
        this.put("Export.AddressOfNameOridinals", this.readInt());
        this.jump(this.get("Export.AddressOfNames") - n3 + n2);
        this.jump(this.readInt() - n3 + n2);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (n = 0; n < this.get("Export.NumberOfNames"); ++n) {
            this.report("Export.AddressOfName." + n);
            linkedList.add(this.readString());
        }
        this.put("Export.FunctionNames", linkedList);
        this.complete();
        this.complete();
        this.jump(this.get("Export.AddressOfFunctions") - n3 + n2);
        linkedList = new LinkedList();
        for (n = 0; n < this.get("Export.NumberOfNames"); ++n) {
            linkedList.add(this.readLong());
        }
        this.put("Export.FunctionAddresses", linkedList);
        this.complete();
        this.jump(this.get("Export.AddressOfFunctions") - n3 + n2);
        linkedList = new LinkedList();
        for (n = 0; n < this.get("Export.NumberOfNames"); ++n) {
            linkedList.add(new Long(this.fixAddress(this.readLong())));
        }
        this.put("Export.FunctionAddressesFixed", linkedList);
        this.complete();
    }

    public long fixAddress(long l) {
        Iterator iterator = this.SectionsTable().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next() + "";
            if (!this.inSection(string, l)) continue;
            return l - (long)this.sectionAddress(string) + (long)this.sectionStart(string);
        }
        return -1L;
    }

    public static OBJParser load(InputStream inputStream) throws Exception {
        return new OBJParser(inputStream);
    }

    public static OBJParser load(byte[] byArray) throws Exception {
        return new OBJParser(byArray);
    }

    protected OBJParser(InputStream inputStream) throws Exception {
        this(CommonUtils.readAll(inputStream));
    }

    protected void jump(long l) throws IOException {
        this.frames.push(this.content);
        this.content = new DataInputStream(new ByteArrayInputStream(this.original));
        if (l > 0L) {
            this.consume((int)l);
        }
    }

    protected void complete() throws IOException {
        this.content.close();
        this.content = (DataInputStream)this.frames.pop();
    }

    protected OBJParser(byte[] byArray) throws Exception {
        this.original = byArray;
        this.buffer = ByteBuffer.wrap(this.bdata);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.content = new DataInputStream(new ByteArrayInputStream(byArray));
        this.parse();
    }

    protected void consume(int n) throws IOException {
        this.content.skipBytes(n);
    }

    protected int readInt() throws IOException {
        CommonUtils.clearBuffer(this.buffer);
        this.content.read(this.bdata, 0, 4);
        return (int)this.buffer.getLong(0);
    }

    protected long readLong() throws IOException {
        CommonUtils.clearBuffer(this.buffer);
        this.content.read(this.bdata, 0, 4);
        return this.buffer.getLong(0);
    }

    protected long readQWord() throws IOException {
        CommonUtils.clearBuffer(this.buffer);
        this.content.read(this.bdata, 0, 8);
        return this.buffer.getLong(0);
    }

    protected byte readByte() throws IOException {
        return this.content.readByte();
    }

    protected char readChar() throws IOException {
        return (char)this.content.readByte();
    }

    protected char readChar(DataInputStream dataInputStream) throws IOException {
        return (char)dataInputStream.readByte();
    }

    protected int readShort() throws IOException {
        this.content.read(this.bdata, 0, 2);
        return this.buffer.getShort(0) & 0xFFFF;
    }

    protected String readString() throws IOException {
        char c;
        this.string();
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = this.readChar()) > '\u0000') {
            stringBuffer.append(c);
        }
        if (stringBuffer.toString().startsWith("_ReflectiveLoader") || stringBuffer.toString().startsWith("ReflectiveLoader")) {
            this.strings.removeLast();
        }
        if (stringBuffer.toString().contains("CorExeMain")) {
            this.procassembly = true;
        }
        return stringBuffer.toString();
    }

    protected String readString(int n) throws IOException {
        this.string();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = this.readChar();
            if (c <= '\u0000') continue;
            stringBuffer.append(c);
        }
        if (stringBuffer.toString().startsWith("_ReflectiveLoader") || stringBuffer.toString().startsWith("ReflectiveLoader")) {
            this.strings.removeLast();
        }
        if (stringBuffer.toString().contains("CorExeMain")) {
            this.procassembly = true;
        }
        return stringBuffer.toString();
    }

    protected void put(String string, long l) {
        this.values.put(string, new Long(l));
    }

    protected void put(String string, List list) {
        this.values.put(string, list);
    }

    protected void put(String string, String string2) {
        this.values.put(string, string2);
    }

    protected void put(String string, Date date) {
        this.values.put(string, date);
    }

    protected void error(String string) {
        throw new RuntimeException(string);
    }

    protected void header(String string, int n) throws Exception {
        this.report("header." + string);
        int n2 = this.readShort();
        if (n2 != n) {
            this.error("Header " + string + " Magic Failed: " + n2 + " expected (" + n + ")");
        }
    }

    public int get(String string) {
        Long l = (Long)this.values.get(string);
        if (l == null) {
            return 0;
        }
        return (int)l.longValue();
    }

    public Date getDate(String string) {
        return (Date)this.values.get(string);
    }

    public String getString(String string) {
        return (String)this.values.get(string);
    }

    public String getDLLName() {
        return this.getString("Export.Name");
    }

    protected void put(String string, String string2, long l) {
        this.values.put(string + "." + string2, new Long(l));
    }

    protected void put(String string, String string2, String string3) {
        this.values.put(string + "." + string2, new Long(string3));
    }

    protected void readCharacteristics(String string) throws IOException {
        long l = this.readLong();
        LinkedList<String> linkedList = new LinkedList<String>();
        if ((l & 0x20L) == 32L) {
            linkedList.add("Code");
        }
        if ((l & 0x40L) == 64L) {
            linkedList.add("Initialized Data");
        }
        if ((l & 0x80L) == 128L) {
            linkedList.add("Uninitialized Data");
        }
        if ((l & 0x4000000L) == 0x4000000L) {
            linkedList.add("Section cannot be cached");
        }
        if ((l & 0x8000000L) == 0x8000000L) {
            linkedList.add("Section is not pageable");
        }
        if ((l & 0x10000000L) == 0x10000000L) {
            linkedList.add("Section is shared");
        }
        if ((l & 0x20000000L) == 0x20000000L) {
            linkedList.add("Executable");
        }
        if ((l & 0x40000000L) == 0x40000000L) {
            linkedList.add("Readable");
        }
        if ((l & 0x80000000L) == 0x80000000L) {
            linkedList.add("Writable");
        }
        linkedList.add("0x" + Long.toString(l, 16));
        this.values.put(string + ".Characteristics", linkedList);
        if ((l & 0x20000000L) == 0x20000000L) {
            this.exesect = string;
        }
    }

    public String getExeSect() {
        return this.exesect;
    }

    protected void readRelocation(String string, int n) throws IOException {
        long l = this.readLong();
        long l2 = this.readLong();
        long l3 = this.readShort();
        this.put(string, "Relocation." + n + ".r_vaddr", l);
        this.put(string, "Relocation." + n + ".r_symndx", l2);
        this.put(string, "Relocation." + n + ".r_type", l3);
    }

    protected void parseRelocations(String string) throws IOException {
        int n = this.get(string + ".NumberOfRelocations");
        int n2 = this.get(string + ".PointerToRelocations");
        this.jump(n2);
        for (int i = 0; i < n; ++i) {
            this.readRelocation(string, i);
        }
        this.complete();
    }

    protected Date readDate() throws IOException {
        return new Date(this.readLong() * 1000L);
    }

    public boolean hasSection(String string) {
        if (this.values.containsKey("SectionsTable")) {
            HashSet hashSet = new HashSet(this.SectionsTable());
            return hashSet.contains(string);
        }
        return false;
    }

    protected void parseSection(int n) throws Exception {
        this.report("Sections.AddressOfName." + n);
        String string = this.readString(8);
        if (this.hasSection(string)) {
            string = string + "$" + n;
        }
        this.append("SectionsTable", string);
        this.put(string, "VirtualSize", this.readInt());
        this.put(string, "VirtualAddress", this.readInt());
        this.put(string, "SizeOfRawData", this.readInt());
        this.put(string, "PointerToRawData", this.readInt());
        this.put(string, "PointerToRelocations", this.readInt());
        this.put(string, "PointerToLinenumbers", this.readInt());
        this.report(string + ".NumberOfRelocations");
        this.put(string, "NumberOfRelocations", this.readShort());
        this.put(string, "NumberOfLinenumbers", this.readShort());
        this.readCharacteristics(string);
        this.parseRelocations(string);
    }

    protected void append(String string, String string2) {
        if (this.values.get(string) == null) {
            this.values.put(string, new LinkedList());
        }
        LinkedList linkedList = (LinkedList)this.values.get(string);
        linkedList.add(string2);
    }

    public int sectionStart(String string) {
        return this.get(string + ".PointerToRawData");
    }

    public int sectionSize(String string) {
        return this.get(string + ".SizeOfRawData");
    }

    public int sectionAddress(String string) {
        return this.get(string + ".VirtualAddress");
    }

    public int sectionEnd(String string) {
        return this.get(string + ".VirtualAddress") + this.get(string + ".VirtualSize");
    }

    protected boolean inSection(String string, long l) {
        long l2 = this.sectionAddress(string);
        long l3 = this.get(string + ".VirtualSize");
        return l >= l2 && l < l2 + l3;
    }

    public List SectionsTable() {
        return (List)this.values.get("SectionsTable");
    }

    protected int dirEntry(int n) {
        int n2 = this.get("DataDirectory." + n + ".VirtualAddress");
        for (String string : this.SectionsTable()) {
            int n3 = this.sectionAddress(string);
            int n4 = this.sectionSize(string);
            if (n2 < n3 || n2 >= n3 + n4) continue;
            return this.sectionStart(string) + (n2 - n3);
        }
        throw new RuntimeException("Directory entry: " + n + "@" + n2 + " not found");
    }

    public boolean is64() {
        return this.get("Machine") == 34404;
    }

    public boolean is86() {
        return this.get("Machine") == 332;
    }

    public int relocationsCount(String string) {
        return this.get(string + ".NumberOfRelocations");
    }

    public Relocation getRelocation(String string, int n) {
        return new Relocation(this, string, n);
    }

    public int here() throws IOException {
        return this.original.length - this.content.available();
    }

    public void string() {
        try {
            int n = this.here();
            this.strings.add(new Integer(n));
        }
        catch (Exception exception) {
            MudgeSanity.logException("string", exception, false);
        }
    }

    public void report(String string) {
        try {
            int n = this.here();
            this.locations.put(string, new Integer(n));
        }
        catch (Exception exception) {
            MudgeSanity.logException("report: " + string, exception, false);
        }
    }

    public Iterator stringIterator() {
        return this.strings.iterator();
    }

    public int getLocation(String string) {
        if (!this.locations.containsKey(string)) {
            throw new IllegalArgumentException("No location for '" + string + "'");
        }
        int n = (Integer)this.locations.get(string);
        AssertUtils.Test(n >= 60, string + " (offset: " + n + ") Reflective Loader bootstrap region");
        return n;
    }

    protected void parse() throws Exception {
        int n;
        this.put("Machine", this.readShort());
        if (!this.is86() && !this.is64()) {
            this.error("Invalid Machine header value '" + this.get("Machine"));
        }
        this.put("Sections", this.readShort());
        this.report("TimeDateStamp");
        this.put("TimeDateStamp", this.readDate());
        this.put("PointerToSymbolTable", this.readInt());
        this.report("NumberOfSymbols");
        this.put("NumberOfSymbols", this.readInt());
        this.put("SizeOfOptionalHeader", this.readShort());
        this.report("Characteristics");
        this.put("Characteristics", this.readShort());
        for (n = 0; n < this.get("NumberOfRvaAndSizes"); ++n) {
            this.parseDirectory(n);
        }
        for (n = 0; n < this.get("Sections"); ++n) {
            this.parseSection(n);
        }
        this.report("HeaderSlack");
        if (this.get("DataDirectory.1.VirtualAddress") != 0) {
            this.jump(this.dirEntry(1));
            n = 0;
            while (this.parseImport(n)) {
                ++n;
            }
            this.complete();
        }
        if (this.get("DataDirectory.0.VirtualAddress") != 0) {
            this.jump(this.dirEntry(0));
            this.parseExport();
            this.complete();
        }
        this.jump(this.get("PointerToSymbolTable"));
        this.parseSymbols();
        this.complete();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Key                                Value\n");
        stringBuffer.append("---                                -----\n");
        for (Map.Entry entry : new TreeMap(this.values).entrySet()) {
            String string = (String)entry.getKey();
            while (string.length() < 35) {
                string = string + " ";
            }
            stringBuffer.append(string);
            if (entry.getValue() instanceof Long) {
                Long l = (Long)entry.getValue();
                long l2 = l;
                String string2 = "0x" + Long.toString(l2, 16);
                while (string2.length() < 12) {
                    string2 = string2 + " ";
                }
                string2 = string2 + l2;
                stringBuffer.append(string2);
                stringBuffer.append("\n");
                continue;
            }
            if (entry.getValue() instanceof String) {
                stringBuffer.append(entry.getValue() + "\n");
                continue;
            }
            if (entry.getValue() instanceof List) {
                stringBuffer.append(entry.getValue() + "\n");
                continue;
            }
            if (!(entry.getValue() instanceof Date)) continue;
            long l = ((Date)entry.getValue()).getTime() / 1000L;
            String string3 = "0x" + Long.toString(l, 16);
            while (string3.length() < 12) {
                string3 = string3 + " ";
            }
            string3 = string3 + l;
            while (string3.length() < 32) {
                string3 = string3 + " ";
            }
            string3 = string3 + CommonUtils.formatDateAny("dd MMM yyyy HH:mm:ss", l * 1000L);
            stringBuffer.append(string3);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getStringAt(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.original[n] != 0) {
            stringBuffer.append((char)this.original[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void stringWalk() {
        Iterator iterator = this.stringIterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            CommonUtils.print_stat("[" + n + "] " + this.getStringAt(n));
        }
    }

    public static void dump(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        OBJParser oBJParser = OBJParser.load(new FileInputStream(file));
        System.out.println(oBJParser.toString());
        System.out.println("\n\nLocations:\n----------");
        for (Map.Entry entry : oBJParser.locations.entrySet()) {
            String string = (String)entry.getKey();
            while (string.length() < 31) {
                string = string + " ";
            }
            System.out.println(string + " " + entry.getValue());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        OBJParser.dump(stringArray);
    }
}

