/*
 * Decompiled with CFR 0.152.
 */
package report;

import aggressor.Prefs;
import common.CommonUtils;
import common.MudgeSanity;
import encoders.Base64;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import report.ReportElement;

public class ReportUtils {
    public static String accent() {
        String string = Prefs.getPreferences().getString("reporting.accent.color", "#003562");
        return "".equals(string) ? "#003562" : string;
    }

    public static String a(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<fo:basic-link color=\"" + ReportUtils.accent() + "\" text-decoration=\"underline\" external-destination=\"" + string2 + "\">");
        stringBuffer.append("<fo:inline>");
        stringBuffer.append(string);
        stringBuffer.append("</fo:inline>");
        stringBuffer.append("</fo:basic-link>");
        return stringBuffer.toString();
    }

    public static String b(String string) {
        return "<fo:inline font-weight=\"bold\">" + string + "</fo:inline>";
    }

    public static String br() {
        return "<fo:block> </fo:block>";
    }

    public static String u(String string) {
        return "<fo:inline text-decoration=\"underline\">" + string + "</fo:inline>";
    }

    public static String i(String string) {
        return "<fo:inline font-style=\"italic\">" + string + "</fo:inline>";
    }

    public static String code(String string) {
        return "<fo:inline font-weight=\"monospace\">" + string + "</fo:inline>";
    }

    public static String logo() {
        String string = Prefs.getPreferences().getString("reporting.header_image.file", "");
        if ("".equals(string)) {
            byte[] byArray = CommonUtils.readResource("resources/fso/logo2.png");
            return "url(&#34;data:image/png;base64," + Base64.encode(byArray) + "&#xA;&#34;)";
        }
        return string;
    }

    public static String image(RenderedImage renderedImage) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(524288);
            ImageIO.write(renderedImage, "png", byteArrayOutputStream);
            return "url(&#34;data:image/png;base64," + Base64.encode(byteArrayOutputStream.toByteArray()) + "&#xA;&#34;)";
        }
        catch (Exception exception) {
            MudgeSanity.logException("could not transform image", exception, false);
            return "";
        }
    }

    public static String image(String string) {
        byte[] byArray = CommonUtils.readResource(string);
        return "url(&#34;data:image/png;base64," + Base64.encode(byArray) + "&#xA;&#34;)";
    }

    public static String ColumnWidth(String string) {
        return "\t<fo:table-column column-width=\"" + string + "\" />";
    }

    public static void PublishAll(StringBuffer stringBuffer, List list) {
        for (ReportElement reportElement : list) {
            reportElement.publish(stringBuffer);
        }
    }
}

