/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.types;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sleep.runtime.CollectionWrapper;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScalarType;
import sleep.runtime.SleepUtils;

public class HashContainer
implements ScalarHash {
    protected Map values;

    public HashContainer(Map map2) {
        this.values = map2;
    }

    public HashContainer() {
        this(new HashMap());
    }

    public Scalar getAt(Scalar scalar) {
        String string = scalar.getValue().toString();
        Scalar scalar2 = (Scalar)this.values.get(string);
        if (scalar2 == null) {
            scalar2 = SleepUtils.getEmptyScalar();
            this.values.put(string, scalar2);
        }
        return scalar2;
    }

    public Map getData() {
        return this.values;
    }

    public ScalarArray keys() {
        ScalarType scalarType = SleepUtils.getEmptyScalar().getValue();
        Iterator iterator = this.values.values().iterator();
        while (iterator.hasNext()) {
            Scalar scalar = (Scalar)iterator.next();
            if (scalar.getArray() != null || scalar.getHash() != null || scalar.getActualValue() != scalarType) continue;
            iterator.remove();
        }
        return new CollectionWrapper(this.values.keySet());
    }

    public void remove(Scalar scalar) {
        SleepUtils.removeScalar(this.values.values().iterator(), scalar);
    }

    public String toString() {
        return this.values.toString();
    }
}

