/*
 * Decompiled with CFR 0.152.
 */
package ui;

import aggressor.Prefs;
import common.CommonUtils;
import console.Activity;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import ui.ATable;
import ui.DataSelectionListener;
import ui.GenericTableModel;

public class DataBrowser
extends JComponent
implements ListSelectionListener,
Activity {
    protected JSplitPane split = new JSplitPane(1);
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected LinkedList listeners = new LinkedList();
    protected String col;
    protected JLabel label;
    protected Color original;

    @Override
    public void registerLabel(JLabel jLabel) {
        this.original = jLabel.getForeground();
        this.label = jLabel;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.table.requestFocusInWindow();
    }

    @Override
    public void resetNotification() {
        this.label.setForeground(this.original);
        this.table.markSelections();
        this.table.fixSelection();
    }

    public static DataBrowser getBeaconDataBrowser(String string, JComponent jComponent, LinkedList linkedList) {
        return new DataBrowser(string, CommonUtils.toArray("user, computer, pid, when"), null, jComponent, linkedList);
    }

    public static DataBrowser getScreenshotDataBrowser(String string, JComponent jComponent, LinkedList linkedList) {
        Map map2 = DialogUtils.toMap("user: 75, computer: 75, session: 75, when: 125, title: 50");
        return new DataBrowser(string, CommonUtils.toArray("user, computer, session, when, title"), map2, jComponent, linkedList);
    }

    public static DataBrowser getKeystrokeDataBrowser(String string, JComponent jComponent, LinkedList linkedList) {
        Map map2 = DialogUtils.toMap("user: 75, computer: 75, session: 75, when: 125, title: 50");
        return new DataBrowser(string, CommonUtils.toArray("user, computer, session, when, title"), map2, jComponent, linkedList);
    }

    public DataBrowser(String string, String[] stringArray, Map map2, JComponent jComponent, LinkedList linkedList) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        this.model = DialogUtils.setupModel(string, stringArray, linkedList);
        this.table = DialogUtils.setupTable((TableModel)this.model, stringArray, false);
        if (map2 != null) {
            DialogUtils.setTableColumnWidths(this.table, map2);
        }
        this.table.getSelectionModel().addListSelectionListener(this);
        this.split.add(DialogUtils.FilterAndScroll(this.table));
        this.split.add(jComponent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        for (DataSelectionListener dataSelectionListener : this.listeners) {
            dataSelectionListener.selected(this.getSelectedValue());
        }
    }

    public void addDataSelectionListener(DataSelectionListener dataSelectionListener) {
        this.listeners.add(dataSelectionListener);
    }

    public Object getSelectedValue() {
        return this.model.getSelectedValue(this.table);
    }

    public Map getSelectedRow() {
        Map[] mapArray = this.getModel().getSelectedRows(this.getTable());
        if (mapArray.length == 0) {
            return null;
        }
        return mapArray[0];
    }

    public GenericTableModel getModel() {
        return this.model;
    }

    public ATable getTable() {
        return this.table;
    }

    public void addEntry(final Map map2) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                DataBrowser.this.table.markSelections();
                DataBrowser.this.model.addEntry(map2);
                DataBrowser.this.model.fireListeners();
                DataBrowser.this.table.restoreSelections();
                if (!DataBrowser.this.isShowing()) {
                    DataBrowser.this.label.setForeground(Prefs.getPreferences().getColor("tab.highlight.color", "#0000ff"));
                }
            }
        });
    }

    public void removeEntry(final String string, final String string2) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                DataBrowser.this.table.clearSelection();
                DataBrowser.this.model.removeRowWithValueAtColumn(string, string2);
                DataBrowser.this.model.fireListeners();
                if (!DataBrowser.this.isShowing()) {
                    DataBrowser.this.label.setForeground(Prefs.getPreferences().getColor("tab.highlight.color", "#0000ff"));
                }
            }
        });
    }

    public void setTable(final Collection collection) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                DialogUtils.setTable(DataBrowser.this.table, DataBrowser.this.model, collection);
                if (!DataBrowser.this.isShowing()) {
                    DataBrowser.this.label.setForeground(Prefs.getPreferences().getColor("tab.highlight.color", "#0000ff"));
                }
            }
        });
    }
}

