/*
 * Decompiled with CFR 0.152.
 */
package ui;

import common.CommonUtils;
import filter.DataFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class GenericTableModel
extends AbstractTableModel {
    protected String[] columnNames;
    protected List rows;
    protected String leadColumn;
    protected boolean[] editable;
    protected List all;
    protected DataFilter filter = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(DataFilter dataFilter) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            List list = dataFilter.apply(this.rows);
            this.rows = new ArrayList(list.size());
            this.rows.addAll(list);
            this.filter = dataFilter;
        }
        this.fireListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            this.rows = new ArrayList(this.all.size());
            this.rows.addAll(this.all);
            this.filter = null;
        }
        this.fireListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRowWithValueAtColumn(String string, String string2) {
        int n = 0;
        CommonUtils.Guard();
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            Object object;
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                object = (Map)iterator.next();
                if (!string2.equals(object.get(string))) continue;
                iterator.remove();
                ++n;
            }
            object = this.rows.iterator();
            while (object.hasNext()) {
                Map map2 = (Map)object.next();
                if (!string2.equals(map2.get(string))) continue;
                object.remove();
                ++n;
            }
        }
        return n > 0;
    }

    public List getRows() {
        return this.rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List export() {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            LinkedList linkedList = new LinkedList();
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                linkedList.add(new HashMap((Map)iterator.next()));
            }
            return linkedList;
        }
    }

    public GenericTableModel(String[] stringArray, String string, int n) {
        this.columnNames = stringArray;
        this.leadColumn = string;
        this.rows = new ArrayList(n);
        this.all = new ArrayList(n);
        this.editable = new boolean[stringArray.length];
        for (int i = 0; i < this.editable.length; ++i) {
            this.editable[i] = false;
        }
    }

    public void setCellEditable(int n) {
        this.editable[n] = true;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.editable[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getSelectedValues(JTable jTable) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            int[] nArray = jTable.getSelectedRows();
            Object[] objectArray = new Object[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = jTable.convertRowIndexToModel(nArray[i]);
                objectArray[i] = n < this.rows.size() && n >= 0 ? ((Map)this.rows.get(n)).get(this.leadColumn) : null;
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSelectedRows(JTable jTable) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            return jTable.getSelectedRowCount() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map[] getSelectedRows(JTable jTable) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            int[] nArray = jTable.getSelectedRows();
            Map[] mapArray = new HashMap[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = jTable.convertRowIndexToModel(nArray[i]);
                mapArray[i] = (Map)this.rows.get(n);
            }
            return mapArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] getSelectedValuesFromColumns(JTable jTable, String[] stringArray) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            int[] nArray = jTable.getSelectedRows();
            Object[][] objectArray = new Object[nArray.length][stringArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = jTable.convertRowIndexToModel(nArray[i]);
                for (int j = 0; j < stringArray.length; ++j) {
                    objectArray[i][j] = ((Map)this.rows.get(n)).get(stringArray[j]);
                }
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSelectedValue(JTable jTable) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            Object[] objectArray = this.getSelectedValues(jTable);
            if (objectArray.length == 0) {
                return null;
            }
            return objectArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(JTable jTable, int n, String string) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            n = jTable.convertRowIndexToModel(n);
            if (n == -1) {
                return null;
            }
            return ((Map)this.rows.get(n)).get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedRow(JTable jTable) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            return jTable.convertRowIndexToModel(jTable.getSelectedRow());
        }
    }

    public void _setValueAtRow(int n, String string, String string2) {
        ((Map)this.rows.get(n)).put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setValueForKeyAtColumn(String string, String string2, String string3, String string4) {
        int n = -1;
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            Iterator iterator = this.rows.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Map map2 = (Map)iterator.next();
                if (string2.equals(map2.get(string))) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        if (n != -1) {
            this.setValueAtRow(n, string3, string4);
        }
        return n != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueForKey(String string, String string2, String string3) {
        int n = -1;
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            Iterator iterator = this.rows.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Map map2 = (Map)iterator.next();
                if (string.equals(map2.get(this.leadColumn))) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        if (n != -1) {
            this.setValueAtRow(n, string2, string3);
        }
    }

    public void setValueAtRow(final int n, final String string, final String string2) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                GenericTableModel.this._setValueAtRow(n, string, string2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSelectedValueFromColumn(JTable jTable, String string) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            int n = jTable.getSelectedRow();
            if (n == -1) {
                return null;
            }
            return this.getValueAt(jTable, n, string);
        }
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void addEntry(final Map map2) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                GenericTableModel.this._addEntry(map2);
            }
        });
    }

    public void clear(final int n) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                GenericTableModel.this._clear(n);
            }
        });
    }

    public void fireListeners() {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                GenericTableModel.this.fireTableDataChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _addEntry(Map map2) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            if (this.filter == null || this.filter.test(map2)) {
                this.rows.add(map2);
            }
            this.all.add(map2);
            int n = this.rows.size() - 1;
        }
    }

    public void activateRow(JTable jTable, int n) {
        n = jTable.convertRowIndexToView(n);
        jTable.setRowSelectionInterval(n, n);
        jTable.scrollRectToVisible(jTable.getCellRect(n, 0, false));
    }

    public boolean isSelected(JTable jTable, int n) {
        try {
            n = jTable.convertRowIndexToView(n);
            return jTable.isCellSelected(n, 0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _clear(int n) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            this.rows = new ArrayList(n);
            this.all = new ArrayList(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            return this.rows.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAtColumn(JTable jTable, int n, String string) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            n = jTable.convertRowIndexToModel(n);
            Map map2 = (Map)this.rows.get(n);
            return map2.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            if (n < this.rows.size()) {
                Map map2 = (Map)this.rows.get(n);
                return map2.get(this.getColumnName(n2));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n, int n2) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            Map map2 = (Map)this.rows.get(n);
            map2.put(this.getColumnName(n2), object);
        }
    }
}

