/*
 * Decompiled with CFR 0.152.
 */
package ui;

import common.CommonUtils;
import common.MudgeSanity;
import graph.Route;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class Sorters {
    private static Set B = new HashSet();
    private static Set A = new HashSet();

    public static Comparator getStringSorter() {
        return new _C();
    }

    public static Comparator getHostSorter() {
        return new _A();
    }

    public static Comparator getNumberSorter() {
        return new _B();
    }

    public static Comparator getDateSorter(String string) {
        return new _D(string);
    }

    public static Comparator getProperSorter(String string) {
        if (B.contains(string)) {
            return Sorters.getHostSorter();
        }
        if (A.contains(string)) {
            return Sorters.getNumberSorter();
        }
        return null;
    }

    static {
        B.add("external");
        B.add("host");
        B.add("Host");
        B.add("internal");
        B.add("session_host");
        B.add("address");
        A.add("when");
        A.add("last");
        A.add("pid");
        A.add("port");
        A.add("Port");
        A.add("sid");
        A.add("when");
        A.add("date");
        A.add("size");
        A.add("PID");
        A.add("PPID");
        A.add("Session");
    }

    private static class _C
    implements Comparator {
        private _C() {
        }

        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return this.compare("", "");
            }
            if (object == null) {
                return this.compare("", object2);
            }
            if (object2 == null) {
                return this.compare(object, "");
            }
            return object.toString().compareTo(object2.toString());
        }
    }

    private static class _B
    implements Comparator {
        private _B() {
        }

        public int compare(Object object, Object object2) {
            long l;
            String string = object.toString();
            String string2 = object2.toString();
            long l2 = CommonUtils.toLongNumber(string, 0L);
            if (l2 == (l = CommonUtils.toLongNumber(string2, 0L))) {
                return 0;
            }
            if (l2 > l) {
                return 1;
            }
            return -1;
        }
    }

    private static class _A
    implements Comparator {
        private _A() {
        }

        public int compare(Object object, Object object2) {
            long l;
            String string = object.toString();
            String string2 = object2.toString();
            if (string.equals("unknown")) {
                return this.compare("0.0.0.0", object2);
            }
            if (string2.equals("unknown")) {
                return this.compare(object, "0.0.0.0");
            }
            long l2 = Route.ipToLong(string);
            if (l2 == (l = Route.ipToLong(string2))) {
                return 0;
            }
            if (l2 > l) {
                return 1;
            }
            return -1;
        }
    }

    private static class _D
    implements Comparator {
        protected SimpleDateFormat A = null;

        public _D(String string) {
            try {
                this.A = new SimpleDateFormat(string);
            }
            catch (Exception exception) {
                MudgeSanity.logException("Parser: " + string, exception, false);
            }
        }

        public int compare(Object object, Object object2) {
            long l;
            long l2;
            String string = object.toString();
            String string2 = object2.toString();
            try {
                l2 = this.A.parse(string).getTime();
            }
            catch (Exception exception) {
                l2 = 0L;
            }
            try {
                l = this.A.parse(string2).getTime();
            }
            catch (Exception exception) {
                l = 0L;
            }
            if (l2 == l) {
                return 0;
            }
            if (l2 > l) {
                return 1;
            }
            return -1;
        }
    }
}

