/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ZoomableImage
extends JLabel {
    protected Icon original = null;
    protected double zoom = 1.0;

    private JMenuItem A(String string, final double d) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ZoomableImage.this.zoom = d;
                ZoomableImage.this.updateIcon();
            }
        });
        return jMenuItem;
    }

    public ZoomableImage() {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.A("25%", 0.25));
        jPopupMenu.add(this.A("50%", 0.5));
        jPopupMenu.add(this.A("75%", 0.75));
        jPopupMenu.add(this.A("100%", 1.0));
        jPopupMenu.add(this.A("125%", 1.25));
        jPopupMenu.add(this.A("150%", 1.5));
        jPopupMenu.add(this.A("200%", 2.0));
        jPopupMenu.add(this.A("250%", 2.5));
        this.addMouseListener(new MouseAdapter(){

            public void A(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                    mouseEvent.consume();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }
        });
        this.setHorizontalAlignment(0);
    }

    protected void updateIcon() {
        super.setIcon(this.resizeImage((ImageIcon)this.original));
    }

    @Override
    public void setIcon(Icon icon) {
        this.original = icon;
        this.updateIcon();
    }

    protected Icon resizeImage(ImageIcon imageIcon) {
        if (this.zoom == 1.0 || imageIcon == null) {
            return imageIcon;
        }
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, n, n2, null);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage.getScaledInstance((int)((double)n * this.zoom), (int)((double)n2 * this.zoom), 4));
    }
}

