/*
 * Decompiled with CFR 0.152.
 */
package aggressor;

import aggressor.DataManager;
import aggressor.DataUtils;
import aggressor.GlobalDataManager;
import aggressor.MultiFrame;
import aggressor.Prefs;
import aggressor.SyncMonitor;
import aggressor.TabManager;
import aggressor.bridges.AggressorBridge;
import aggressor.bridges.AliasManager;
import aggressor.bridges.ArtifactBridge;
import aggressor.bridges.AttackBridge;
import aggressor.bridges.BeaconBridge;
import aggressor.bridges.BeaconTaskBridge;
import aggressor.bridges.CovertVPNBridge;
import aggressor.bridges.CustomEventBridge;
import aggressor.bridges.DataBridge;
import aggressor.bridges.DialogBridge;
import aggressor.bridges.ElevateBridge;
import aggressor.bridges.ElevatorBridge;
import aggressor.bridges.EventLogBridge;
import aggressor.bridges.GraphBridge;
import aggressor.bridges.LateralBridge;
import aggressor.bridges.ListenerBridge;
import aggressor.bridges.PreferencesBridge;
import aggressor.bridges.RemoteExecBridge;
import aggressor.bridges.ReportingBridge;
import aggressor.bridges.SafeDialogBridge;
import aggressor.bridges.SecureShellAliasManager;
import aggressor.bridges.SiteBridge;
import aggressor.bridges.TabBridge;
import aggressor.bridges.TeamServerBridge;
import aggressor.bridges.ToolBarBridge;
import aggressor.bridges.UtilityBridge;
import aggressor.browsers.Connect;
import aggressor.browsers.TestConnection;
import beacon.BeaconCommands;
import beacon.BeaconElevators;
import beacon.BeaconExploits;
import beacon.BeaconRemoteExecMethods;
import beacon.BeaconRemoteExploits;
import beacon.SecureShellCommands;
import common.Callback;
import common.CommonUtils;
import common.DisconnectListener;
import common.License;
import common.LicenseStatus;
import common.MudgeSanity;
import common.PlaybackStatus;
import common.TeamQueue;
import common.TeamSocket;
import common.WindowsErrorCodes;
import console.Activity;
import cortana.Cortana;
import cortana.gui.ScriptableApplication;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import report.ReportEngine;
import tunnel.TunnelManager;
import ui.KeyBindings;
import ui.KeyHandler;

public class AggressorClient
extends JComponent
implements ScriptableApplication,
DisconnectListener,
Callback {
    protected KeyBindings keys = new KeyBindings();
    protected JMenuBar menu = new JMenuBar();
    protected TabManager tabs = null;
    protected Cortana engine = null;
    protected JSplitPane split = null;
    protected String title = "Cobalt Strike";
    protected MultiFrame window = null;
    protected JSplitPane split2 = null;
    protected JToolBar tool = new JToolBar();
    protected TeamQueue conn = null;
    protected DataManager data = null;
    protected ReportEngine reports = null;
    protected AliasManager aliases = null;
    protected TunnelManager tunnels = null;
    protected boolean connected = true;
    protected boolean userInitiatedClose = false;
    protected TestConnection testConnection = null;
    protected JPanel footer = new JPanel();
    protected JPanel licensePanel = new JPanel();
    protected JLabel licenseLabel = new JLabel();
    protected JButton closeLicenseButton = new JButton("X");
    protected SecureShellAliasManager ssh_aliases = null;
    protected JPanel viz = new JPanel();
    protected CardLayout viz_c = new CardLayout();
    protected boolean checkInitialLicense = true;

    public String getTitle() {
        if (License.isTrial()) {
            return this.title + " (Trial)";
        }
        return this.title;
    }

    public String getTeamServerAlias() {
        return this.data.getMapSafe("options").get("alias") + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTeamServerAlias(String string) {
        Object object = this.data;
        synchronized (object) {
            Map map2 = (Map)this.data.get("options", Collections.emptyMap());
            map2.put("alias", string);
        }
        object = DataUtils.getTeamServerIP(this.data);
        Prefs.getPreferences().set("connection.profiles." + (String)object + ".alias", string);
        Prefs.getPreferences().save();
    }

    public MultiFrame getWindow() {
        return this.window;
    }

    public TunnelManager getTunnelManager() {
        return this.tunnels;
    }

    public ReportEngine getReportEngine() {
        return this.reports;
    }

    public void showViz(String string) {
        this.viz_c.show(this.viz, string);
        this.viz.validate();
    }

    public void addViz(String string, JComponent jComponent) {
        this.viz.add((Component)jComponent, string);
    }

    public Cortana getScriptEngine() {
        return this.engine;
    }

    public TabManager getTabManager() {
        return this.tabs;
    }

    public TeamQueue getConnection() {
        return this.conn;
    }

    public DataManager getData() {
        return this.data;
    }

    public KeyBindings getBindings() {
        return this.keys;
    }

    public SecureShellAliasManager getSSHAliases() {
        return this.ssh_aliases;
    }

    public AliasManager getAliases() {
        return this.aliases;
    }

    @Override
    public void bindKey(String string, KeyHandler keyHandler) {
        this.keys.bind(string, keyHandler);
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this.menu;
    }

    public void touch() {
        Component component = this.tabs.getTabbedPane().getSelectedComponent();
        if (component == null) {
            return;
        }
        if (component instanceof Activity) {
            ((Activity)((Object)component)).resetNotification();
        }
        component.requestFocusInWindow();
    }

    public void kill() {
        this.userInitiatedClose = true;
        CommonUtils.print_info("shutting down client");
        this.tabs.stop();
        this.engine.getEventManager().stop();
        this.engine.stop();
        this.conn.close();
    }

    protected void stopTestConnection() {
        if (this.testConnection != null) {
            this.testConnection.stop();
            this.testConnection = null;
        }
    }

    @Override
    public void disconnected(TeamSocket teamSocket) {
        this.disconnected();
    }

    public void disconnected() {
        final AggressorClient aggressorClient = this;
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggressorClient.this.stopTestConnection();
                AggressorClient.this.window.quit(aggressorClient, false);
            }
        });
        JButton jButton2 = new JButton("Reconnect");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggressorClient.this.stopTestConnection();
                Map map2 = AggressorClient.this.data.getMapSafe("options");
                String string = AggressorClient.this.window.getActiveAlias();
                AggressorClient.this.window.quit(aggressorClient, true);
                new Connect(AggressorClient.this.window, true, string).dialogAction(null, map2);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(Color.RED);
        JLabel jLabel = new JLabel("Disconnected from server (" + this.getTeamServerAlias() + ")");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel.add((Component)jLabel, "Center");
        JLabel jLabel2 = new JLabel("");
        JComponent jComponent = this.userInitiatedClose ? DialogUtils.center(jLabel2, jButton2, jButton) : DialogUtils.center(jLabel2, jButton);
        jComponent.setBackground(Color.RED);
        jPanel.add((Component)jComponent, "East");
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.footer.add((Component)jPanel, "South");
        this.revalidate();
        this.getData().dead();
        this.connected = false;
        if (!this.userInitiatedClose) {
            this.testConnection = new TestConnection(this.data.getMapSafe("options"), jLabel2, jButton2);
            new Thread(this.testConnection).start();
        }
    }

    public void dock(JComponent jComponent, Dimension dimension) {
        this.split2.setBottomComponent(jComponent);
        this.split2.setDividerSize(10);
        this.split2.setResizeWeight(1.0);
        jComponent.setPreferredSize(dimension);
        jComponent.setSize(dimension);
        this.validate();
    }

    public void noDock() {
        this.split2.setBottomComponent(null);
        this.split2.setDividerSize(0);
        this.split2.setResizeWeight(1.0);
        this.validate();
    }

    @Override
    public void result(String string, Object object) {
        if ("server_error".equals(string)) {
            CommonUtils.print_error("Server error: " + object);
        } else if ("console_license_expiration".equals(string) && object instanceof LicenseStatus) {
            LicenseStatus licenseStatus = (LicenseStatus)object;
            boolean bl = false;
            String string2 = null;
            if (!licenseStatus.isValid()) {
                string2 = LicenseStatus.getInvalidLicenseMsg(licenseStatus);
                bl = true;
            } else if (!licenseStatus.isPerpetual()) {
                if (licenseStatus.isExpired() && LicenseStatus.isGracePeriod(licenseStatus)) {
                    string2 = LicenseStatus.getGracePeriodMsg(licenseStatus);
                    bl = true;
                } else if (licenseStatus.isExpired()) {
                    string2 = LicenseStatus.getExpiredMsg(licenseStatus);
                    bl = true;
                } else if (licenseStatus.isAlmostExpired()) {
                    string2 = LicenseStatus.getAlmostExpiredMsg(licenseStatus);
                }
            }
            if (!CommonUtils.isNullOrEmpty(string2)) {
                this.licenseLabel.setText(string2);
                this.A(bl);
                this.licensePanel.setVisible(true);
                if (this.checkInitialLicense && licenseStatus.isInitialClientConnect()) {
                    this.checkInitialLicense = false;
                    JOptionPane.showMessageDialog(null, string2 + "\nEmail cobalt.custops@helpsystems.com to renew\n\nIf you did renew, then obtain a new authorization file.", null, 1);
                    if (bl) {
                        this.kill();
                    }
                }
            } else {
                this.licensePanel.setVisible(false);
                this.A(bl);
            }
        }
    }

    private void A(boolean bl) {
        if (bl) {
            this.licensePanel.setBackground(Color.RED);
            this.licenseLabel.setForeground(Color.WHITE);
            this.closeLicenseButton.setEnabled(false);
        } else {
            this.licensePanel.setBackground(Color.YELLOW);
            this.licenseLabel.setForeground(Color.BLACK);
            this.closeLicenseButton.setEnabled(true);
        }
    }

    public void loadScripts() {
        try {
            this.engine.loadScript("scripts/default.cna", CommonUtils.resource("scripts/default.cna"));
        }
        catch (Exception exception) {
            MudgeSanity.logException("Loading scripts/default.cna", exception, false);
        }
        for (String string : Prefs.getPreferences().getList("cortana.scripts")) {
            try {
                this.engine.loadScript(string);
            }
            catch (Exception exception) {
                MudgeSanity.logException("Loading " + string, exception, true);
            }
        }
    }

    public AggressorClient(MultiFrame multiFrame, TeamQueue teamQueue, Map map2, Map map3) {
        this.setup(multiFrame, teamQueue, map2, map3);
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    public AggressorClient() {
    }

    public void setup(MultiFrame multiFrame, TeamQueue teamQueue, Map map2, Map map3) {
        this.window = multiFrame;
        this.conn = teamQueue;
        teamQueue.addDisconnectListener(this);
        this.tabs = new TabManager(this);
        this.engine = new Cortana(this);
        this.reports = new ReportEngine(this);
        this.aliases = new AliasManager();
        this.ssh_aliases = new SecureShellAliasManager();
        WindowsErrorCodes.Init();
        this.engine.register(new TabBridge(this.engine, this.tabs));
        this.engine.register(new GraphBridge(this, this.engine, this.tabs));
        this.engine.register(new AggressorBridge(this, this.engine, this.tabs, multiFrame, teamQueue));
        this.engine.register(new ToolBarBridge(this.tool));
        this.engine.register(new TeamServerBridge(this.engine, teamQueue));
        this.engine.register(new DataBridge(this, this.engine, teamQueue));
        this.engine.register(new BeaconBridge(this, this.engine, teamQueue));
        this.engine.register(new BeaconTaskBridge(this));
        this.engine.register(new ElevateBridge(this));
        this.engine.register(new ElevatorBridge(this));
        this.engine.register(new LateralBridge(this));
        this.engine.register(new RemoteExecBridge(this));
        this.engine.register(new UtilityBridge(this));
        this.engine.register(new ReportingBridge(this));
        this.engine.register(new EventLogBridge(this));
        this.engine.register(new CustomEventBridge(this));
        this.engine.register(new SafeDialogBridge(this));
        this.engine.register(new PreferencesBridge(this));
        this.engine.register(new ListenerBridge(this));
        this.engine.register(new CovertVPNBridge(this));
        this.engine.register(new ArtifactBridge(this));
        this.engine.register(new DialogBridge(this));
        this.engine.register(new SiteBridge(this));
        this.engine.register(new AttackBridge());
        this.engine.register(this.aliases.getBridge());
        this.engine.register(this.ssh_aliases.getBridge());
        this.reports.registerInternal("scripts/default.rpt");
        this.data = new DataManager(this.engine);
        this.data.put("metadata", map2);
        this.data.put("options", map3);
        this.data.put("beacon_commands", new BeaconCommands());
        this.data.put("beacon_exploits", new BeaconExploits());
        this.data.put("beacon_elevators", new BeaconElevators());
        this.data.put("beacon_remote_exploits", new BeaconRemoteExploits());
        this.data.put("beacon_remote_exec_methods", new BeaconRemoteExecMethods());
        DataUtils.getBeaconExploits(this.data).registerDefaults(this);
        DataUtils.getBeaconElevators(this.data).registerDefaults(this);
        DataUtils.getBeaconRemoteExploits(this.data).registerDefaults(this);
        DataUtils.getBeaconRemoteExecMethods(this.data).registerDefaults(this);
        this.data.put("ssh_commands", new SecureShellCommands());
        this.tunnels = new TunnelManager(this);
        this.tunnels.init();
        teamQueue.setSubscriber(this.data);
        this.data.subscribe("server_error", this);
        this.data.subscribe("console_license_expiration", this);
        this.tabs.start();
        this.loadScripts();
        this.viz.setLayout(this.viz_c);
        this.split2 = new JSplitPane(0, this.tabs.getTabbedPane(), null);
        this.split2.setDividerSize(0);
        this.split2.setOneTouchExpandable(true);
        this.split = new JSplitPane(0, this.viz, this.split2);
        this.split.setOneTouchExpandable(true);
        this.tool.setFloatable(false);
        this.tool.add(Box.createHorizontalGlue());
        this.licenseLabel.setForeground(Color.BLACK);
        this.licenseLabel.setFont(this.licenseLabel.getFont().deriveFont(1));
        this.closeLicenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggressorClient.this.licensePanel.setVisible(false);
                AggressorClient.this.licenseLabel.setText("");
            }
        });
        this.licensePanel.setBackground(Color.YELLOW);
        Border border = BorderFactory.createEtchedBorder();
        Border border2 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.licensePanel.setBorder(new CompoundBorder(border, border2));
        this.licensePanel.setLayout(new BorderLayout());
        this.licensePanel.add((Component)this.closeLicenseButton, "East");
        this.licensePanel.add((Component)this.licenseLabel, "West");
        this.licensePanel.setVisible(false);
        this.footer.setLayout(new BorderLayout());
        this.footer.add((Component)this.licensePanel, "North");
        this.add((Component)this.split, "Center");
        if (Prefs.getPreferences().isSet("client.toolbar.boolean", true)) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.menu, "North");
            jPanel.add((Component)this.tool, "Center");
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "North");
            this.add((Component)this.split, "Center");
            this.add((Component)this.footer, "South");
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.menu, "North");
            this.add((Component)this.split, "Center");
            this.add((Component)this.footer, "South");
        }
        if (!this.isHeadless()) {
            new SyncMonitor(this);
        }
        this.getData().subscribe("playback.status", new Callback(){

            @Override
            public void result(String string, Object object) {
                PlaybackStatus playbackStatus = (PlaybackStatus)object;
                if (playbackStatus.isDone()) {
                    if (AggressorClient.this.isHeadless()) {
                        GlobalDataManager.getGlobalDataManager().wait(AggressorClient.this.getData());
                    }
                    AggressorClient.this.engine.getEventManager().fireEvent("ready", new Stack());
                    AggressorClient.this.engine.go();
                }
            }
        });
        teamQueue.call("aggressor.ready");
    }

    public void showTime() {
        CommonUtils.Guard();
        this.split.setDividerLocation(0.5);
    }
}

