/*
 * Decompiled with CFR 0.152.
 */
package aggressor;

import aggressor.DataManager;
import aggressor.GenericDataManager;
import aggressor.GlobalDataManager;
import aggressor.Prefs;
import beacon.BeaconCommands;
import beacon.BeaconElevators;
import beacon.BeaconExploits;
import beacon.BeaconRemoteExecMethods;
import beacon.BeaconRemoteExploits;
import c2profile.Profile;
import common.BeaconEntry;
import common.BeaconOutput;
import common.CHECKINSTATE;
import common.Callback;
import common.CodeSigner;
import common.CommonUtils;
import common.ListenerUtils;
import dialog.DialogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class DataUtils {
    private static Prefs.BeaconHealthMonitoringPreferences A = Prefs.getPreferences().getBeaconHealthMonitoringPreferences();
    protected static Map tokenCache = new HashMap();

    public static final String getNick(DataManager dataManager) {
        return dataManager.getMapSafe("metadata").get("nick") + "";
    }

    public static final Map getListenerByName(DataManager dataManager, String string) {
        return (Map)dataManager.getMapSafe("listeners").get(string);
    }

    public static final Map getListeners(DataManager dataManager) {
        return dataManager.getMapSafe("listeners");
    }

    public static String getPostExPipeName(DataManager dataManager, String string) {
        return DataUtils.getProfile(dataManager).getPostExPipeName(string);
    }

    public static final List getNamedPipes(DataManager dataManager) {
        Iterator iterator = DataUtils.getListeners(dataManager).values().iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            Map map2 = (Map)iterator.next();
            if (!"windows/beacon_bind_pipe".equals(DialogUtils.string(map2, "payload"))) continue;
            linkedList.add(DialogUtils.string(map2, "port"));
        }
        return linkedList;
    }

    public static final List getTCPPorts(DataManager dataManager) {
        Iterator iterator = DataUtils.getListeners(dataManager).values().iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            Map map2 = (Map)iterator.next();
            if (!"windows/beacon_bind_tcp".equals(DialogUtils.string(map2, "payload"))) continue;
            linkedList.add(DialogUtils.string(map2, "port"));
        }
        return linkedList;
    }

    public static final long AdjustForSkew(DataManager dataManager, long l) {
        long l2 = CommonUtils.toLongNumber(dataManager.getMapSafe("metadata").get("clockskew") + "", 0L);
        return l - l2;
    }

    public static String getDefaultPipeName(DataManager dataManager, String string) {
        Profile profile = DataUtils.getProfile(dataManager);
        byte[] byArray = DataUtils.getPublicKey(dataManager);
        return DataUtils.getDefaultPipeName(profile, byArray, string);
    }

    public static String getDefaultPipeName(Profile profile, byte[] byArray, String string) {
        String string2 = profile.getString(".pipename");
        return "\\\\" + string + "\\pipe\\" + DataUtils.getPipeName(string2, byArray);
    }

    public static String getPipeName(String string, byte[] byArray) {
        if (!CommonUtils.isin("#", string)) {
            return string;
        }
        String string2 = CommonUtils.toHex(CommonUtils.MD5(byArray));
        while (string2.length() < string.length()) {
            string2 = string2 + string2;
        }
        return CommonUtils.replaceHashes(string, string2);
    }

    public static byte[] getPublicKey(DataManager dataManager) {
        return (byte[])dataManager.getMapSafe("metadata").get("pubkey");
    }

    public static Profile getProfile(DataManager dataManager) {
        return (Profile)dataManager.getMapSafe("metadata").get("c2profile");
    }

    public static boolean hasValidSSL(DataManager dataManager) {
        return "true".equals(dataManager.getMapSafe("metadata").get("validssl"));
    }

    public static boolean hostStage(DataManager dataManager) {
        return DataUtils.getProfile(dataManager).option(".host_stage");
    }

    public static boolean disableAMSI(DataManager dataManager) {
        return "true".equals(dataManager.getMapSafe("metadata").get("amsi_disable"));
    }

    public static boolean obfuscatePostEx(DataManager dataManager) {
        return "true".equals(dataManager.getMapSafe("metadata").get("postex_obfuscate"));
    }

    public static boolean useSmartInject(DataManager dataManager) {
        return "true".equals(dataManager.getMapSafe("metadata").get("postex_smartinject"));
    }

    public static boolean cleanupPostEx(DataManager dataManager) {
        return "true".equals(dataManager.getMapSafe("metadata").get("postex_cleanup"));
    }

    public static boolean hasImportedPowerShell(DataManager dataManager, String string) {
        return DataUtils.getBeaconPowerShellCommands(dataManager, string).size() > 0;
    }

    public static final void reportPowerShellImport(DataManager dataManager, String string, List list) {
        dataManager.put("cmdlets", string, list);
    }

    public static final Map getC2Info(DataManager dataManager) {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : dataManager.getMapSafe("metadata").entrySet()) {
            if (!entry.getKey().toString().startsWith("c2sample.")) continue;
            hashMap.put(entry.getKey().toString().substring(9), entry.getValue());
        }
        hashMap.put("callbacks", dataManager.getListSafe("c2info"));
        return hashMap;
    }

    public static final CodeSigner getSigner(DataManager dataManager) {
        return (CodeSigner)dataManager.getMapSafe("metadata").get("signer");
    }

    public static final Collection getUsers(DataManager dataManager) {
        return dataManager.getSetSafe("users");
    }

    public static long getTime(DataManager dataManager) {
        return System.currentTimeMillis();
    }

    public static String getBeaconPid(DataManager dataManager, String string) {
        BeaconEntry beaconEntry = DataUtils.getBeacon(dataManager, string);
        if (beaconEntry != null) {
            return beaconEntry.getPid();
        }
        return "";
    }

    public static BeaconEntry getBeacon(DataManager dataManager, String string) {
        return DataUtils.getBeaconFromResult(DataUtils.getBeacons(dataManager), string);
    }

    public static List getBeaconChain(DataManager dataManager, String string) {
        return DataUtils.A(dataManager, string, new LinkedList());
    }

    private static List A(DataManager dataManager, String string, List list) {
        BeaconEntry beaconEntry = DataUtils.getBeacon(dataManager, string);
        if (beaconEntry != null) {
            list.add(beaconEntry.getInternal());
        }
        if (beaconEntry.isLinked()) {
            return DataUtils.A(dataManager, beaconEntry.getParentId(), list);
        }
        return list;
    }

    public static byte[] encodeForBeacon(DataManager dataManager, String string, String string2) {
        BeaconEntry beaconEntry = DataUtils.getBeacon(dataManager, string);
        if (beaconEntry == null || beaconEntry.isEmpty()) {
            return CommonUtils.toBytes(string2);
        }
        return CommonUtils.toBytes(string2, beaconEntry.getCharset());
    }

    public static String decodeForBeacon(DataManager dataManager, String string, byte[] byArray) {
        BeaconEntry beaconEntry = DataUtils.getBeacon(dataManager, string);
        if (beaconEntry == null) {
            return CommonUtils.bString(byArray);
        }
        return CommonUtils.bString(byArray, beaconEntry.getCharset());
    }

    public static BeaconEntry getEgressBeacon(DataManager dataManager, String string) {
        BeaconEntry beaconEntry = DataUtils.getBeacon(dataManager, string);
        if (beaconEntry == null) {
            return null;
        }
        if (beaconEntry.isLinked()) {
            return DataUtils.getEgressBeacon(dataManager, beaconEntry.getParentId());
        }
        return beaconEntry;
    }

    public static Map getBeacons(DataManager dataManager) {
        return dataManager.getMapSafe("beacons");
    }

    public static List getBeaconChildren(DataManager dataManager, String string) {
        Iterator iterator = DataUtils.getBeacons(dataManager).entrySet().iterator();
        LinkedList<BeaconEntry> linkedList = new LinkedList<BeaconEntry>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            BeaconEntry beaconEntry = (BeaconEntry)entry.getValue();
            if (!string.equals(beaconEntry.getParentId())) continue;
            linkedList.add(beaconEntry);
        }
        return linkedList;
    }

    public static BeaconEntry getBeaconFromResult(Object object, String string) {
        Map map2 = (Map)object;
        if (map2.containsKey(string)) {
            return (BeaconEntry)map2.get(string);
        }
        return null;
    }

    public static List getBeaconModel(DataManager dataManager) {
        return DataUtils.getBeaconModelFromResult(DataUtils.getBeacons(dataManager));
    }

    public static CHECKINSTATE getBeaconCheckinState(BeaconEntry beaconEntry) {
        if (beaconEntry == null) {
            return CHECKINSTATE.BAD;
        }
        CHECKINSTATE cHECKINSTATE = DataUtils.A.MonitoringType == Prefs.BeaconHealthMonitoringType.BEACONSLEEP ? beaconEntry.getCheckInStateUsingSleep(DataUtils.A.Multiple) : beaconEntry.getCheckInStateUsingPeriod(DataUtils.A.Period);
        return cHECKINSTATE;
    }

    public static List getBeaconModelFromResult(Object object) {
        LinkedList<Map> linkedList = new LinkedList<Map>();
        Map map2 = (Map)object;
        for (BeaconEntry beaconEntry : map2.values()) {
            CHECKINSTATE cHECKINSTATE = DataUtils.getBeaconCheckinState(beaconEntry);
            Map map3 = beaconEntry.toMap();
            if (beaconEntry.isEmpty()) {
                map3.put("image", DialogUtils.TargetVisualizationSmall("unknown", 0.0, false, cHECKINSTATE));
            } else {
                map3.put("image", DialogUtils.TargetVisualizationSmall(beaconEntry.getOperatingSystem().toLowerCase(), beaconEntry.getVersion(), beaconEntry.isAdmin(), cHECKINSTATE));
            }
            if (DataUtils.A.Monitoring == Prefs.BeaconHealthMonitoring.NOCOMMUNICATION) {
                map3.put("checkinstate", cHECKINSTATE == CHECKINSTATE.GOOD);
            } else {
                map3.put("checkinstate", true);
            }
            linkedList.add(map3);
        }
        return linkedList;
    }

    public static List getSites(GenericDataManager genericDataManager) {
        return genericDataManager.getListSafe("sites");
    }

    public static List getTargetNames(DataManager dataManager) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map map2 : dataManager.getListSafe("targets")) {
            String string = (String)map2.get("name");
            if (string == null) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    public static List getListenerModel(GenericDataManager genericDataManager, DataManager dataManager) {
        Map map2 = ListenerUtils.filterLocal(genericDataManager.getMapSafe("listeners"));
        Map map3 = dataManager.getMapSafe("listeners");
        map2.putAll(map3);
        return new LinkedList(map2.values());
    }

    public static String getAddressFor(DataManager dataManager, String string) {
        List list = dataManager.getListSafe("targets");
        for (Map map2 : list) {
            if (!string.equals(map2.get("address"))) continue;
            String string2 = (String)map2.get("name");
            if (string2 != null && !"".equals(string2)) {
                return string2;
            }
            return string;
        }
        return string;
    }

    public static List getListenerModel(DataManager dataManager) {
        return new LinkedList(dataManager.getMapSafe("listeners").values());
    }

    public static List getBeaconTranscriptAndSubscribe(DataManager dataManager, String string, Callback callback) {
        LinkedList linkedList = dataManager.getTranscriptAndSubscribeSafe("beaconlog", callback);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            BeaconOutput beaconOutput = (BeaconOutput)iterator.next();
            if (beaconOutput.is(string)) continue;
            iterator.remove();
        }
        return linkedList;
    }

    public static List getScreenshotTranscript(DataManager dataManager) {
        return dataManager.getTranscriptSafe("screenshots");
    }

    public static List getKeystrokesTranscript(DataManager dataManager) {
        return dataManager.getTranscriptSafe("keystrokes");
    }

    public static BeaconCommands getBeaconCommands(DataManager dataManager) {
        return (BeaconCommands)dataManager.get("beacon_commands", null);
    }

    public static BeaconCommands getSSHCommands(DataManager dataManager) {
        return (BeaconCommands)dataManager.get("ssh_commands", null);
    }

    public static BeaconExploits getBeaconExploits(DataManager dataManager) {
        return (BeaconExploits)dataManager.get("beacon_exploits", null);
    }

    public static BeaconElevators getBeaconElevators(DataManager dataManager) {
        return (BeaconElevators)dataManager.get("beacon_elevators", null);
    }

    public static BeaconRemoteExploits getBeaconRemoteExploits(DataManager dataManager) {
        return (BeaconRemoteExploits)dataManager.get("beacon_remote_exploits", null);
    }

    public static BeaconRemoteExecMethods getBeaconRemoteExecMethods(DataManager dataManager) {
        return (BeaconRemoteExecMethods)dataManager.get("beacon_remote_exec_methods", null);
    }

    public static List getBeaconPowerShellCommands(DataManager dataManager, String string) {
        Map map2 = dataManager.getMapSafe("cmdlets");
        List list = (List)map2.get(string);
        if (list == null) {
            return new LinkedList();
        }
        return list;
    }

    public static String getPrimaryStage(DataManager dataManager) {
        List list = DataUtils.getListenerModel(dataManager);
        for (Map map2 : list) {
            String string = map2.get("payload") + "";
            if ("windows/beacon_http/reverse_http".equals(string)) {
                return "HTTP Beacon";
            }
            if ("windows/beacon_https/reverse_https".equals(string)) {
                return "HTTPS Beacon";
            }
            if ("windows/beacon_dns/reverse_http".equals(string)) {
                return "DNS Beacon";
            }
            if (!"windows/beacon_dns/reverse_dns_txt".equals(string)) continue;
            return "DNS Beacon";
        }
        return "";
    }

    public static String getLocalIP(DataManager dataManager) {
        return (String)dataManager.get("localip", "127.0.0.1");
    }

    public static String getTeamServerIP(DataManager dataManager) {
        return dataManager.getMapSafe("options").get("host") + "";
    }

    public static List getInterfaceList(DataManager dataManager) {
        List list = dataManager.getListSafe("interfaces");
        LinkedList linkedList = new LinkedList();
        for (Map map2 : list) {
            linkedList.add(map2.get("interface"));
        }
        return linkedList;
    }

    public static Map getInterface(DataManager dataManager, String string) {
        List list = dataManager.getListSafe("interfaces");
        for (Map map2 : list) {
            if (!string.equals(map2.get("interface"))) continue;
            return map2;
        }
        return new HashMap();
    }

    public static String getManualProxySetting(DataManager dataManager) {
        String string = (String)dataManager.getDataSafe("manproxy");
        if (string == null) {
            return "";
        }
        return string;
    }

    public static Map getGoldenTicket(DataManager dataManager) {
        return dataManager.getMapSafe("goldenticket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String TokenToEmail(String string) {
        if (string == null || "".equals(string)) {
            return "unknown";
        }
        Map map2 = tokenCache;
        synchronized (map2) {
            if (tokenCache.containsKey(string)) {
                return (String)tokenCache.get(string);
            }
            GlobalDataManager globalDataManager = GlobalDataManager.getGlobalDataManager();
            List list = globalDataManager.getListSafe("tokens");
            for (Map map3 : list) {
                String string2 = (String)map3.get("token");
                String string3 = (String)map3.get("email");
                tokenCache.put(string2, string3);
            }
            if (tokenCache.containsKey(string)) {
                return (String)tokenCache.get(string);
            }
        }
        return "unknown";
    }

    public static String getSystemCallMethod(DataManager dataManager) {
        String string = DataUtils.getProfile(dataManager).getString(".stage.syscall_method");
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }
}

