/*
 * Decompiled with CFR 0.152.
 */
package aggressor;

import common.CommonUtils;
import common.MudgeSanity;
import common.RangeList;
import encoders.Base64;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Prefs {
    protected static final Prefs prefs = new Prefs();
    protected Properties data = null;

    protected File myFile() {
        return new File(System.getProperty("user.home"), ".aggressor.prop");
    }

    protected Prefs() {
    }

    public void load() {
        if (this.data != null) {
            return;
        }
        File file = this.myFile();
        try {
            this.data = new Properties();
            InputStream inputStream = null;
            inputStream = file.exists() ? new FileInputStream(file) : CommonUtils.resource("resources/aggressor.prop");
            this.data.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("Load Preferences: " + file, iOException, false);
        }
    }

    public void scrub() {
        try {
            LinkedList linkedList = new LinkedList(this.getList("trusted.servers"));
            if (linkedList.size() > 100) {
                while (linkedList.size() > 50) {
                    linkedList.removeFirst();
                }
                this.setList("trusted.servers", linkedList);
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet(this.getList("connection.profiles"));
            Iterator<Map.Entry<Object, Object>> iterator = this.data.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                if (!entry.getKey().toString().startsWith("connection.profiles.")) continue;
                String string = entry.getKey().toString().substring("connection.profiles.".length());
                if (linkedHashSet.contains(string = string.substring(0, string.lastIndexOf(".")))) continue;
                iterator.remove();
            }
        }
        catch (Exception exception) {
            MudgeSanity.logException("scrub preferences", exception, false);
        }
    }

    public void save() {
        this.scrub();
        File file = this.myFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.data.store(fileOutputStream, "Cobalt Strike (Aggressor) Configuration");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("Save Preferences: " + file, iOException, false);
        }
    }

    public String getString(String string, String string2) {
        return this.data.getProperty(string, string2);
    }

    public boolean isSet(String string, boolean bl) {
        return "true".equals(this.getString(string, bl + ""));
    }

    public long getLongNumber(String string, long l) {
        return CommonUtils.toLongNumber(this.getString(string, l + ""), l);
    }

    public int getRandomPort(String string, String string2) {
        String string3 = this.getString(string, string2);
        if ("".equals(string3)) {
            string3 = string2;
        }
        RangeList rangeList = new RangeList(string3);
        return rangeList.random();
    }

    public Color getColor(String string, String string2) {
        return Color.decode(this.getString(string, string2));
    }

    public Font getFont(String string, String string2) {
        return Font.decode(this.getString(string, string2));
    }

    public BeaconHealthMonitoring getBeaconHealthMonitoring(String string) {
        BeaconHealthMonitoringPreferencesDefaults beaconHealthMonitoringPreferencesDefaults = this.getBeaconHealthMonitoringPreferencesDefaults();
        if (beaconHealthMonitoringPreferencesDefaults.BeaconHealthMonitoringOptions.containsKey(string)) {
            return beaconHealthMonitoringPreferencesDefaults.BeaconHealthMonitoringOptions.get(string);
        }
        return beaconHealthMonitoringPreferencesDefaults.BeaconHealthMonitoringOptionsDefault;
    }

    public BeaconHealthMonitoringType getBeaconHealthMonitoringType(String string) {
        BeaconHealthMonitoringPreferencesDefaults beaconHealthMonitoringPreferencesDefaults = this.getBeaconHealthMonitoringPreferencesDefaults();
        if (beaconHealthMonitoringPreferencesDefaults.BeaconHealthMonitoringTypeOptions.containsKey(string)) {
            return beaconHealthMonitoringPreferencesDefaults.BeaconHealthMonitoringTypeOptions.get(string);
        }
        return beaconHealthMonitoringPreferencesDefaults.BeaconHealthMonitoringTypeOptionsDefault;
    }

    public BeaconHealthMonitoringPreferences getBeaconHealthMonitoringPreferences() {
        BeaconHealthMonitoringPreferencesDefaults beaconHealthMonitoringPreferencesDefaults = this.getBeaconHealthMonitoringPreferencesDefaults();
        String string = this.getString("beacon.health.monitoring.enable", beaconHealthMonitoringPreferencesDefaults.BeaconHealthMonitoringOptionsDefaultString);
        long l = this.getLongNumber("beacon.health.monitoring.period", beaconHealthMonitoringPreferencesDefaults.PeriodDefault);
        String string2 = this.getString("beacon.health.monitoring.type", beaconHealthMonitoringPreferencesDefaults.BeaconHealthMonitoringTypeOptionsDefaultString);
        long l2 = this.getLongNumber("beacon.health.monitoring.missedcheckins", beaconHealthMonitoringPreferencesDefaults.MultipleDefault);
        BeaconHealthMonitoring beaconHealthMonitoring = this.getBeaconHealthMonitoring(string);
        BeaconHealthMonitoringType beaconHealthMonitoringType = this.getBeaconHealthMonitoringType(string2);
        BeaconHealthMonitoringPreferences beaconHealthMonitoringPreferences = new BeaconHealthMonitoringPreferences(beaconHealthMonitoring, beaconHealthMonitoringType, l, l2);
        return beaconHealthMonitoringPreferences;
    }

    public BeaconHealthMonitoringPreferencesDefaults getBeaconHealthMonitoringPreferencesDefaults() {
        BeaconHealthMonitoringPreferencesDefaults beaconHealthMonitoringPreferencesDefaults = new BeaconHealthMonitoringPreferencesDefaults();
        return beaconHealthMonitoringPreferencesDefaults;
    }

    public List getList(String string) {
        String string2 = this.getString(string, "");
        if ("".equals(string2)) {
            return new LinkedList();
        }
        return CommonUtils.toList(string2.split("!!"));
    }

    public void appendList(String string, String string2) {
        List list = this.getList(string);
        list.add(string2);
        this.setList(string, new LinkedList(new LinkedHashSet(list)));
    }

    public void setList(String string, List linkedList) {
        linkedList = new LinkedList(linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 != null && !"".equals(string2)) continue;
            iterator.remove();
        }
        this.set(string, CommonUtils.join(linkedList, "!!"));
    }

    public void set(String string, String string2) {
        this.data.setProperty(string, string2);
    }

    public void update(Map map2) {
        for (Map.Entry entry : map2.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            this.data.setProperty(string, string2);
        }
        this.save();
    }

    public Map copy() {
        return new HashMap<Object, Object>(this.data);
    }

    public static Prefs getPreferences() {
        prefs.load();
        return prefs;
    }

    public final class BeaconHealthMonitoringPreferences {
        public final BeaconHealthMonitoring Monitoring;
        public final BeaconHealthMonitoringType MonitoringType;
        public final long Period;
        public final long Multiple;

        public BeaconHealthMonitoringPreferences(BeaconHealthMonitoring beaconHealthMonitoring, BeaconHealthMonitoringType beaconHealthMonitoringType, long l, long l2) {
            this.Monitoring = beaconHealthMonitoring;
            this.MonitoringType = beaconHealthMonitoringType;
            this.Period = l;
            this.Multiple = l2;
        }
    }

    public final class BeaconHealthMonitoringPreferencesDefaults {
        public final LinkedHashMap<String, BeaconHealthMonitoring> BeaconHealthMonitoringOptions = new LinkedHashMap();
        public final String BeaconHealthMonitoringOptionsDefaultString;
        public final BeaconHealthMonitoring BeaconHealthMonitoringOptionsDefault;
        public final LinkedHashMap<String, BeaconHealthMonitoringType> BeaconHealthMonitoringTypeOptions;
        public final String BeaconHealthMonitoringTypeOptionsDefaultString;
        public final BeaconHealthMonitoringType BeaconHealthMonitoringTypeOptionsDefault;
        public final long PeriodDefault;
        public final long MultipleDefault;

        public BeaconHealthMonitoringPreferencesDefaults() {
            this.BeaconHealthMonitoringOptions.put("None", BeaconHealthMonitoring.DISABLED);
            this.BeaconHealthMonitoringOptions.put("No communication", BeaconHealthMonitoring.NOCOMMUNICATION);
            this.BeaconHealthMonitoringOptionsDefaultString = (String)this.BeaconHealthMonitoringOptions.keySet().toArray()[1];
            this.BeaconHealthMonitoringOptionsDefault = this.BeaconHealthMonitoringOptions.get(this.BeaconHealthMonitoringOptionsDefaultString);
            this.BeaconHealthMonitoringTypeOptions = new LinkedHashMap();
            this.BeaconHealthMonitoringTypeOptions.put("Sleep period for the beacon", BeaconHealthMonitoringType.BEACONSLEEP);
            this.BeaconHealthMonitoringTypeOptions.put("User defined period for all beacons", BeaconHealthMonitoringType.USERDEFINED);
            this.BeaconHealthMonitoringTypeOptionsDefaultString = (String)this.BeaconHealthMonitoringTypeOptions.keySet().toArray()[0];
            this.BeaconHealthMonitoringTypeOptionsDefault = this.BeaconHealthMonitoringTypeOptions.get(this.BeaconHealthMonitoringTypeOptionsDefaultString);
            this.PeriodDefault = 60L;
            this.MultipleDefault = 3L;
        }
    }

    public static enum BeaconHealthMonitoringType {
        BEACONSLEEP,
        USERDEFINED;

    }

    public static enum BeaconHealthMonitoring {
        DISABLED,
        NOCOMMUNICATION;

    }

    public static final class PrefLoader {
        public static final boolean isPrefEnabled() {
            return false;
        }

        public static final boolean load(Class clazz) {
            if (!PrefLoader.A(clazz)) {
                System.exit(1);
            }
            return true;
        }

        private static final boolean A(Method method, Class clazz, boolean bl, String string, long l) {
            Object var6_5 = null;
            try {
                return (Boolean)method.invoke(var6_5, clazz, PrefLoader.A(string), bl, l);
            }
            catch (Throwable throwable) {
                System.exit(1);
                return false;
            }
        }

        private static final String A(String string, String string2) {
            return new String(Base64.decode(string));
        }

        private static final Class A(String string) {
            try {
                return Class.forName(PrefLoader.A(string, ""));
            }
            catch (Throwable throwable) {
                System.exit(1);
                return null;
            }
        }

        private static final boolean A(Class clazz) {
            boolean bl = true;
            Method method = null;
            String string = "Y29tbW9uLkNvbW1vblV0aWxz";
            String string2 = "amF2YS5sYW5nLkNsYXNz";
            String string3 = "dmFsaWRDbGFzc0ludGVncml0eQ==";
            Class<?> clazz2 = null;
            try {
                clazz2 = Class.forName(PrefLoader.A(string, ""));
                Class<?> clazz3 = Class.forName(PrefLoader.A(string2, ""));
                method = clazz2.getDeclaredMethod(PrefLoader.A(string3, ""), clazz3, clazz3, Boolean.TYPE, Long.TYPE);
            }
            catch (Throwable throwable) {
                System.exit(1);
            }
            bl = bl && PrefLoader.A(method, clazz, false, "Y29uc29sZS5TdGF0dXNCYXIkU3RhdHVzQmFySGVscGVy", 3835397815L);
            bl = bl && PrefLoader.A(method, clazz, false, "Z3JhcGguTmV0d29ya0dyYXBo", 3864160077L);
            return bl;
        }
    }
}

