/*
 * Decompiled with CFR 0.152.
 */
package aggressor;

import common.CommonUtils;
import common.MudgeSanity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class PropsFile {
    protected Properties data = null;

    protected abstract String myName();

    protected abstract String myTitle();

    protected abstract String myFilePath();

    protected abstract String myFileName();

    protected abstract String resourceFileName();

    protected PropsFile() {
    }

    protected File myFile() {
        String string = this.myFilePath();
        if (string.length() == 0) {
            string = ".";
        }
        File file = new File(string);
        try {
            String string2 = file.getCanonicalPath();
            return new File(string2, this.myFileName());
        }
        catch (IOException iOException) {
            return new File(string, this.myFileName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(boolean bl, boolean bl2) {
        if (this.data != null) {
            return;
        }
        File file = this.myFile();
        InputStream inputStream = null;
        try {
            block23: {
                this.data = new Properties();
                if (file.exists()) {
                    if (!bl2) {
                        CommonUtils.print_info("Loading properties file (" + file.getAbsolutePath() + ").");
                    }
                    inputStream = new FileInputStream(file);
                } else if (bl) {
                    String string = "resources/" + this.resourceFileName();
                    try {
                        if (!bl2) {
                            CommonUtils.print_info("Loading properties file from resources (" + string + ").");
                        }
                        inputStream = CommonUtils.resource(string);
                    }
                    catch (Exception exception) {
                        if (bl2) break block23;
                        String string2 = "Load " + this.myName() + " resources (" + string + ")";
                        MudgeSanity.logException(string2, exception, false);
                    }
                }
            }
            if (inputStream != null) {
                this.data.load(inputStream);
                if (!bl2) {
                    CommonUtils.print_info("Properties file was loaded.");
                }
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            if (!bl2) {
                String string = "Load " + this.myName() + "(" + file + ")";
                MudgeSanity.logException(string, iOException, false);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void scrub() {
    }

    public void save() {
        this.scrub();
        File file = this.myFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.data.store(fileOutputStream, this.myTitle());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            String string = "Save " + this.myName() + "(" + file + ")";
            MudgeSanity.logException(string, iOException, false);
        }
    }

    public boolean isSet(String string, boolean bl) {
        return "true".equals(this.getString(string, bl + ""));
    }

    public void set(String string, String string2) {
        this.data.setProperty(string, string2);
    }

    public Object remove(String string) {
        return this.data.remove(string);
    }

    public boolean exists(String string) {
        return this.data.containsKey(string);
    }

    public String getString(String string, String string2) {
        return this.data.getProperty(string, string2);
    }

    public long getLongNumber(String string, long l) {
        return CommonUtils.toLongNumber(this.getString(string, l + "").trim(), l);
    }

    public int getIntNumber(String string, int n) {
        long l = this.getLongNumber(string, n);
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            CommonUtils.print_warn("Value (" + l + ") for key (" + string + ") is not a valid integer");
            return n;
        }
        return (int)l;
    }

    public List getList(String string) {
        String string2 = this.getString(string, "");
        if ("".equals(string2)) {
            return new LinkedList();
        }
        return CommonUtils.toList(string2.split("!!"));
    }

    public void appendList(String string, String string2) {
        List list = this.getList(string);
        list.add(string2);
        this.setList(string, new LinkedList(new LinkedHashSet(list)));
    }

    public void setList(String string, List linkedList) {
        linkedList = new LinkedList(linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 != null && !"".equals(string2)) continue;
            iterator.remove();
        }
        this.set(string, CommonUtils.join(linkedList, "!!"));
    }

    public void update(Map map2) {
        for (Map.Entry entry : map2.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            this.data.setProperty(string, string2);
        }
        this.save();
    }

    public Map copy() {
        return new HashMap<Object, Object>(this.data);
    }

    protected void testPropertiesFile() {
        this.testLogAbstractMethods();
    }

    protected void testPrintSectionHead(String string) {
        CommonUtils.print_info("========== " + string + " ==========");
    }

    protected void testLogAbstractMethods() {
        this.testPrintSectionHead("testLogAbstractMethods");
        CommonUtils.print_info("myName: " + this.myName());
        CommonUtils.print_info("myTitle: " + this.myTitle());
        CommonUtils.print_info("myFilePath: " + this.myFilePath());
        CommonUtils.print_info("myFileName: " + this.myFileName());
        CommonUtils.print_info("resourceFileName: " + this.resourceFileName());
    }
}

