/*
 * Decompiled with CFR 0.152.
 */
package aggressor;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import aggressor.Prefs;
import aggressor.dialogs.PreferencesDialog;
import aggressor.dialogs.SessionChooser;
import common.AObject;
import common.BeaconEntry;
import common.Callback;
import common.CommonUtils;
import common.TabScreenshot;
import console.Activity;
import console.Associated;
import console.Console;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import dialog.SolidIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import ui.ColorPanel;
import ui.DraggableTabbedPane;
import ui.KeyHandler;

public class TabManager
extends AObject
implements Callback {
    protected JTabbedPane tabs = new DraggableTabbedPane();
    protected _A docked = null;
    protected LinkedList apptabs = new LinkedList();
    protected AggressorClient client = null;
    protected ColorPanel colors = new ColorPanel();

    public boolean activate(String string) {
        CommonUtils.Guard();
        for (_A _A2 : this.apptabs) {
            if (!string.equals(_A2.E)) continue;
            this.tabs.setSelectedComponent(_A2.C);
            return true;
        }
        return false;
    }

    public boolean activateConsole(String string) {
        CommonUtils.Guard();
        for (_A _A2 : this.apptabs) {
            if (!string.equals(_A2.A) || !(_A2.C instanceof Console)) continue;
            this.tabs.setSelectedComponent(_A2.C);
            ((Console)_A2.C).requestFocusInWindow();
            return true;
        }
        return false;
    }

    public void bindShortcuts() {
        this.client.bindKey("Ctrl+I", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                new SessionChooser(TabManager.this.client, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        DialogUtils.openOrActivate(TabManager.this.client, string);
                    }
                }).show();
            }
        });
        this.client.bindKey("Ctrl+W", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                TabManager.this.openActiveTab();
            }
        });
        this.client.bindKey("Ctrl+B", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                TabManager.this.dockActiveTab();
            }
        });
        this.client.bindKey("Ctrl+E", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                TabManager.this.noDock();
            }
        });
        this.client.bindKey("Ctrl+D", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                TabManager.this.closeActiveTab();
            }
        });
        this.client.bindKey("Shift+Ctrl+D", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                TabManager.this.closeAllButActiveTab();
            }
        });
        this.client.bindKey("Ctrl+R", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                TabManager.this.renameActiveTab();
            }
        });
        this.client.bindKey("Ctrl+T", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                TabManager.this.snapActiveTab();
                DialogUtils.showInfo("Pushed screenshot to team server (active tab)");
            }
        });
        this.client.bindKey("Shift+Ctrl+T", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                TabManager.this.snapActiveWindow();
                DialogUtils.showInfo("Pushed screenshot to team server (window)");
            }
        });
        this.client.bindKey("Ctrl+Left", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                TabManager.this.previousTab();
            }
        });
        this.client.bindKey("Ctrl+Right", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                TabManager.this.nextTab();
            }
        });
        this.client.bindKey("Ctrl+O", new KeyHandler(){

            @Override
            public void key_pressed(String string) {
                new PreferencesDialog().show();
            }
        });
    }

    public TabManager(AggressorClient aggressorClient) {
        Prefs.PrefLoader.load(this.getClass());
        this.client = aggressorClient;
        this.bindShortcuts();
    }

    public JTabbedPane getTabbedPane() {
        return this.tabs;
    }

    public void _removeTab(JComponent jComponent) {
        this.tabs.remove(jComponent);
        this.tabs.validate();
    }

    public void removeTab(final JComponent jComponent) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                TabManager.this._removeTab(jComponent);
            }
        });
    }

    public void nextTab() {
        this.tabs.setSelectedIndex((this.tabs.getSelectedIndex() + 1) % this.tabs.getTabCount());
    }

    public void previousTab() {
        if (this.tabs.getSelectedIndex() == 0) {
            this.tabs.setSelectedIndex(this.tabs.getTabCount() - 1);
        } else {
            this.tabs.setSelectedIndex((this.tabs.getSelectedIndex() - 1) % this.tabs.getTabCount());
        }
    }

    public void addTab(final String string, final JComponent jComponent, final ActionListener actionListener) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                TabManager.this._addTab(string, jComponent, actionListener, null);
            }
        });
    }

    public void addTab(final String string, final JComponent jComponent, final ActionListener actionListener, final String string2) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                TabManager.this._addTab(string, jComponent, actionListener, string2);
            }
        });
    }

    public void closeActiveTab() {
        CommonUtils.Guard();
        JComponent jComponent = (JComponent)this.tabs.getSelectedComponent();
        if (jComponent != null) {
            this.removeAppTab(jComponent, null, new ActionEvent(jComponent, 0, "boo!"));
        }
    }

    public void closeAllButActiveTab() {
        CommonUtils.Guard();
        JComponent jComponent = (JComponent)this.tabs.getSelectedComponent();
        for (_A _A2 : new LinkedList(this.apptabs)) {
            if (_A2.C == jComponent) continue;
            this.removeAppTab(_A2.C, null, new ActionEvent(_A2.C, 0, "boo!"));
        }
    }

    public void openActiveTab() {
        CommonUtils.Guard();
        JComponent jComponent = (JComponent)this.tabs.getSelectedComponent();
        if (jComponent != null) {
            this.popAppTab(jComponent);
        }
    }

    public void noDock() {
        CommonUtils.Guard();
        if (this.docked != null) {
            if (this.docked.D != null) {
                this.docked.D.actionPerformed(new ActionEvent(this.docked.C, 0, "close"));
            }
            this.client.noDock();
            this.docked = null;
        }
    }

    public void dockActiveTab() {
        CommonUtils.Guard();
        JComponent jComponent = (JComponent)this.tabs.getSelectedComponent();
        if (jComponent != null) {
            this.dockAppTab(jComponent);
        }
    }

    public void snapActiveWindow() {
        CommonUtils.Guard();
        byte[] byArray = DialogUtils.screenshot(this.client.getWindow());
        this.client.getConnection().call("aggressor.screenshot", CommonUtils.args(new TabScreenshot(this.client.getWindow().getTitle(), byArray)));
    }

    public void renameActiveTab() {
        CommonUtils.Guard();
        JComponent jComponent = (JComponent)this.tabs.getSelectedComponent();
        for (_A _A2 : this.apptabs) {
            if (_A2.C != jComponent) continue;
            this.renameAppTab(_A2.B);
            return;
        }
    }

    public void snapActiveTab() {
        CommonUtils.Guard();
        JComponent jComponent = (JComponent)this.tabs.getSelectedComponent();
        for (_A _A2 : this.apptabs) {
            if (_A2.C != jComponent) continue;
            this.snapAppTab(_A2.E, jComponent);
        }
    }

    public void addAppTab(String string, JComponent jComponent, JLabel jLabel, String string2, ActionListener actionListener) {
        BeaconEntry beaconEntry;
        CommonUtils.Guard();
        _A _A2 = new _A();
        _A2.E = string;
        _A2.C = jComponent;
        _A2.D = actionListener;
        _A2.B = jLabel;
        _A2.A = string2;
        this.apptabs.add(_A2);
        if (!"".equals(string2) && (beaconEntry = DataUtils.getBeacon(this.client.getData(), string2)) != null) {
            this.processBeacon(_A2, beaconEntry);
        }
    }

    public void popAppTab(Component component) {
        CommonUtils.Guard();
        Iterator iterator = this.apptabs.iterator();
        while (iterator.hasNext()) {
            final _A _A2 = (_A)iterator.next();
            if (_A2.C != component) continue;
            this.tabs.remove(_A2.C);
            iterator.remove();
            final JFrame jFrame = new JFrame(_A2.E);
            jFrame.setLayout(new BorderLayout());
            jFrame.add((Component)_A2.C, "Center");
            jFrame.pack();
            _A2.C.validate();
            jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    if (_A2.D != null) {
                        _A2.D.actionPerformed(new ActionEvent(windowEvent.getSource(), 0, "close"));
                    }
                }

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    jFrame.setState(0);
                    _A2.C.requestFocusInWindow();
                }

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                    _A2.C.requestFocusInWindow();
                }
            });
            jFrame.setState(1);
            jFrame.setVisible(true);
        }
    }

    public void dockAppTab(Component component) {
        CommonUtils.Guard();
        Iterator iterator = this.apptabs.iterator();
        while (iterator.hasNext()) {
            _A _A2 = (_A)iterator.next();
            if (_A2.C != component) continue;
            this.tabs.remove(_A2.C);
            iterator.remove();
            Dimension dimension = new Dimension(100, 150);
            if (this.docked != null) {
                dimension = this.docked.C.getSize();
                if (this.docked.D != null) {
                    this.docked.D.actionPerformed(new ActionEvent(this.docked.C, 0, "close"));
                }
            }
            this.client.dock(_A2.C, dimension);
            this.docked = _A2;
        }
    }

    public void snapAppTab(String string, Component component) {
        byte[] byArray = DialogUtils.screenshot(component);
        this.client.getConnection().call("aggressor.screenshot", CommonUtils.args(new TabScreenshot(string, byArray)));
    }

    public void renameAppTab(JLabel jLabel) {
        String string = JOptionPane.showInputDialog("Rename tab to:", (Object)(jLabel.getText() + "").trim());
        if (string != null) {
            jLabel.setText(string + "   ");
        }
    }

    public void removeAppTab(Component component, String string, ActionEvent actionEvent) {
        String string2;
        CommonUtils.Guard();
        Iterator iterator = this.apptabs.iterator();
        String string3 = string2 = string != null ? string.split(" ")[0] : "%b%";
        while (iterator.hasNext()) {
            String string4;
            _A _A2 = (_A)iterator.next();
            String string5 = string4 = _A2.E != null ? _A2.E.split(" ")[0] : "%a%";
            if (_A2.C != component && !string4.equals(string2)) continue;
            this.tabs.remove(_A2.C);
            if (_A2.D != null) {
                _A2.D.actionPerformed(actionEvent);
            }
            iterator.remove();
        }
    }

    public void _addTab(final String string, final JComponent jComponent, ActionListener actionListener, String string2) {
        if (actionListener == null) {
            CommonUtils.print_error("Opened: " + string + " with no remove listener");
        }
        final Component component = this.tabs.add("", jComponent);
        final JLabel jLabel = new JLabel(string + "   ");
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "Center");
        if (jComponent instanceof Activity) {
            ((Activity)((Object)jComponent)).registerLabel(jLabel);
        }
        String string3 = "";
        if (jComponent instanceof Associated) {
            string3 = ((Associated)((Object)jComponent)).getBeaconID();
        }
        JButton jButton = new JButton("X");
        jButton.setOpaque(false);
        jButton.setContentAreaFilled(false);
        jButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)jButton, "East");
        if (string2 != null) {
            jButton.setToolTipText(string2);
        }
        int n = this.tabs.indexOfComponent(component);
        this.tabs.setTabComponentAt(n, jPanel);
        this.addAppTab(string, jComponent, jLabel, string3, actionListener);
        jButton.addMouseListener(new MouseAdapter(){

            public void A(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem("Open in window", 79);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TabManager.this.popAppTab(component);
                        }
                    });
                    JMenuItem jMenuItem2 = new JMenuItem("Close like tabs", 67);
                    jMenuItem2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TabManager.this.removeAppTab(null, string, actionEvent);
                        }
                    });
                    JMenuItem jMenuItem3 = new JMenuItem("Save screenshot", 83);
                    jMenuItem3.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TabManager.this.snapAppTab(string, jComponent);
                            DialogUtils.showInfo("Pushed screenshot to team server");
                        }
                    });
                    JMenuItem jMenuItem4 = new JMenuItem("Send to bottom", 98);
                    jMenuItem4.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TabManager.this.dockAppTab(component);
                        }
                    });
                    JMenuItem jMenuItem5 = new JMenuItem("Rename Tab", 82);
                    jMenuItem5.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TabManager.this.renameAppTab(jLabel);
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.add(jMenuItem3);
                    jPopupMenu.add(jMenuItem4);
                    jPopupMenu.add(jMenuItem5);
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(jMenuItem2);
                    jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                    mouseEvent.consume();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ((actionEvent.getModifiers() & 2) == 2) {
                    TabManager.this.popAppTab(component);
                } else if ((actionEvent.getModifiers() & 1) == 1) {
                    TabManager.this.removeAppTab(null, string, actionEvent);
                } else {
                    TabManager.this.removeAppTab(component, null, actionEvent);
                }
                System.gc();
            }
        });
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                if (component instanceof Activity) {
                    ((Activity)((Object)component)).resetNotification();
                }
                component.requestFocusInWindow();
                System.gc();
            }
        });
        this.tabs.setSelectedIndex(n);
        component.requestFocusInWindow();
    }

    public void touch() {
        CommonUtils.Guard();
        Component component = this.tabs.getSelectedComponent();
        if (component == null) {
            return;
        }
        if (component instanceof Activity) {
            ((Activity)((Object)component)).resetNotification();
        }
        component.requestFocusInWindow();
    }

    public void start() {
        this.client.getData().subscribe("beacons", this);
    }

    public void stop() {
        this.client.getData().unsub("beacons", this);
    }

    public void processBeacon(_A _A2, BeaconEntry beaconEntry) {
        String string;
        String string2 = beaconEntry.title() + "   ";
        if (!_A2.E.equals(string2) && _A2.C instanceof Console) {
            _A2.B.setText(string2);
            _A2.E = string2;
        }
        if ("".equals(string = beaconEntry.getAccent())) {
            _A2.B.setIcon(null);
        } else {
            _A2.B.setIcon(new SolidIcon(this.colors.getBackColor(string), 12, 12));
        }
    }

    @Override
    public void result(String string, final Object object) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                for (_A _A2 : TabManager.this.apptabs) {
                    BeaconEntry beaconEntry;
                    if ("".equals(_A2.A) || (beaconEntry = DataUtils.getBeaconFromResult(object, _A2.A)) == null) continue;
                    TabManager.this.processBeacon(_A2, beaconEntry);
                }
            }
        });
    }

    private static class _A {
        public String E;
        public JComponent C;
        public ActionListener D;
        public JLabel B;
        public String A;

        private _A() {
        }

        public String toString() {
            return this.E;
        }
    }
}

