/*
 * Decompiled with CFR 0.152.
 */
package aggressor.bridges;

import aggressor.AggressorClient;
import common.CommonUtils;
import common.Keys;
import common.PivotHint;
import common.RegexParser;
import cortana.Cortana;
import data.DataAggregate;
import dialog.DialogUtils;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class AggregateBridge
implements Function,
Loadable {
    protected AggressorClient client;

    public AggregateBridge(AggressorClient aggressorClient) {
        this.client = aggressorClient;
    }

    @Override
    public void scriptLoaded(ScriptInstance scriptInstance) {
        Cortana.put(scriptInstance, "&aggregate", this);
        Cortana.put(scriptInstance, "&agConvert", this);
        Cortana.put(scriptInstance, "&agArchives", this);
        Iterator iterator = Keys.getDataModelIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            string = string.substring(0, 1).toUpperCase() + string.substring(1);
            final String string2 = string.toLowerCase();
            Cortana.put(scriptInstance, "&ag" + string, new Function(){

                @Override
                public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
                    Map map2 = (Map)BridgeUtilities.getObject(stack);
                    return CommonUtils.convertAll((List)map2.get(string2));
                }
            });
        }
        Cortana.put(scriptInstance, "&agServicesForHost", this);
        Cortana.put(scriptInstance, "&agSessionsForHost", this);
        Cortana.put(scriptInstance, "&agCredentialsForHost", this);
        Cortana.put(scriptInstance, "&agWebHitsForEmail", this);
        Cortana.put(scriptInstance, "&agWebHitsForToken", this);
        Cortana.put(scriptInstance, "&agCountWebHitsByToken", this);
        Cortana.put(scriptInstance, "&agSentEmailsForCampaign", this);
        Cortana.put(scriptInstance, "&agSentEmailsForEmailAddress", this);
        Cortana.put(scriptInstance, "&agApplicationsForEmailAddress", this);
        Cortana.put(scriptInstance, "&agFileIndicatorsForSession", this);
        Cortana.put(scriptInstance, "&agFileIndicators", this);
        Cortana.put(scriptInstance, "&agOtherIndicatorsForSession", this);
        Cortana.put(scriptInstance, "&agTasksAndCheckinsForSession", this);
        Cortana.put(scriptInstance, "&agServices", this);
        Cortana.put(scriptInstance, "&agArchivesByTactic", this);
        Cortana.put(scriptInstance, "&agTacticsUsed", this);
        Cortana.put(scriptInstance, "&agTokenToEmail", this);
        Cortana.put(scriptInstance, "&agEmailAddresses", this);
        Cortana.put(scriptInstance, "&agCampaigns", this);
        Cortana.put(scriptInstance, "&agSentEmails", this);
        Cortana.put(scriptInstance, "&agIndicators", this);
        Cortana.put(scriptInstance, "&agInputs", this);
        Cortana.put(scriptInstance, "&agInputsForSession", this);
        Cortana.put(scriptInstance, "&agTasks", this);
        Cortana.put(scriptInstance, "&agWebHits", this);
        Cortana.put(scriptInstance, "&agWebHitsWithTokens", this);
        Cortana.put(scriptInstance, "&agSessionsById", this);
        Cortana.put(scriptInstance, "&agC2Domains", this);
        Cortana.put(scriptInstance, "&agC2ForSample", this);
        Cortana.put(scriptInstance, "&agPEForSample", this);
        Cortana.put(scriptInstance, "&agPENotesForSample", this);
        Cortana.put(scriptInstance, "&agCommunicationPathForSession", this);
        Cortana.put(scriptInstance, "&agC2Samples", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public Scalar extractValue(Map map2, String string) {
        List list = (List)map2.get(string);
        return CommonUtils.convertAll(list);
    }

    public static List filterList(List list, String string, String string2) {
        LinkedList<Map> linkedList = new LinkedList<Map>();
        for (Map map2 : list) {
            String string3;
            if (!map2.containsKey(string) || !string2.equals(string3 = map2.get(string).toString())) continue;
            linkedList.add(map2);
        }
        return linkedList;
    }

    public static List filterListBySetMember(List list, String string, String string2) {
        LinkedList<Map> linkedList = new LinkedList<Map>();
        for (Map map2 : list) {
            Set set;
            if (!map2.containsKey(string) || !(set = CommonUtils.toSet(map2.get(string).toString())).contains(string2)) continue;
            linkedList.add(map2);
        }
        return linkedList;
    }

    public static List filterList(List list, String string, Set set) {
        LinkedList<Map> linkedList = new LinkedList<Map>();
        for (Map map2 : list) {
            String string2;
            if (!map2.containsKey(string) || !set.contains(string2 = map2.get(string).toString())) continue;
            linkedList.add(map2);
        }
        return linkedList;
    }

    public static List filterListNot(List list, String string, String string2) {
        LinkedList<Map> linkedList = new LinkedList<Map>();
        for (Map map2 : list) {
            String string3;
            if (!map2.containsKey(string) || string2.equals(string3 = map2.get(string).toString())) continue;
            linkedList.add(map2);
        }
        return linkedList;
    }

    public static List getValuesWithout(List list, String string) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HashMap hashMap = new HashMap((Map)iterator.next());
            hashMap.remove(string);
            linkedHashSet.add(hashMap);
        }
        return new LinkedList(linkedHashSet);
    }

    public static List getValue(List list, String string) {
        LinkedList linkedList = new LinkedList();
        for (Map map2 : list) {
            linkedList.add(map2.get(string));
        }
        return linkedList;
    }

    public static List join(List list, List list2, String string) {
        return AggregateBridge.join(list, list2, string, string);
    }

    public static List join(List list, List list2, String string, String string2) {
        LinkedList linkedList = new LinkedList();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Object object : list) {
            Object object2 = object.get(string) + "";
            hashMap.put(object2, object);
        }
        for (Object object2 : list2) {
            String string3 = object2.get(string2) + "";
            HashMap hashMap2 = new HashMap();
            hashMap2.putAll(object2);
            if (hashMap.containsKey(string3)) {
                hashMap2.putAll((Map)hashMap.get(string3));
            }
            linkedList.add(hashMap2);
        }
        return linkedList;
    }

    public static Map toMap(List list, String string) {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        for (Map map2 : list) {
            String string2 = (String)map2.get(string);
            hashMap.put(string2, map2);
        }
        return hashMap;
    }

    @Override
    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if ("&aggregate".equals(string)) {
            return SleepUtils.getScalar(DataAggregate.AllModels(this.client));
        }
        if ("&agArchives".equals(string)) {
            Map map2 = (Map)BridgeUtilities.getObject(stack);
            return CommonUtils.convertAll((List)map2.get("archives"));
        }
        if ("&agArchivesByTactic".equals(string)) {
            Map map3 = (Map)BridgeUtilities.getObject(stack);
            String string2 = BridgeUtilities.getString(stack, "");
            List list = AggregateBridge.filterListBySetMember((List)map3.get("archives"), "tactic", string2);
            return CommonUtils.convertAll(list);
        }
        if ("&agTacticsUsed".equals(string)) {
            Map map4 = (Map)BridgeUtilities.getObject(stack);
            HashSet<String> hashSet = new HashSet<String>();
            List list = AggregateBridge.getValue((List)map4.get("archives"), "tactic");
            for (String string3 : list) {
                if (string3 == null || "".equals(string3)) continue;
                Set set = CommonUtils.toSet(string3);
                for (String string4 : set) {
                    if (!string4.startsWith("T")) continue;
                    hashSet.add(string4);
                }
            }
            return CommonUtils.convertAll(hashSet);
        }
        if ("&agConvert".equals(string)) {
            Object object = BridgeUtilities.getObject(stack);
            return CommonUtils.convertAll(object);
        }
        if ("&agTokenToEmail".equals(string)) {
            Map map5 = (Map)BridgeUtilities.getObject(stack);
            String string5 = BridgeUtilities.getString(stack, "");
            List list = (List)map5.get("tokens");
            for (Map map6 : list) {
                if (!string5.equals(map6.get("token"))) continue;
                return SleepUtils.getScalar((String)map6.get("email"));
            }
            return SleepUtils.getEmptyScalar();
        }
        if ("&agCampaigns".equals(string)) {
            String string6;
            Object object;
            Object object22;
            Map map7 = (Map)BridgeUtilities.getObject(stack);
            List list = (List)map7.get("archives");
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            HashMap hashMap2 = new HashMap();
            for (Object object22 : list) {
                if ("sendmail_start".equals(object22.get("type"))) {
                    object = object22.get("cid").toString();
                    hashMap.put(object, object22);
                    continue;
                }
                if (!"sendmail_post".equals(object22.get("type"))) continue;
                object = DialogUtils.string((Map)object22, "cid");
                string6 = DialogUtils.string((Map)object22, "status");
                if (!"SUCCESS".equals(string6)) continue;
                CommonUtils.increment(hashMap2, (String)object);
            }
            object22 = hashMap.entrySet().iterator();
            while (object22.hasNext()) {
                object = (Map.Entry)object22.next();
                string6 = (String)object.getKey();
                if (CommonUtils.count(hashMap2, string6) != 0) continue;
                object22.remove();
            }
            return CommonUtils.convertAll(hashMap);
        }
        if ("&agC2Samples".equals(string)) {
            Map map8 = (Map)BridgeUtilities.getObject(stack);
            List list = (List)map8.get("c2samples");
            return CommonUtils.convertAll(list);
        }
        if ("&agC2Domains".equals(string)) {
            Object object3;
            Map map9 = (Map)BridgeUtilities.getObject(stack);
            List list = AggregateBridge.getValue((List)map9.get("c2info"), "domains");
            HashSet hashSet = new HashSet();
            for (Object object3 : list) {
                hashSet.addAll(CommonUtils.toSet((String)object3));
            }
            object3 = new LinkedList(hashSet);
            Collections.sort(object3);
            return CommonUtils.convertAll(object3);
        }
        if ("&agPEForSample".equals(string)) {
            Map map10 = SleepUtils.getMapFromHash((ScalarHash)BridgeUtilities.getObject(stack));
            Map map11 = (Map)map10.get("pe");
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("Checksum", map11.get("Checksum") + "");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
            Date date = (Date)map11.get("Compilation Timestamp");
            linkedHashMap.put("Compilation Timestamp", simpleDateFormat.format(date));
            linkedHashMap.put("Entry Point", map11.get("Entry Point") + "");
            if (map11.containsKey("Name")) {
                linkedHashMap.put("Name", (String)map11.get("Name"));
            }
            long l = CommonUtils.toLongNumber(map11.get("Size") + "", 0L);
            String string7 = CommonUtils.formatSize(l) + " (" + l + " bytes)";
            linkedHashMap.put("Size", string7);
            linkedHashMap.put("Target Machine", (String)map11.get("Target Machine"));
            Scalar scalar = SleepUtils.getOrderedHashScalar();
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                Scalar scalar2 = SleepUtils.getScalar((String)entry.getKey());
                Scalar scalar3 = scalar.getHash().getAt(scalar2);
                scalar3.setValue(SleepUtils.getScalar(entry.getValue() + ""));
            }
            return scalar;
        }
        if ("&agPENotesForSample".equals(string)) {
            Map map12 = SleepUtils.getMapFromHash((ScalarHash)BridgeUtilities.getObject(stack));
            Map map13 = (Map)map12.get("pe");
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            if (map13.containsKey("Notes")) {
                return SleepUtils.getScalar((String)map13.get("Notes"));
            }
            return SleepUtils.getEmptyScalar();
        }
        if ("&agC2ForSample".equals(string)) {
            Map map14 = SleepUtils.getMapFromHash((ScalarHash)BridgeUtilities.getObject(stack));
            List list = AggregateBridge.getValuesWithout((List)map14.get("callbacks"), "bid");
            LinkedList linkedList = new LinkedList();
            for (Map map15 : list) {
                Set set = CommonUtils.toSet((String)map15.get("domains"));
                String string8 = DialogUtils.string(map15, "proto");
                for (String string9 : set) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("Host", string9);
                    hashMap.put("Port", (String)map15.get("port"));
                    hashMap.put("Protocols", string8);
                    linkedList.add(hashMap);
                }
            }
            return CommonUtils.convertAll(linkedList);
        }
        if ("&agCommunicationPathForSession".equals(string)) {
            Map map16 = (Map)BridgeUtilities.getObject(stack);
            String string10 = BridgeUtilities.getString(stack, "");
            Map map17 = AggregateBridge.toMap((List)map16.get("sessions"), "id");
            Map map18 = AggregateBridge.toMap((List)map16.get("c2info"), "bid");
            LinkedList<Map<String, String>> linkedList = new LinkedList<Map<String, String>>();
            Map map19 = (Map)map17.get(string10);
            while (map19 != null) {
                Object object;
                Map<String, String> map20;
                if (!"".equals(map19.get("pbid"))) {
                    map20 = new HashMap();
                    if ("beacon".equals(map19.get("session"))) {
                        object = new PivotHint(map19.get("phint") + "");
                        map20.put("protocol", ((PivotHint)object).getProtocol());
                        map20.put("port", (String)((Object)Integer.valueOf(((PivotHint)object).getPort())));
                    } else {
                        map20.put("protocol", "SSH");
                        map20.put("port", (String)map19.get("port"));
                    }
                    if ((map19 = (Map)map17.get(string10 = (String)map19.get("pbid"))) == null) continue;
                    map19.remove("port");
                    map19.remove("protocol");
                    map20.put("hosts", (String)map19.get("computer"));
                    map20.putAll(map19);
                    linkedList.add(map20);
                    continue;
                }
                map19 = null;
                map20 = (Map)map18.get(string10);
                if (map20 == null) continue;
                object = DialogUtils.string(map20, "domains");
                int n = DialogUtils.number(map20, "port");
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("protocol", DialogUtils.string(map20, "proto"));
                hashMap.put("port", n);
                hashMap.put("hosts", object);
                linkedList.add(hashMap);
            }
            CommonUtils.print_info("\t" + linkedList);
            return CommonUtils.convertAll(linkedList);
        }
        if ("&agSessionsById".equals(string)) {
            Map map21 = (Map)BridgeUtilities.getObject(stack);
            List list = (List)map21.get("sessions");
            Map map22 = AggregateBridge.toMap((List)map21.get("sessions"), "id");
            return CommonUtils.convertAll(map22);
        }
        if ("&agEmailAddresses".equals(string)) {
            Map map23 = (Map)BridgeUtilities.getObject(stack);
            LinkedList linkedList = new LinkedList(new HashSet(AggregateBridge.getValue((List)map23.get("tokens"), "email")));
            return CommonUtils.convertAll(linkedList);
        }
        if ("&agServicesForHost".equals(string)) {
            Map map24 = (Map)BridgeUtilities.getObject(stack);
            String string11 = BridgeUtilities.getString(stack, "");
            List list = AggregateBridge.filterList((List)map24.get("services"), "address", string11);
            return CommonUtils.convertAll(list);
        }
        if ("&agServices".equals(string)) {
            Map map25 = (Map)BridgeUtilities.getObject(stack);
            LinkedList linkedList = new LinkedList((List)map25.get("services"));
            HashSet hashSet = new HashSet(AggregateBridge.getValue((List)map25.get("targets"), "address"));
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Map map26 = (Map)iterator.next();
                String string12 = (String)map26.get("address");
                if (hashSet.contains(string12)) continue;
                iterator.remove();
            }
            return CommonUtils.convertAll(linkedList);
        }
        if ("&agSessionsForHost".equals(string)) {
            Map map27 = (Map)BridgeUtilities.getObject(stack);
            String string13 = BridgeUtilities.getString(stack, "");
            List list = AggregateBridge.filterList((List)map27.get("sessions"), "internal", string13);
            return CommonUtils.convertAll(list);
        }
        if ("&agCredentialsForHost".equals(string)) {
            Map map28 = (Map)BridgeUtilities.getObject(stack);
            String string14 = BridgeUtilities.getString(stack, "");
            List list = AggregateBridge.filterList((List)map28.get("credentials"), "host", string14);
            return CommonUtils.convertAll(list);
        }
        if ("&agWebHitsForToken".equals(string)) {
            Map map29 = (Map)BridgeUtilities.getObject(stack);
            String string15 = BridgeUtilities.getString(stack, "");
            List list = AggregateBridge.filterList((List)map29.get("archives"), "type", "webhit");
            List list2 = AggregateBridge.filterList(list, "token", string15);
            return CommonUtils.convertAll(list2);
        }
        if ("&agSentEmailsForCampaign".equals(string)) {
            Map map30 = (Map)BridgeUtilities.getObject(stack);
            String string16 = BridgeUtilities.getString(stack, "");
            List list = AggregateBridge.filterList((List)map30.get("archives"), "type", "sendmail_post");
            List list3 = AggregateBridge.filterList(list, "cid", string16);
            List list4 = (List)map30.get("tokens");
            return CommonUtils.convertAll(AggregateBridge.join(list4, list3, "token"));
        }
        if ("&agSentEmailsForEmailAddress".equals(string)) {
            Map map31 = (Map)BridgeUtilities.getObject(stack);
            String string17 = BridgeUtilities.getString(stack, "");
            List list = AggregateBridge.filterList((List)map31.get("archives"), "type", "sendmail_post");
            List list5 = AggregateBridge.join((List)map31.get("tokens"), list, "token");
            List list6 = AggregateBridge.filterList(list5, "email", string17);
            return CommonUtils.convertAll(list6);
        }
        if ("&agApplicationsForEmailAddress".equals(string)) {
            Map map32 = (Map)BridgeUtilities.getObject(stack);
            String string18 = BridgeUtilities.getString(stack, "");
            List list = (List)map32.get("applications");
            List list7 = AggregateBridge.join((List)map32.get("tokens"), list, "token", "id");
            List list8 = AggregateBridge.filterList(list7, "email", string18);
            return CommonUtils.convertAll(list8);
        }
        if ("&agCountWebHitsByToken".equals(string)) {
            Map map33 = (Map)BridgeUtilities.getObject(stack);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            List list = AggregateBridge.filterList((List)map33.get("archives"), "type", "webhit");
            List list9 = AggregateBridge.getValue((List)map33.get("tokens"), "token");
            for (String string19 : list9) {
                int n = AggregateBridge.filterList(list, "token", string19).size();
                if (n <= 0) continue;
                hashMap.put(string19, n);
            }
            return CommonUtils.convertAll(hashMap);
        }
        if ("&agWebHitsForEmail".equals(string)) {
            Map map34 = (Map)BridgeUtilities.getObject(stack);
            String string20 = BridgeUtilities.getString(stack, "");
            LinkedList linkedList = new LinkedList();
            List list = AggregateBridge.filterList((List)map34.get("archives"), "type", "webhit");
            List list10 = AggregateBridge.getValue(AggregateBridge.filterList((List)map34.get("tokens"), "email", string20), "token");
            for (String string21 : list10) {
                linkedList.addAll(AggregateBridge.filterList(list, "token", string21));
            }
            return CommonUtils.convertAll(linkedList);
        }
        if ("&agSentEmails".equals(string)) {
            Map map35 = (Map)BridgeUtilities.getObject(stack);
            List list = AggregateBridge.filterList((List)map35.get("archives"), "type", "sendmail_post");
            return CommonUtils.convertAll(list);
        }
        if ("&agIndicators".equals(string)) {
            Map map36 = (Map)BridgeUtilities.getObject(stack);
            List list = AggregateBridge.filterList((List)map36.get("archives"), "type", "indicator");
            return CommonUtils.convertAll(list);
        }
        if ("&agFileIndicators".equals(string)) {
            Map map37 = (Map)BridgeUtilities.getObject(stack);
            String string22 = BridgeUtilities.getString(stack, "");
            List list = AggregateBridge.filterList((List)map37.get("archives"), "type", "indicator");
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Map map38 = (Map)iterator.next();
                String string23 = (String)map38.get("data");
                RegexParser regexParser = new RegexParser(string23);
                if (regexParser.matches("file: (.*?) (.*?) bytes (.*)")) {
                    String string24 = regexParser.group(1);
                    String string25 = regexParser.group(2);
                    String string26 = regexParser.group(3);
                    if (hashSet.contains(string24)) {
                        iterator.remove();
                        continue;
                    }
                    map38.put("hash", string24);
                    map38.put("name", string26);
                    map38.put("size", string25);
                    hashSet.add(string24);
                    continue;
                }
                iterator.remove();
            }
            return CommonUtils.convertAll(list);
        }
        if ("&agFileIndicatorsForSession".equals(string)) {
            Map map39 = (Map)BridgeUtilities.getObject(stack);
            String string27 = BridgeUtilities.getString(stack, "");
            List list = AggregateBridge.filterList((List)map39.get("archives"), "type", "indicator");
            List list11 = AggregateBridge.filterList(list, "bid", string27);
            LinkedList linkedList = new LinkedList();
            Iterator iterator = list11.iterator();
            while (iterator.hasNext()) {
                HashMap<String, String> hashMap = new HashMap<String, String>((Map)iterator.next());
                String string28 = (String)hashMap.get("data");
                RegexParser regexParser = new RegexParser(string28);
                if (!regexParser.matches("file: (.*?) (.*?) bytes (.*)")) continue;
                String string29 = regexParser.group(1);
                String string30 = regexParser.group(2);
                String string31 = regexParser.group(3);
                hashMap.put("hash", string29);
                hashMap.put("name", string31);
                hashMap.put("size", string30);
                linkedList.add(hashMap);
            }
            return CommonUtils.convertAll(linkedList);
        }
        if ("&agOtherIndicatorsForSession".equals(string)) {
            Map map40 = (Map)BridgeUtilities.getObject(stack);
            String string32 = BridgeUtilities.getString(stack, "");
            List list = AggregateBridge.filterList((List)map40.get("archives"), "type", "indicator");
            List list12 = AggregateBridge.filterList(list, "bid", string32);
            LinkedList linkedList = new LinkedList();
            Iterator iterator = list12.iterator();
            while (iterator.hasNext()) {
                HashMap<String, String> hashMap = new HashMap<String, String>((Map)iterator.next());
                String string33 = (String)hashMap.get("data");
                RegexParser regexParser = new RegexParser(string33);
                if (!regexParser.matches("service: (.*?) (.*)")) continue;
                String string34 = regexParser.group(1);
                String string35 = regexParser.group(2);
                hashMap.put("target", string34);
                hashMap.put("name", string35);
                hashMap.put("type", "service");
                linkedList.add(hashMap);
            }
            return CommonUtils.convertAll(linkedList);
        }
        if ("&agTasksAndCheckinsForSession".equals(string)) {
            Map map41 = (Map)BridgeUtilities.getObject(stack);
            String string36 = BridgeUtilities.getString(stack, "");
            Set set = CommonUtils.toSet("task, checkin, output");
            List list = AggregateBridge.filterList((List)map41.get("archives"), "type", set);
            List list13 = AggregateBridge.filterList(list, "bid", string36);
            return CommonUtils.convertAll(list13);
        }
        if ("&agInputs".equals(string)) {
            Map map42 = (Map)BridgeUtilities.getObject(stack);
            List list = AggregateBridge.filterList((List)map42.get("archives"), "type", "input");
            return CommonUtils.convertAll(list);
        }
        if ("&agInputsForSession".equals(string)) {
            Map map43 = (Map)BridgeUtilities.getObject(stack);
            String string37 = BridgeUtilities.getString(stack, "");
            List list = AggregateBridge.filterList((List)map43.get("archives"), "type", "input");
            List list14 = AggregateBridge.filterList(list, "bid", string37);
            return CommonUtils.convertAll(list14);
        }
        if ("&agTasks".equals(string)) {
            Map map44 = (Map)BridgeUtilities.getObject(stack);
            List list = AggregateBridge.filterList((List)map44.get("archives"), "type", "task");
            return CommonUtils.convertAll(list);
        }
        if ("&agWebHits".equals(string)) {
            Map map45 = (Map)BridgeUtilities.getObject(stack);
            List list = AggregateBridge.filterList((List)map45.get("archives"), "type", "webhit");
            return CommonUtils.convertAll(list);
        }
        if ("&agWebHitsWithTokens".equals(string)) {
            Map map46 = (Map)BridgeUtilities.getObject(stack);
            List list = AggregateBridge.filterList((List)map46.get("archives"), "type", "webhit");
            list = AggregateBridge.filterListNot(list, "token", "");
            return CommonUtils.convertAll(list);
        }
        return SleepUtils.getEmptyScalar();
    }
}

