/*
 * Decompiled with CFR 0.152.
 */
package aggressor.bridges;

import common.CommonUtils;
import cortana.Cortana;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class AttackBridge
implements Function,
Loadable {
    protected List ids = new LinkedList();
    protected Map data = new HashMap();

    @Override
    public void scriptLoaded(ScriptInstance scriptInstance) {
        Cortana.put(scriptInstance, "&attack_tactics", this);
        Cortana.put(scriptInstance, "&attack_name", this);
        Cortana.put(scriptInstance, "&attack_describe", this);
        Cortana.put(scriptInstance, "&attack_mitigate", this);
        Cortana.put(scriptInstance, "&attack_detect", this);
        Cortana.put(scriptInstance, "&attack_url", this);
    }

    public void loadAttackMatrix() {
        if (this.ids.size() > 0) {
            return;
        }
        List list = SleepUtils.getListFromArray((Scalar)CommonUtils.readObjectResource("resources/attack.bin"));
        for (Map map2 : list) {
            String string = (String)map2.get("id");
            this.ids.add(string);
            this.data.put(string, map2);
        }
    }

    @Override
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    @Override
    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        this.loadAttackMatrix();
        if ("&attack_tactics".equals(string)) {
            return SleepUtils.getArrayWrapper(this.ids);
        }
        String string2 = BridgeUtilities.getString(stack, "");
        Map map2 = (Map)this.data.get(string2);
        if (map2 == null) {
            throw new RuntimeException("ATT&CK Technique '" + string2 + "' was not found.");
        }
        if ("&attack_name".equals(string)) {
            return SleepUtils.getScalar((String)map2.get("name"));
        }
        if ("&attack_describe".equals(string)) {
            return SleepUtils.getScalar((String)map2.get("describe"));
        }
        if ("&attack_mitigate".equals(string)) {
            return SleepUtils.getScalar((String)map2.get("mitigate"));
        }
        if ("&attack_detect".equals(string)) {
            return SleepUtils.getScalar((String)map2.get("detect"));
        }
        if ("&attack_url".equals(string)) {
            return SleepUtils.getScalar("https://attack.mitre.org/wiki/Technique/" + string2);
        }
        return SleepUtils.getEmptyScalar();
    }
}

