/*
 * Decompiled with CFR 0.152.
 */
package aggressor.bridges;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import aggressor.dialogs.ElevateDialog;
import aggressor.dialogs.OneLinerDialog;
import aggressor.dialogs.SleepDialog;
import beacon.BeaconCommands;
import beacon.EncodedCommandBuilder;
import beacon.PowerShellTasks;
import beacon.TaskBeacon;
import beacon.bof.UserSpecifiedFull;
import common.BeaconEntry;
import common.BeaconOutput;
import common.BridgeUtilities2;
import common.Callback;
import common.CommonUtils;
import common.ListenerUtils;
import common.Packer;
import common.ScListener;
import common.TeamQueue;
import cortana.Cortana;
import dialog.DialogUtils;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class BeaconBridge
implements Function,
Loadable,
Predicate {
    protected Cortana engine;
    protected TeamQueue conn;
    protected AggressorClient client;

    public BeaconBridge(AggressorClient aggressorClient, Cortana cortana, TeamQueue teamQueue) {
        this.client = aggressorClient;
        this.engine = cortana;
        this.conn = teamQueue;
    }

    @Override
    public void scriptLoaded(ScriptInstance scriptInstance) {
        Cortana.put(scriptInstance, "&externalc2_start", this);
        Cortana.put(scriptInstance, "&beacon_commands", this);
        Cortana.put(scriptInstance, "&ssh_commands", this);
        Cortana.put(scriptInstance, "&beacon_command_describe", this);
        Cortana.put(scriptInstance, "&ssh_command_describe", this);
        Cortana.put(scriptInstance, "&beacon_command_detail", this);
        Cortana.put(scriptInstance, "&ssh_command_detail", this);
        Cortana.put(scriptInstance, "&beacons", this);
        Cortana.put(scriptInstance, "&beacon_data", this);
        Cortana.put(scriptInstance, "&bdata", this);
        Cortana.put(scriptInstance, "&beacon_info", this);
        Cortana.put(scriptInstance, "&binfo", this);
        Cortana.put(scriptInstance, "&beacon_note", this);
        Cortana.put(scriptInstance, "&beacon_remove", this);
        Cortana.put(scriptInstance, "&beacon_command_register", this);
        Cortana.put(scriptInstance, "&ssh_command_register", this);
        Cortana.put(scriptInstance, "&beacon_ids", this);
        Cortana.put(scriptInstance, "&beacon_host_script", this);
        Cortana.put(scriptInstance, "&beacon_host_imported_script", this);
        Cortana.put(scriptInstance, "&beacon_execute_job", this);
        Cortana.put(scriptInstance, "&barch", this);
        Cortana.put(scriptInstance, "&beacon_stage_tcp", this);
        Cortana.put(scriptInstance, "&beacon_stage_pipe", this);
        Cortana.put(scriptInstance, "&bof_pack", this);
        Cortana.put(scriptInstance, "&beacon_inline_execute", this);
        Cortana.put(scriptInstance, "&bls", this);
        Cortana.put(scriptInstance, "&bps", this);
        Cortana.put(scriptInstance, "&bipconfig", this);
        Cortana.put(scriptInstance, "&openOrActivate", this);
        Cortana.put(scriptInstance, "&openBypassUACDialog", this);
        Cortana.put(scriptInstance, "&openElevateDialog", this);
        Cortana.put(scriptInstance, "&openOneLinerDialog", this);
        Cortana.put(scriptInstance, "&openSleepDialog", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("-isssh", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("-isbeacon", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("-isadmin", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("-is64", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("-isactive", this);
    }

    @Override
    public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
        String string2 = BridgeUtilities.getString(stack, "");
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), string2);
        if (beaconEntry == null) {
            return false;
        }
        if ("-isssh".equals(string)) {
            return beaconEntry.isSSH();
        }
        if ("-isbeacon".equals(string)) {
            return beaconEntry.isBeacon();
        }
        if ("-isadmin".equals(string)) {
            return beaconEntry.isAdmin();
        }
        if ("-is64".equals(string)) {
            return beaconEntry.is64();
        }
        if ("-isactive".equals(string)) {
            return beaconEntry.isActive();
        }
        return false;
    }

    @Override
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public static String[] bids(Stack stack) {
        if (stack.isEmpty()) {
            return new String[0];
        }
        Scalar scalar = (Scalar)stack.peek();
        if (scalar.getArray() != null) {
            return CommonUtils.toStringArray(BridgeUtilities.getArray(stack));
        }
        return new String[]{((Scalar)stack.pop()).stringValue()};
    }

    @Override
    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&externalc2_start")) {
            String string2 = BridgeUtilities.getString(stack, "0.0.0.0");
            int n = BridgeUtilities.getInt(stack, 2222);
            this.conn.call("exoticc2.start", CommonUtils.args(string2, n));
            return SleepUtils.getEmptyScalar();
        }
        if (string.equals("&beacon_commands")) {
            BeaconCommands beaconCommands = DataUtils.getBeaconCommands(this.client.getData());
            return SleepUtils.getArrayWrapper(beaconCommands.commands());
        }
        if (string.equals("&ssh_commands")) {
            BeaconCommands beaconCommands = DataUtils.getSSHCommands(this.client.getData());
            return SleepUtils.getArrayWrapper(beaconCommands.commands());
        }
        if (string.equals("&beacon_command_describe")) {
            String string3 = BridgeUtilities.getString(stack, "");
            BeaconCommands beaconCommands = DataUtils.getBeaconCommands(this.client.getData());
            return SleepUtils.getScalar(beaconCommands.getDescription(string3));
        }
        if (string.equals("&ssh_command_describe")) {
            String string4 = BridgeUtilities.getString(stack, "");
            BeaconCommands beaconCommands = DataUtils.getSSHCommands(this.client.getData());
            return SleepUtils.getScalar(beaconCommands.getDescription(string4));
        }
        if (string.equals("&beacon_command_detail")) {
            String string5 = BridgeUtilities.getString(stack, "");
            BeaconCommands beaconCommands = DataUtils.getBeaconCommands(this.client.getData());
            return SleepUtils.getScalar(beaconCommands.getDetails(string5));
        }
        if (string.equals("&ssh_command_detail")) {
            String string6 = BridgeUtilities.getString(stack, "");
            BeaconCommands beaconCommands = DataUtils.getSSHCommands(this.client.getData());
            return SleepUtils.getScalar(beaconCommands.getDetails(string6));
        }
        if (string.equals("&beacon_command_register")) {
            String string7 = BridgeUtilities.getString(stack, "");
            String string8 = BridgeUtilities.getString(stack, "");
            String string9 = BridgeUtilities.getString(stack, "");
            BeaconCommands beaconCommands = DataUtils.getBeaconCommands(this.client.getData());
            beaconCommands.register(string7, string8, string9);
        } else if (string.equals("&ssh_command_register")) {
            String string10 = BridgeUtilities.getString(stack, "");
            String string11 = BridgeUtilities.getString(stack, "");
            String string12 = BridgeUtilities.getString(stack, "");
            BeaconCommands beaconCommands = DataUtils.getSSHCommands(this.client.getData());
            beaconCommands.register(string10, string11, string12);
        } else if (string.equals("&beacon_note")) {
            String[] stringArray = BeaconBridge.bids(stack);
            String string13 = BridgeUtilities.getString(stack, "");
            for (int i = 0; i < stringArray.length; ++i) {
                this.conn.call("beacons.note", CommonUtils.args(stringArray[i], string13));
                this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Note(stringArray[i], string13)));
            }
        } else if (string.equals("&beacon_remove")) {
            String[] stringArray = BeaconBridge.bids(stack);
            for (int i = 0; i < stringArray.length; ++i) {
                this.conn.call("beacons.remove", CommonUtils.args(stringArray[i]));
            }
        } else {
            if (string.equals("&beacons")) {
                Map map2 = DataUtils.getBeacons(this.client.getData());
                return CommonUtils.convertAll(new LinkedList(map2.values()));
            }
            if (string.equals("&beacon_ids")) {
                Map map3 = DataUtils.getBeacons(this.client.getData());
                return CommonUtils.convertAll(new LinkedList(map3.keySet()));
            }
            if (string.equals("&beacon_execute_job")) {
                String[] stringArray = BeaconBridge.bids(stack);
                String string14 = BridgeUtilities.getString(stack, "");
                String string15 = BridgeUtilities.getString(stack, "");
                int n = BridgeUtilities.getInt(stack, 0);
                for (int i = 0; i < stringArray.length; ++i) {
                    EncodedCommandBuilder encodedCommandBuilder = new EncodedCommandBuilder(this.client);
                    encodedCommandBuilder.setCommand(78);
                    encodedCommandBuilder.addLengthAndEncodedString(stringArray[i], string14);
                    encodedCommandBuilder.addLengthAndEncodedString(stringArray[i], string15);
                    encodedCommandBuilder.addShort(n);
                    byte[] byArray = encodedCommandBuilder.build();
                    this.conn.call("beacons.task", CommonUtils.args(stringArray[i], byArray));
                }
            } else {
                if (string.equals("&beacon_host_imported_script")) {
                    String string16 = BridgeUtilities.getString(stack, "");
                    return SleepUtils.getScalar(new PowerShellTasks(this.client, string16).getImportCradle());
                }
                if (string.equals("&beacon_host_script")) {
                    String string17 = BridgeUtilities.getString(stack, "");
                    String string18 = BridgeUtilities.getString(stack, "");
                    return SleepUtils.getScalar(new PowerShellTasks(this.client, string17).getScriptCradle(string18));
                }
                if (string.equals("&barch")) {
                    String string19 = BridgeUtilities.getString(stack, "");
                    BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), string19);
                    if (beaconEntry == null) {
                        return SleepUtils.getScalar("x86");
                    }
                    return SleepUtils.getScalar(beaconEntry.arch());
                }
                if (string.equals("&beacon_info") || string.equals("&binfo")) {
                    String string20 = BridgeUtilities.getString(stack, "");
                    BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), string20);
                    if (beaconEntry == null) {
                        return SleepUtils.getEmptyScalar();
                    }
                    if (!stack.isEmpty()) {
                        String string21 = BridgeUtilities.getString(stack, "");
                        return CommonUtils.convertAll(beaconEntry.toMap().get(string21));
                    }
                    return CommonUtils.convertAll(beaconEntry.toMap());
                }
                if (string.equals("&beacon_data") || string.equals("&bdata")) {
                    String string22 = BridgeUtilities.getString(stack, "");
                    String string23 = BridgeUtilities.getString(stack, "");
                    BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), string22);
                    if (beaconEntry == null) {
                        return SleepUtils.getEmptyScalar();
                    }
                    return CommonUtils.convertAll(beaconEntry.toMap());
                }
                if (string.equals("&bipconfig")) {
                    String[] stringArray = BeaconBridge.bids(stack);
                    final SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
                    for (int i = 0; i < stringArray.length; ++i) {
                        final String string24 = stringArray[i];
                        this.conn.call("beacons.task_ipconfig", CommonUtils.args(stringArray[i]), new Callback(){

                            @Override
                            public void result(String string, Object object) {
                                Stack<Scalar> stack = new Stack<Scalar>();
                                stack.push(CommonUtils.convertAll(object));
                                stack.push(SleepUtils.getScalar(string24));
                                SleepUtils.runCode(sleepClosure, string, null, stack);
                            }
                        });
                    }
                } else if (string.equals("&bls")) {
                    String[] stringArray = BeaconBridge.bids(stack);
                    final String string25 = BridgeUtilities.getString(stack, ".");
                    if (!stack.isEmpty()) {
                        final SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
                        for (int i = 0; i < stringArray.length; ++i) {
                            final String string26 = stringArray[i];
                            this.conn.call("beacons.task_ls", CommonUtils.args(stringArray[i], string25), new Callback(){

                                @Override
                                public void result(String string, Object object) {
                                    Stack<Scalar> stack = new Stack<Scalar>();
                                    stack.push(CommonUtils.convertAll(object));
                                    stack.push(SleepUtils.getScalar(string25));
                                    stack.push(SleepUtils.getScalar(string26));
                                    SleepUtils.runCode(sleepClosure, string, null, stack);
                                }
                            });
                        }
                    } else {
                        TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.conn, stringArray);
                        taskBeacon.Ls(string25);
                    }
                } else if (string.equals("&bps")) {
                    String[] stringArray = BeaconBridge.bids(stack);
                    if (stack.isEmpty()) {
                        TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.conn, stringArray);
                        taskBeacon.Ps();
                    } else {
                        final SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
                        for (int i = 0; i < stringArray.length; ++i) {
                            final String string27 = stringArray[i];
                            this.conn.call("beacons.task_ps", CommonUtils.args(stringArray[i]), new Callback(){

                                @Override
                                public void result(String string, Object object) {
                                    Stack<Scalar> stack = new Stack<Scalar>();
                                    stack.push(CommonUtils.convertAll(object));
                                    stack.push(SleepUtils.getScalar(string27));
                                    SleepUtils.runCode(sleepClosure, string, null, stack);
                                }
                            });
                        }
                    }
                } else if (string.equals("&beacon_stage_tcp")) {
                    String string28 = BridgeUtilities.getString(stack, "");
                    String string29 = BridgeUtilities.getString(stack, "127.0.0.1");
                    int n = BridgeUtilities.getInt(stack, 0);
                    String string30 = BridgeUtilities.getString(stack, "");
                    String string31 = BridgeUtilities.getString(stack, "x86");
                    ScListener scListener = ListenerUtils.getListener(this.client, string30);
                    TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.conn, new String[]{string28});
                    taskBeacon.StageTCP(string28, string29, n, string31, scListener);
                } else if (string.equals("&beacon_stage_pipe")) {
                    String string32 = BridgeUtilities.getString(stack, "");
                    String string33 = BridgeUtilities.getString(stack, "127.0.0.1");
                    String string34 = BridgeUtilities.getString(stack, "");
                    String string35 = BridgeUtilities.getString(stack, "x86");
                    ScListener scListener = ListenerUtils.getListener(this.client, string34);
                    String string36 = scListener.getConfig().getStagerPipe();
                    TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.conn, new String[]{string32});
                    taskBeacon.StagePipe(string32, string33, string36, string35, scListener);
                } else if (string.equals("&openOrActivate")) {
                    String[] stringArray = BeaconBridge.bids(stack);
                    if (stringArray.length == 1) {
                        DialogUtils.openOrActivate(this.client, stringArray[0]);
                    }
                } else {
                    if (string.equals("&openBypassUACDialog")) {
                        throw new RuntimeException(string + " was removed in Cobalt Strike 4.1");
                    }
                    if (string.equals("&openElevateDialog")) {
                        String[] stringArray = BeaconBridge.bids(stack);
                        new ElevateDialog(this.client, stringArray).show();
                    } else if (string.equals("&openOneLinerDialog")) {
                        String[] stringArray = BeaconBridge.bids(stack);
                        new OneLinerDialog(this.client, stringArray).show();
                    } else if (string.equals("&openSleepDialog")) {
                        String[] stringArray = BeaconBridge.bids(stack);
                        new SleepDialog(this.client, stringArray).show();
                    } else {
                        if (string.equals("&bof_pack")) {
                            String string37 = BridgeUtilities.getString(stack, "");
                            String string38 = BridgeUtilities.getString(stack, "");
                            Packer packer = new Packer();
                            for (int i = 0; i < string38.length(); ++i) {
                                char c = string38.charAt(i);
                                if (c == ' ') continue;
                                if (stack.isEmpty()) {
                                    throw new RuntimeException("No argument corresponds to '" + c + "'");
                                }
                                if (c == 'b') {
                                    packer.addLengthAndString(BridgeUtilities.getString(stack, ""));
                                    continue;
                                }
                                if (c == 'i') {
                                    packer.addInt(BridgeUtilities.getInt(stack, 0));
                                    continue;
                                }
                                if (c == 's') {
                                    packer.addShort((short)BridgeUtilities.getInt(stack, 0));
                                    continue;
                                }
                                if (c == 'z') {
                                    packer.addLengthAndEncodedStringASCIIZ(this.client, string37, BridgeUtilities.getString(stack, ""));
                                    continue;
                                }
                                if (c == 'Z') {
                                    packer.addLengthAndWideStringASCIIZ(BridgeUtilities.getString(stack, ""));
                                    continue;
                                }
                                throw new RuntimeException("Invalid character in BOF: '" + c + "'");
                            }
                            return SleepUtils.getScalar(packer.getBytes());
                        }
                        if (string.equals("&beacon_inline_execute")) {
                            String string39 = BridgeUtilities.getString(stack, "");
                            byte[] byArray = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                            String string40 = BridgeUtilities.getString(stack, "");
                            byte[] byArray2 = CommonUtils.toBytes(BridgeUtilities.getString(stack, ""));
                            SleepClosure sleepClosure = BridgeUtilities2.getFunctionOrNull(stack, scriptInstance);
                            if (byArray.length == 0) {
                                throw new RuntimeException("The BOF content (arg 2) is empty. Did you read the right file?");
                            }
                            UserSpecifiedFull userSpecifiedFull = new UserSpecifiedFull(this.client, byArray, string40, byArray2);
                            userSpecifiedFull.setCallbackFunction(string39, sleepClosure);
                            userSpecifiedFull.go(string39);
                        }
                    }
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }
}

