/*
 * Decompiled with CFR 0.152.
 */
package aggressor.bridges;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import common.CommonUtils;
import common.DownloadFileSimple;
import common.DownloadNotify;
import common.LoggedEvent;
import common.ScriptUtils;
import common.TeamQueue;
import cortana.Cortana;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.engine.ObjectUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class DataBridge
implements Function,
Loadable {
    protected Cortana engine;
    protected TeamQueue conn;
    protected AggressorClient client;

    public DataBridge(AggressorClient aggressorClient, Cortana cortana, TeamQueue teamQueue) {
        this.client = aggressorClient;
        this.engine = cortana;
        this.conn = teamQueue;
    }

    public static Map getKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("&applications", "applications");
        hashMap.put("&archives", "archives");
        hashMap.put("&credentials", "credentials");
        hashMap.put("&downloads", "downloads");
        hashMap.put("&keystrokes", "keystrokes");
        hashMap.put("&pivots", "socks");
        hashMap.put("&screenshots", "screenshots");
        hashMap.put("&services", "services");
        hashMap.put("&sites", "sites");
        hashMap.put("&targets", "targets");
        return hashMap;
    }

    @Override
    public void scriptLoaded(ScriptInstance scriptInstance) {
        Cortana.put(scriptInstance, "&mynick", this);
        Cortana.put(scriptInstance, "&tstamp", this);
        Cortana.put(scriptInstance, "&dstamp", this);
        Cortana.put(scriptInstance, "&tokenToEmail", this);
        Cortana.put(scriptInstance, "&localip", this);
        Cortana.put(scriptInstance, "&sync_download", this);
        Cortana.put(scriptInstance, "&hosts", this);
        Cortana.put(scriptInstance, "&host_update", this);
        Cortana.put(scriptInstance, "&host_delete", this);
        Cortana.put(scriptInstance, "&host_info", this);
        Cortana.put(scriptInstance, "&credential_add", this);
        for (Map.Entry entry : DataBridge.getKeys().entrySet()) {
            Cortana.put(scriptInstance, (String)entry.getKey(), this);
        }
        Cortana.put(scriptInstance, "&data_query", this);
        Cortana.put(scriptInstance, "&data_keys", this);
        Cortana.put(scriptInstance, "&resetData", this);
    }

    public static String getStringOrNull(Stack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        Scalar scalar = (Scalar)stack.pop();
        if (SleepUtils.isEmptyScalar(scalar)) {
            return null;
        }
        return scalar.toString();
    }

    @Override
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    @Override
    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&mynick")) {
            return SleepUtils.getScalar(DataUtils.getNick(this.client.getData()));
        }
        if (string.equals("&localip")) {
            return SleepUtils.getScalar(DataUtils.getLocalIP(this.client.getData()));
        }
        if (string.equals("&dstamp")) {
            long l = BridgeUtilities.getLong(stack);
            return SleepUtils.getScalar(CommonUtils.formatDate(l));
        }
        if (string.equals("&tstamp")) {
            long l = BridgeUtilities.getLong(stack);
            return SleepUtils.getScalar(CommonUtils.formatTime(l));
        }
        if (string.equals("&tokenToEmail")) {
            String string2 = BridgeUtilities.getString(stack, "");
            return SleepUtils.getScalar(DataUtils.TokenToEmail(string2));
        }
        if (string.equals("&host_delete")) {
            String[] stringArray = ScriptUtils.ArrayOrString(stack);
            for (int i = 0; i < stringArray.length; ++i) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("address", stringArray[i]);
                String string3 = CommonUtils.TargetKey(hashMap);
                this.client.getConnection().call("targets.remove", CommonUtils.args(string3));
            }
            this.client.getConnection().call("targets.push");
        } else if (string.equals("&host_update")) {
            String[] stringArray = ScriptUtils.ArrayOrString(stack);
            String string4 = DataBridge.getStringOrNull(stack);
            String string5 = DataBridge.getStringOrNull(stack);
            double d = BridgeUtilities.getDouble(stack, 0.0);
            String string6 = DataBridge.getStringOrNull(stack);
            for (int i = 0; i < stringArray.length; ++i) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("address", CommonUtils.trim(stringArray[i]));
                if (string4 != null) {
                    hashMap.put("name", string4);
                }
                if (string6 != null) {
                    hashMap.put("note", string6);
                }
                if (string5 != null) {
                    hashMap.put("os", string5);
                }
                if (d != 0.0) {
                    hashMap.put("version", d + "");
                }
                String string7 = CommonUtils.TargetKey(hashMap);
                this.client.getConnection().call("targets.update", CommonUtils.args(string7, hashMap));
            }
            this.client.getConnection().call("targets.push");
        } else {
            if ("&host_info".equals(string)) {
                String string8 = BridgeUtilities.getString(stack, "");
                Map map2 = this.client.getData().getModelDirect("targets", string8);
                return ScriptUtils.IndexOrMap(map2, stack);
            }
            if ("&hosts".equals(string)) {
                List list = (List)this.client.getData().getDataSafe("targets");
                LinkedList linkedList = new LinkedList();
                for (Map map3 : list) {
                    linkedList.add(map3.get("address"));
                }
                return ScriptUtils.convertAll(linkedList);
            }
            if ("&data_keys".equals(string)) {
                return ScriptUtils.convertAll(this.client.getData().getDataKeys());
            }
            if ("&data_query".equals(string)) {
                String string9 = BridgeUtilities.getString(stack, "");
                return ScriptUtils.convertAll(this.client.getData().getDataSafe(string9));
            }
            if ("&resetData".equals(string)) {
                this.client.getConnection().call("aggressor.event", CommonUtils.args(LoggedEvent.Notify(DataUtils.getNick(this.client.getData()) + " reset the data model.")), null);
                this.client.getConnection().call("aggressor.reset_data");
            } else if ("&credential_add".equals(string)) {
                String string10 = BridgeUtilities.getString(stack, "");
                String string11 = BridgeUtilities.getString(stack, "");
                String string12 = BridgeUtilities.getString(stack, "");
                String string13 = BridgeUtilities.getString(stack, "manual");
                String string14 = BridgeUtilities.getString(stack, "");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("user", string10);
                hashMap.put("password", string11);
                hashMap.put("realm", string12);
                hashMap.put("source", string13);
                hashMap.put("host", string14);
                this.client.getConnection().call("credentials.add", CommonUtils.args(CommonUtils.CredKey(hashMap), hashMap));
                this.client.getConnection().call("credentials.push");
            } else if ("&sync_download".equals(string)) {
                String string15 = BridgeUtilities.getString(stack, "");
                String string16 = BridgeUtilities.getString(stack, "");
                DownloadNotify downloadNotify = null;
                if (!stack.isEmpty()) {
                    Scalar scalar = (Scalar)stack.pop();
                    downloadNotify = (DownloadNotify)ObjectUtilities.buildArgument(DownloadNotify.class, scalar, scriptInstance);
                }
                new DownloadFileSimple(this.client.getConnection(), string15, new File(string16), downloadNotify).start();
            } else {
                Map map4 = DataBridge.getKeys();
                if (map4.containsKey(string)) {
                    String string17 = (String)map4.get(string);
                    return ScriptUtils.convertAll(this.client.getData().getDataSafe(string17));
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }
}

