/*
 * Decompiled with CFR 0.152.
 */
package aggressor.bridges;

import aggressor.AggressorClient;
import aggressor.TabManager;
import cortana.Cortana;
import graph.NetworkGraph;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.imageio.ImageIO;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class GraphBridge
implements Function,
Loadable {
    protected AggressorClient client;
    protected TabManager manager;
    protected Cortana engine;
    protected static Map imageCache = new HashMap();

    public GraphBridge(AggressorClient aggressorClient, Cortana cortana, TabManager tabManager) {
        this.client = aggressorClient;
        this.engine = cortana;
        this.manager = tabManager;
    }

    @Override
    public void scriptLoaded(ScriptInstance scriptInstance) {
        Cortana.put(scriptInstance, "&graph", this);
        Cortana.put(scriptInstance, "&graph_start", this);
        Cortana.put(scriptInstance, "&graph_end", this);
        Cortana.put(scriptInstance, "&graph_add", this);
        Cortana.put(scriptInstance, "&graph_connect", this);
        Cortana.put(scriptInstance, "&image_overlay", this);
        Cortana.put(scriptInstance, "&graph_zoom", this);
        Cortana.put(scriptInstance, "&graph_zoom_reset", this);
        Cortana.put(scriptInstance, "&graph_layout", this);
        Cortana.put(scriptInstance, "&graph_show_disconnected", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&graph")) {
            return SleepUtils.getScalar(new NetworkGraph(this.client));
        }
        if (string.equals("&graph_start")) {
            NetworkGraph networkGraph = (NetworkGraph)BridgeUtilities.getObject(stack);
            networkGraph.start();
        } else if (string.equals("&graph_end")) {
            NetworkGraph networkGraph = (NetworkGraph)BridgeUtilities.getObject(stack);
            networkGraph.deleteNodes();
            networkGraph.end();
        } else if (string.equals("&graph_add")) {
            NetworkGraph networkGraph = (NetworkGraph)BridgeUtilities.getObject(stack);
            String string2 = BridgeUtilities.getString(stack, "");
            String string3 = BridgeUtilities.getString(stack, "");
            String string4 = BridgeUtilities.getString(stack, "");
            Image image = (Image)BridgeUtilities.getObject(stack);
            String string5 = BridgeUtilities.getString(stack, "");
            networkGraph.addNode(string2, string3, string4, image, string5, "");
        } else if (string.equals("&graph_connect")) {
            NetworkGraph networkGraph = (NetworkGraph)BridgeUtilities.getObject(stack);
            String string6 = BridgeUtilities.getString(stack, "");
            String string7 = BridgeUtilities.getString(stack, "");
            String string8 = BridgeUtilities.getString(stack, "");
            String string9 = BridgeUtilities.getString(stack, "");
            String string10 = BridgeUtilities.getString(stack, "");
            String string11 = BridgeUtilities.getString(stack, "");
            networkGraph.addEdge(string6, string7, string8, string9, string10, string11, 1);
        } else {
            if (string.equals("&image_overlay")) {
                Object object;
                String string12 = BridgeUtilities.getString(stack, "");
                Object object2 = imageCache;
                synchronized (object2) {
                    if (imageCache.containsKey(string12)) {
                        return SleepUtils.getScalar(imageCache.get(string12));
                    }
                }
                object2 = new BufferedImage(1000, 776, 2);
                Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
                while (!stack.isEmpty()) {
                    try {
                        object = BridgeUtilities.getString(stack, "");
                        FileInputStream fileInputStream = new FileInputStream((String)object);
                        BufferedImage bufferedImage = ImageIO.read(new FileInputStream((String)object));
                        ((InputStream)fileInputStream).close();
                        graphics2D.drawImage(bufferedImage, 0, 0, 1000, 776, null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                graphics2D.dispose();
                object = imageCache;
                synchronized (object) {
                    imageCache.put(string12, object2);
                }
                return SleepUtils.getScalar(object2);
            }
            if (string.equals("&graph_zoom_reset")) {
                NetworkGraph networkGraph = (NetworkGraph)BridgeUtilities.getObject(stack);
                networkGraph.resetZoom();
            } else if (string.equals("&graph_zoom")) {
                NetworkGraph networkGraph = (NetworkGraph)BridgeUtilities.getObject(stack);
                double d = BridgeUtilities.getDouble(stack);
                networkGraph.zoom(d);
            } else if (string.equals("&graph_layout")) {
                NetworkGraph networkGraph = (NetworkGraph)BridgeUtilities.getObject(stack);
                String string13 = BridgeUtilities.getString(stack, "");
                networkGraph.setAutoLayout(string13);
            } else if (string.equals("&graph_show_disconnected")) {
                NetworkGraph networkGraph = (NetworkGraph)BridgeUtilities.getObject(stack);
                boolean bl = SleepUtils.isTrueScalar(BridgeUtilities.getScalar(stack));
                networkGraph.setShowDisconnected(bl);
            }
        }
        return SleepUtils.getEmptyScalar();
    }
}

