/*
 * Decompiled with CFR 0.152.
 */
package aggressor.browsers;

import aggressor.Aggressor;
import aggressor.AggressorClient;
import aggressor.MultiFrame;
import aggressor.Prefs;
import aggressor.dialogs.ConnectDialog;
import common.Callback;
import common.CommonUtils;
import common.TeamQueue;
import common.TeamSocket;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ssl.ArmitageTrustListener;
import ssl.SecureSocket;

public class Connect
implements DialogListener,
Callback,
ArmitageTrustListener {
    protected MultiFrame window;
    protected TeamQueue tqueue = null;
    protected String alias = "";
    protected Map m_options = null;
    private boolean V = false;
    private String U = null;
    private String W = null;

    public Connect(MultiFrame multiFrame) {
        this.window = multiFrame;
    }

    public Connect(MultiFrame multiFrame, boolean bl, String string) {
        this.window = multiFrame;
        this.V = bl;
        this.U = string;
    }

    @Override
    public boolean trust(String string) {
        HashSet hashSet = new HashSet(Prefs.getPreferences().getList("trusted.servers"));
        if (hashSet.contains(string)) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog(null, "The team server's fingerprint is:\n\n" + string + "\n\nDoes this match the fingerprint shown when the team server started?", "VerifyFingerprint", 0);
        if (n == 0) {
            Prefs.getPreferences().appendList("trusted.servers", string);
            Prefs.getPreferences().save();
            return true;
        }
        return false;
    }

    private boolean A(Map map2) {
        String string = map2.get("user") + "";
        String string2 = map2.get("host") + "";
        String string3 = map2.get("port") + "";
        String string4 = map2.get("alias") + "";
        StringBuilder stringBuilder = new StringBuilder();
        if (CommonUtils.isNullOrEmpty(string4)) {
            stringBuilder.append((stringBuilder.length() > 0 ? "\n" : "") + "Alias name can not be empty.");
        } else {
            if ('*' == string4.charAt(0)) {
                stringBuilder.append((stringBuilder.length() > 0 ? "\n" : "") + "Alias name can not start with *.");
            }
            if (this.window.checkCollision(string4)) {
                stringBuilder.append((stringBuilder.length() > 0 ? "\n" : "") + "Alias name already in use.");
            }
        }
        if (CommonUtils.isNullOrEmpty(string2)) {
            stringBuilder.append((stringBuilder.length() > 0 ? "\n" : "") + "Host name can not be empty.");
        }
        if (CommonUtils.isNullOrEmpty(string3)) {
            stringBuilder.append((stringBuilder.length() > 0 ? "\n" : "") + "Port can not be empty.");
        } else if (!CommonUtils.isNumber(string3)) {
            stringBuilder.append((stringBuilder.length() > 0 ? "\n" : "") + "Port needs to be a number.");
        }
        if (CommonUtils.isNullOrEmpty(string)) {
            stringBuilder.append((stringBuilder.length() > 0 ? "\n" : "") + "User name can not be empty.");
        }
        if (stringBuilder.length() > 0) {
            Prefs.getPreferences().set("connection.last", this.W != null ? this.W : "New Profile");
            new ConnectDialog(this.window).show();
            DialogUtils.showError(stringBuilder.toString());
            return false;
        }
        return true;
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        if (!this.A(map2)) {
            return;
        }
        this.m_options = map2;
        String string = map2.get("user") + "";
        String string2 = map2.get("host") + "";
        String string3 = map2.get("port") + "";
        String string4 = map2.get("pass") + "";
        this.alias = map2.get("alias") + "";
        Prefs.getPreferences().set("connection.last", string2);
        Prefs.getPreferences().appendList("connection.profiles", string2);
        Prefs.getPreferences().set("connection.profiles." + string2 + ".user", string);
        Prefs.getPreferences().set("connection.profiles." + string2 + ".port", string3);
        Prefs.getPreferences().set("connection.profiles." + string2 + ".password", string4);
        Prefs.getPreferences().set("connection.profiles." + string2 + ".alias", this.alias);
        Prefs.getPreferences().save();
        try {
            SecureSocket secureSocket = new SecureSocket(string2, Integer.parseInt(string3), this);
            secureSocket.authenticate(string4);
            this.tqueue = new TeamQueue(new TeamSocket(secureSocket.getSocket(), false));
            this.tqueue.call("aggressor.authenticate", CommonUtils.args(string, string4, Aggressor.VERSION), this);
        }
        catch (Exception exception) {
            String string5 = this.V ? "again?" : "another connection?";
            SafeDialogs.askYesNoBoth(exception.getMessage() + "\n\nA Cobalt Strike team server is not available on\n" + "the specified host and port. You must start a\n" + "Cobalt Strike team server first.\n\n" + "Would you like to try " + string5, "Connection Error", new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    if ("no".equals(string)) {
                        CommonUtils.runSafe(new Runnable(){

                            @Override
                            public void run() {
                                Connect.this.window.quit(Connect.this.m_options);
                            }
                        });
                        return;
                    }
                    if (Connect.this.V) {
                        new Connect(Connect.this.window, true, Connect.this.alias).dialogAction(null, Connect.this.m_options);
                    } else {
                        new ConnectDialog(Connect.this.window).show();
                    }
                }
            });
        }
    }

    @Override
    public void result(String string, Object object) {
        if ("aggressor.authenticate".equals(string)) {
            String string2 = object + "";
            if (string2.equals("SUCCESS")) {
                this.tqueue.call("aggressor.metadata", CommonUtils.args(System.currentTimeMillis()), this);
            } else {
                DialogUtils.showError(string2);
                this.tqueue.close();
            }
        } else if ("aggressor.metadata".equals(string)) {
            final AggressorClient aggressorClient = new AggressorClient(this.window, this.tqueue, (Map)object, this.m_options);
            CommonUtils.runSafe(new Runnable(){

                @Override
                public void run() {
                    Connect.this.window.addButton(Connect.this.alias, aggressorClient, Connect.this.U == null ? Connect.this.alias : Connect.this.U);
                    aggressorClient.showTime();
                }
            });
        }
    }

    public JComponent getContent(JFrame jFrame, String string, String string2, String string3, String string4, String string5) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.W = string3;
        DialogManager dialogManager = new DialogManager(jFrame);
        dialogManager.addDialogListener(this);
        dialogManager.set("user", string);
        dialogManager.set("pass", string2);
        dialogManager.set("host", string3);
        dialogManager.set("port", string4);
        dialogManager.set("alias", string5);
        dialogManager.text("alias", "Alias:", 20);
        dialogManager.text("host", "Host:", 20);
        dialogManager.text("port", "Port:", 10);
        dialogManager.text("user", "User:", 20);
        dialogManager.password("pass", "Password:", 20);
        JButton jButton = dialogManager.action("Connect");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-setup-collaboration");
        jPanel.add((Component)dialogManager.layout(), "Center");
        jPanel.add((Component)DialogUtils.center(jButton, jButton2), "South");
        return jPanel;
    }
}

