/*
 * Decompiled with CFR 0.152.
 */
package aggressor.browsers;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import beacon.TaskBeacon;
import common.AObject;
import common.Callback;
import common.CommonUtils;
import console.StatusBar;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.TreeModel;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;
import ui.ATable;
import ui.ATextField;
import ui.DoubleClickListener;
import ui.DoubleClickWatch;
import ui.FileBrowserNode;
import ui.FileBrowserNodes;
import ui.GenericTableModel;
import ui.Sorters;
import ui.TablePopup;

public class Files
extends AObject
implements Callback,
ActionListener,
TablePopup,
DoubleClickListener {
    protected String bid = "";
    protected AggressorClient client = null;
    protected JTree tree = null;
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{"D", "Name", "Size", "Modified"};
    protected ATextField folder = null;
    protected JButton up = null;
    protected FileBrowserNodes nodes = new FileBrowserNodes();

    public void setTree(JTree jTree) {
        this.tree = jTree;
    }

    public Files(AggressorClient aggressorClient, String string) {
        this.client = aggressorClient;
        this.bid = string;
        StatusBar.StatusBarHelper.setupStatusBar(this.getClass());
    }

    public void gotof(String string) {
        FileBrowserNode fileBrowserNode = this.getNodes().getNodeFromCache(string);
        if (fileBrowserNode != null) {
            this.gotof(fileBrowserNode);
        } else {
            this.ls(string);
        }
    }

    public void clearSelection() {
        this.getNodes().setSelected(null);
        this.tree.repaint();
    }

    public void gotof(FileBrowserNode fileBrowserNode) {
        this.getNodes().setSelected(fileBrowserNode);
        if (fileBrowserNode.hasCache()) {
            this.result(null, fileBrowserNode.getCache());
        } else {
            this.ls(fileBrowserNode.getPath());
        }
        this.tree.repaint();
    }

    public void ls(String string) {
        DialogUtils.setText(this.folder, string);
        DialogUtils.setTable(this.table, this.model, new LinkedList());
        this.ls_refresh(string);
    }

    public void ls_refresh(String string) {
        TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.client.getConnection(), new String[]{this.bid});
        taskBeacon.log_task(this.bid, this.A("list files in " + string));
        String string2 = CommonUtils.bString(DataUtils.encodeForBeacon(this.client.getData(), this.bid, string));
        this.client.getConnection().call("beacons.task_ls", CommonUtils.args(this.bid, string2), this);
    }

    private String A(String string) {
        return "Tasked beacon to " + string + " (from File Browser)";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() == this.folder) {
            String string2 = this.folder.getText().trim();
            if (!"".equals(string2)) {
                this.clearSelection();
                this.gotof(string2);
            }
        } else if (actionEvent.getSource() == this.up && !this.nodes.isSelected(null)) {
            String string3 = this.nodes.getSelected().getParent();
            if (!"".equals(string3)) {
                this.gotof(string3);
            }
        } else if ("Upload...".equals(string)) {
            FileBrowserNode fileBrowserNode = this.nodes.getSelected();
            if (fileBrowserNode == null) {
                DialogUtils.showError("A location must be selected before a file can uploaded.");
            } else {
                SafeDialogs.openFile("Upload...", null, null, false, false, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        FileBrowserNode fileBrowserNode = Files.this.nodes.getSelected();
                        if (fileBrowserNode == null) {
                            DialogUtils.showError("A location must be selected before a file can uploaded.");
                        } else {
                            String string2 = fileBrowserNode.getChild(new File(string).getName());
                            TaskBeacon taskBeacon = new TaskBeacon(Files.this.client, Files.this.client.getData(), Files.this.client.getConnection(), new String[]{Files.this.bid});
                            taskBeacon.input("upload " + string + " (" + string2 + ")");
                            taskBeacon.Upload(string, string2);
                            Files.this.ls_refresh(Files.this.nodes.getSelected().getPath());
                        }
                    }
                });
            }
        } else if ("Make Directory".equals(string)) {
            FileBrowserNode fileBrowserNode = this.nodes.getSelected();
            if (fileBrowserNode == null) {
                DialogUtils.showError("A location must be selected before a directory can be created.");
            } else {
                SafeDialogs.ask("Which folder?", "", new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        FileBrowserNode fileBrowserNode = Files.this.nodes.getSelected();
                        if (fileBrowserNode == null) {
                            DialogUtils.showError("A location must be selected before a directory can be created.");
                        } else {
                            String string2 = fileBrowserNode.getChild(string);
                            TaskBeacon taskBeacon = new TaskBeacon(Files.this.client, Files.this.client.getData(), Files.this.client.getConnection(), new String[]{Files.this.bid});
                            taskBeacon.input("mkdir " + string2);
                            taskBeacon.MkDir(string2);
                            Files.this.ls_refresh(Files.this.nodes.getSelected().getPath());
                        }
                    }
                });
            }
        } else if ("List Drives".equals(string)) {
            DialogUtils.setText(this.folder, "");
            this.clearSelection();
            TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.client.getConnection(), new String[]{this.bid});
            taskBeacon.log_task(this.bid, this.A("list drives"));
            this.client.getConnection().call("beacons.task_drives", CommonUtils.args(this.bid), new Callback(){

                @Override
                public void result(String string, Object object) {
                    String[] stringArray = CommonUtils.toArray(CommonUtils.drives(object + ""));
                    LinkedList linkedList = new LinkedList();
                    for (int i = 0; i < stringArray.length; ++i) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("D", "drive");
                        hashMap.put("Name", stringArray[i]);
                        linkedList.add(hashMap);
                        FileBrowserNode fileBrowserNode = Files.this.nodes.getNode(stringArray[i]);
                        if (!Files.this.nodes.isSelected(null)) continue;
                        Files.this.nodes.setSelected(fileBrowserNode);
                    }
                    DialogUtils.setTable(Files.this.table, Files.this.model, linkedList);
                    Files.this.nodes.refresh(Files.this.tree);
                }
            });
        } else if ("Refresh".equals(string)) {
            FileBrowserNode fileBrowserNode = this.nodes.getSelected();
            if (fileBrowserNode == null) {
                DialogUtils.showError("A location must be selected before it can be refreshed.");
            } else {
                this.ls_refresh(fileBrowserNode.getPath());
            }
        }
    }

    @Override
    public void doubleClicked(MouseEvent mouseEvent) {
        String string = (String)this.model.getSelectedValue(this.table);
        String string2 = (String)this.model.getSelectedValueFromColumn(this.table, "D");
        if (string2.equals("dir")) {
            String string3 = this.nodes.getSelected().getChild(string);
            this.gotof(string3);
        } else if (string2.equals("drive")) {
            this.gotof(string);
        }
    }

    @Override
    public void showPopup(MouseEvent mouseEvent) {
        if (this.nodes.isSelected(null)) {
            return;
        }
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(this));
        stack.push(CommonUtils.toSleepArray(this.model.getSelectedValues(this.table)));
        stack.push(SleepUtils.getScalar(this.nodes.getSelected().getPathNoTrailingSlash()));
        stack.push(SleepUtils.getScalar(this.bid));
        this.client.getScriptEngine().getMenuBuilder().installMenu(mouseEvent, "filebrowser", stack);
    }

    public JComponent getButtons() {
        JButton jButton = DialogUtils.Button("Upload...", this);
        JButton jButton2 = DialogUtils.Button("Make Directory", this);
        JButton jButton3 = DialogUtils.Button("List Drives", this);
        JButton jButton4 = DialogUtils.Button("Refresh", this);
        JButton jButton5 = DialogUtils.Button("Help", this);
        jButton5.addActionListener(DialogUtils.gotoURL("https://www.cobaltstrike.com/help-file-browser"));
        return DialogUtils.center(jButton, jButton2, jButton3, jButton4, jButton5);
    }

    public JComponent getContent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.model = DialogUtils.setupModel("Name", this.cols, new LinkedList());
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, true);
        this.table.getColumn("D").setMaxWidth(38);
        this.table.getColumn("Size").setCellRenderer(ATable.getSizeTableRenderer());
        this.table.getColumn("D").setCellRenderer(ATable.getFileTypeTableRenderer(this.model));
        this.table.getColumn("Name").setCellRenderer(ATable.getSimpleTableRenderer());
        TableRowSorter<GenericTableModel> tableRowSorter = new TableRowSorter<GenericTableModel>(this.model);
        tableRowSorter.toggleSortOrder(0);
        this.table.setRowSorter(tableRowSorter);
        tableRowSorter.setComparator(2, Sorters.getNumberSorter());
        tableRowSorter.setComparator(3, Sorters.getDateSorter("MM/dd/yyyy HH:mm:ss"));
        this.table.setPopupMenu(this);
        this.table.addMouseListener(new DoubleClickWatch(this));
        this.folder = new ATextField("", 80);
        this.folder.addActionListener(this);
        Icon icon = UIManager.getIcon("FileView.directoryIcon");
        this.up = new JButton(icon);
        this.up.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.folder, "Center");
        jPanel2.add((Component)DialogUtils.pad(this.up, 0, 0, 0, 4), "West");
        jPanel.add((Component)DialogUtils.pad(jPanel2, 3, 3, 3, 3), "North");
        jPanel.add((Component)DialogUtils.FilterAndScroll(this.table), "Center");
        return jPanel;
    }

    public TreeModel getTreeModel() {
        return this.nodes.getModel();
    }

    public FileBrowserNodes getNodes() {
        return this.nodes;
    }

    public boolean updateTreeModel(String string, String string2, LinkedList linkedList) {
        FileBrowserNode fileBrowserNode = this.nodes.getNode(string);
        fileBrowserNode.setCache(string2);
        if (this.nodes.isSelected(null)) {
            this.nodes.setSelected(fileBrowserNode);
        }
        for (Map map2 : linkedList) {
            if (!"dir".equals(map2.get("D"))) continue;
            FileBrowserNode fileBrowserNode2 = this.nodes.addNode(string, (String)map2.get("Name"));
            if (fileBrowserNode2.hasCache()) {
                map2.put("cache", Boolean.TRUE);
                continue;
            }
            map2.put("cache", Boolean.FALSE);
        }
        this.nodes.refresh(this.tree);
        return this.nodes.isSelected(fileBrowserNode);
    }

    @Override
    public void result(String string, Object object) {
        LinkedList linkedList = new LinkedList();
        String[] stringArray = object.toString().trim().split("\n");
        String string2 = stringArray[0].substring(0, stringArray[0].length() - 2);
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("\t");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (stringArray2[0].equals("D") && !".".equals(stringArray2[3]) && !"..".equals(stringArray2[3])) {
                hashMap.put("D", "dir");
                hashMap.put("Modified", stringArray2[2]);
                hashMap.put("Name", stringArray2[3]);
                linkedList.add(hashMap);
                continue;
            }
            if (!stringArray2[0].equals("F")) continue;
            hashMap.put("D", "fil");
            hashMap.put("Size", stringArray2[1]);
            hashMap.put("Modified", stringArray2[2]);
            hashMap.put("Name", stringArray2[3]);
            linkedList.add(hashMap);
        }
        if (this.updateTreeModel(string2, object.toString(), linkedList)) {
            DialogUtils.setText(this.folder, string2);
            DialogUtils.setTable(this.table, this.model, linkedList);
        }
    }
}

