/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import aggressor.browsers.Credentials;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import filter.DataFilter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class CredentialChooser
implements DialogListener {
    protected JFrame dialog = null;
    protected AggressorClient client = null;
    protected Credentials browser;
    protected SafeDialogCallback callback;

    public CredentialChooser(AggressorClient aggressorClient, SafeDialogCallback safeDialogCallback) {
        this.client = aggressorClient;
        this.callback = safeDialogCallback;
        this.browser = new Credentials(aggressorClient);
        this.browser.setColumns("user, password, realm, note");
    }

    public DataFilter getFilter() {
        return this.browser.getFilter();
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        if (!this.browser.hasSelectedRows()) {
            DialogUtils.showError(DialogUtils.MessageID.A_ROW_MUST_BE_SELECTED);
            return;
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
        String string = (String)this.browser.getSelectedValueFromColumn("user");
        String string2 = (String)this.browser.getSelectedValueFromColumn("realm");
        String string3 = (String)this.browser.getSelectedValueFromColumn("password");
        if (string2 == null || string2.length() == 0) {
            this.callback.dialogResult(string + " " + string3);
        } else {
            this.callback.dialogResult(string2 + "\\" + string + " " + string3);
        }
    }

    public void show() {
        this.dialog = DialogUtils.dialog("Choose a Credential", 580, 200);
        this.dialog.addWindowListener(this.browser.onclose());
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        JComponent jComponent = this.browser.getContent();
        JButton jButton = dialogManager.action_noclose("Choose");
        this.dialog.add((Component)jComponent, "Center");
        this.dialog.add((Component)DialogUtils.center(jButton), "South");
        this.dialog.setVisible(true);
    }
}

