/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import common.CommonUtils;
import dialog.DialogUtils;
import importers.ImportHandler;
import importers.Importer;
import java.io.File;
import java.util.HashMap;

public class ImportHosts
implements ImportHandler,
Runnable {
    protected int hosts = 0;
    protected int services = 0;
    protected AggressorClient client;
    protected String[] files;

    public ImportHosts(AggressorClient aggressorClient, String[] stringArray) {
        this.client = aggressorClient;
        this.files = stringArray;
        new Thread((Runnable)this, "import " + stringArray.length + " file(s)").start();
    }

    public boolean runForFile(String string) {
        File file = new File(string);
        for (Importer importer : Importer.importers(this)) {
            if (!importer.process(file)) continue;
            return true;
        }
        DialogUtils.showError("Import canceled: " + file.getName() + " is not a recognized format");
        return false;
    }

    @Override
    public void run() {
        for (int i = 0; i < this.files.length; ++i) {
            if (this.runForFile(this.files[i])) continue;
            return;
        }
        this.finish();
    }

    public void finish() {
        if (this.hosts > 0) {
            this.client.getConnection().call("targets.push");
        }
        if (this.services > 0) {
            this.client.getConnection().call("services.push");
        }
        if (this.hosts == 1) {
            DialogUtils.showInfo("Imported " + this.hosts + " host");
        } else {
            DialogUtils.showInfo("Imported " + this.hosts + " hosts");
        }
    }

    @Override
    public void host(String string, String string2, String string3, double d) {
        ++this.hosts;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("address", string);
        if (string2 != null) {
            hashMap.put("name", string2);
        }
        if (string3 != null) {
            hashMap.put("os", string3);
            if (d != 0.0) {
                hashMap.put("version", d + "");
            }
        }
        this.client.getConnection().call("targets.update", CommonUtils.args(CommonUtils.TargetKey(hashMap), hashMap));
    }

    @Override
    public void service(String string, String string2, String string3) {
        ++this.services;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("address", string);
        hashMap.put("port", string2);
        if (string3 != null) {
            hashMap.put("banner", string3);
        }
        this.client.getConnection().call("services.update", CommonUtils.args(CommonUtils.ServiceKey(hashMap), hashMap));
    }
}

