/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.Prefs;
import aggressor.ui.UseSynthetica;
import common.AObject;
import common.CommonUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import ui.Navigator;

public class PreferencesDialog
extends AObject
implements DialogListener,
ItemListener {
    protected JFrame dialog = null;
    protected DialogManager controller = null;
    protected Navigator options = null;
    private DialogManager.DialogRow n = null;
    private DialogManager.DialogRow o = null;
    private DialogManager.DialogRow k = null;
    private DialogManager.DialogRow m = null;
    private Prefs.BeaconHealthMonitoringPreferencesDefaults l = Prefs.getPreferences().getBeaconHealthMonitoringPreferencesDefaults();

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Save")) {
            Prefs.getPreferences().update(map2);
            DialogUtils.showInfo("Saved preferences.\r\n\r\n Restart Cobalt Strike for changes to take effect.");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && (this.n.ContainsCompoment((Component)itemEvent.getSource()) || this.o.ContainsCompoment((Component)itemEvent.getSource()))) {
            this.D();
        }
    }

    private void D() {
        JComboBox jComboBox = (JComboBox)this.n.getCompoment(JComboBox.class);
        JComboBox jComboBox2 = (JComboBox)this.o.getCompoment(JComboBox.class);
        String string = (String)jComboBox.getSelectedItem();
        String string2 = (String)jComboBox2.getSelectedItem();
        Prefs.BeaconHealthMonitoring beaconHealthMonitoring = Prefs.getPreferences().getBeaconHealthMonitoring(string);
        Prefs.BeaconHealthMonitoringType beaconHealthMonitoringType = Prefs.getPreferences().getBeaconHealthMonitoringType(string2);
        switch (beaconHealthMonitoring) {
            case NOCOMMUNICATION: {
                this.o.setEnabled(true);
                boolean bl = beaconHealthMonitoringType == Prefs.BeaconHealthMonitoringType.BEACONSLEEP;
                this.k.setEnabled(!bl);
                this.m.setEnabled(bl);
                break;
            }
            default: {
                this.o.setEnabled(false);
                this.k.setEnabled(false);
                this.m.setEnabled(false);
            }
        }
    }

    public void consolePreferences() {
        this.controller.startGroup("console");
        this.controller.font("console.font.font", "Font:");
        this.controller.color("console.foreground.color", "Foreground:");
        this.controller.color("console.background.color", "Background:");
        this.controller.color("console.highlight.color", "Highlight:");
        this.controller.checkbox_add("console.showtimestamp.boolean", "Timestamps:", "Show timestamps with console messages");
        this.controller.endGroup();
        this.options.addPage("Console", DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/monitor_icon&16.png" : "resources/cc/black/png/monitor_icon&16.png"), "These options control the look of Cobalt Strike's consoles.", this.controller.layout("console"));
    }

    public void statusbarPreferences() {
        this.controller.startGroup("statusbar");
        this.controller.color("statusbar.foreground.color", "Foreground:");
        this.controller.color("statusbar.background.color", "Background:");
        this.controller.endGroup();
        this.options.addPage("Statusbar", DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/monitor_icon&16.png" : "resources/cc/black/png/monitor_icon&16.png"), "These options control the look of the statusbars within Cobalt Strike's consoles.", this.controller.layout("statusbar"));
    }

    public void cobaltstrikePreferences() {
        this.controller.startGroup("cobalt");
        this.controller.color("tab.highlight.color", "Tab Activity:");
        this.controller.checkbox_add("client.toolbar.boolean", "Toolbar:", "Show toolbar in main window");
        this.controller.text("client.vncports.string", "VNC Ports:");
        this.controller.font("client.font.font", "GUI Font:");
        Object[] objectArray = UseSynthetica.GetThemeNames();
        this.controller.combobox("client.gui.theme", "GUI Theme:", objectArray);
        this.controller.endGroup();
        this.options.addPage("Cobalt Strike", DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/wrench_icon&16.png" : "resources/cc/black/png/wrench_icon&16.png"), "Options to configure Cobalt Strike.", this.controller.layout("cobalt"));
    }

    public void graphPreferences() {
        this.controller.startGroup("graph");
        this.controller.font("graph.font.font", "Font:");
        this.controller.color("graph.foreground.color", "Foreground:");
        this.controller.color("graph.background.color", "Background:");
        this.controller.color("graph.selection.color", "Selection:");
        this.controller.combobox("graph.default_layout.layout", "Auto Layout:", CommonUtils.toArray("circle, none, stack, tree-bottom, tree-left, tree-right, tree-top"));
        this.controller.endGroup();
        this.options.addPage("Graph", DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/chart_line_icon&16.png" : "resources/cc/black/png/chart_line_icon&16.png"), "These options control the look of Cobalt Strike's graph views.", this.controller.layout("graph"));
    }

    public void reportPreferences() {
        if ("".equals(Prefs.getPreferences().getString("reporting.accent.color", ""))) {
            this.controller.set("reporting.accent.color", "#003562");
        }
        this.controller.startGroup("report");
        this.controller.color("reporting.accent.color", "Accent Color:");
        this.controller.file("reporting.header_image.file", "Logo:");
        this.controller.list_file("reporting.custom_reports", "Reports:");
        this.controller.endGroup();
        this.options.addPage("Reporting", DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/document_icon&16.png" : "resources/cc/black/png/document_icon&16.png"), "These options allow you to customize Cobalt Strike's report template and load custom reports.", this.controller.layout("report"));
    }

    public void fingerprintPreferences() {
        this.controller.startGroup("fingerprints");
        this.controller.list_text("trusted.servers", "Fingerprints:");
        this.controller.endGroup();
        this.options.addPage("Fingerprints", DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/cert_icon&16.png" : "resources/cc/black/png/cert_icon&16.png"), "This panel is a list of team server SSL cert SHA-1 hashes. You may remove trusted hashes here.", this.controller.layout("fingerprints"));
    }

    public void profilePreferences() {
        if ("".equals(Prefs.getPreferences().getString("connection.active.color", ""))) {
            this.controller.set("connection.active.color", "#0000ff");
        }
        this.controller.startGroup("profiles");
        this.controller.list_text("connection.profiles", "Profiles:");
        this.controller.checkbox_add("connection.view.alias.boolean", "Names:", "View Aliases");
        this.controller.color("connection.active.color", "Active Server:");
        this.controller.checkbox_add("connection.showteamserverbar.boolean", "Connected Servers:", "Always show connected servers.");
        this.controller.endGroup();
        this.options.addPage("Team Servers", DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/sq_plus_icon&16.png" : "resources/cc/black/png/sq_plus_icon&16.png"), "This panel is a list of saved connection profiles. You may remove stored profiles here.", this.controller.layout("profiles"));
    }

    public void sleepTrackingPreferences() {
        if ("".equals(Prefs.getPreferences().getString("beacon.health.monitoring.enable", ""))) {
            this.controller.set("beacon.health.monitoring.enable", this.l.BeaconHealthMonitoringOptionsDefaultString);
        }
        if ("".equals(Prefs.getPreferences().getString("beacon.health.monitoring.type", ""))) {
            this.controller.set("beacon.health.monitoring.type", this.l.BeaconHealthMonitoringTypeOptionsDefaultString);
        }
        if ("".equals(Prefs.getPreferences().getString("beacon.health.monitoring.period", ""))) {
            this.controller.set("beacon.health.monitoring.period", this.l.PeriodDefault + "");
        }
        if ("".equals(Prefs.getPreferences().getString("beacon.health.monitoring.missedcheckins", ""))) {
            this.controller.set("beacon.health.monitoring.missedcheckins", this.l.MultipleDefault + "");
        }
        this.controller.startGroup("beaconhealthmonitoring");
        this.n = this.controller.combobox("beacon.health.monitoring.enable", "Monitoring type", this.l.BeaconHealthMonitoringOptions.keySet().toArray(new String[0]), this);
        this.o = this.controller.combobox("beacon.health.monitoring.type", "Monitoring period", this.l.BeaconHealthMonitoringTypeOptions.keySet().toArray(new String[0]), this);
        this.k = this.controller.text("beacon.health.monitoring.period", "Period (seconds):");
        this.m = this.controller.text("beacon.health.monitoring.missedcheckins", "Number of sleep periods to miss:");
        this.controller.endGroup();
        this.options.addPage("Beacon Health", DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/not_connected_icon&16.png" : "resources/cc/black/png/not_connected_icon&16.png"), "These options control the beacon health monitoring shown to the user.", this.controller.layout("beaconhealthmonitoring"));
    }

    public void show() {
        this.dialog = DialogUtils.dialog("Preferences", 320, 240);
        this.dialog.setLayout(new BorderLayout());
        this.controller = new DialogManager(this.dialog);
        this.controller.set(Prefs.getPreferences().copy());
        this.controller.addDialogListener(this);
        this.options = new Navigator();
        this.cobaltstrikePreferences();
        this.consolePreferences();
        this.fingerprintPreferences();
        this.graphPreferences();
        this.reportPreferences();
        this.statusbarPreferences();
        this.profilePreferences();
        this.sleepTrackingPreferences();
        JButton jButton = this.controller.action_noclose("Save");
        this.options.set("Cobalt Strike");
        this.dialog.add((Component)this.options, "Center");
        this.dialog.add((Component)DialogUtils.center(jButton), "South");
        this.dialog.pack();
        this.D();
        this.dialog.setVisible(true);
    }
}

