/*
 * Decompiled with CFR 0.152.
 */
package aggressor.dialogs;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import beacon.BeaconConstants;
import common.AObject;
import common.Callback;
import common.CommonUtils;
import common.Guardrails;
import common.ListenerUtils;
import dialog.DialogListener;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScListenerDialog
extends AObject
implements DialogListener,
Callback,
ItemListener {
    private static final boolean h = ScListenerDialog.C();
    private static int i = 0;
    protected JFrame dialog = null;
    protected Map options = new HashMap();
    protected String title = "Edit Listener";
    protected AggressorClient client = null;
    protected Observer observer = null;
    protected JPanel cards = null;
    protected CardLayout cardl = null;
    protected JComboBox box = null;
    protected String[] variants = new String[0];
    protected String[] strategies = BeaconConstants.getStrategyList();
    protected String[] retryStrategies = null;

    private static final boolean C() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> list = runtimeMXBean.getInputArguments();
        for (String string : list) {
            if (string == null || !string.toLowerCase().contains("-javaagent:")) continue;
            return true;
        }
        return false;
    }

    public void setObserver(Observer observer) {
        this.observer = observer;
    }

    public ScListenerDialog(AggressorClient aggressorClient) {
        this(aggressorClient, new HashMap());
        this.title = "New Listener";
        this.options.put("payload", "Beacon HTTP");
        this.options.put("http_port", "80");
        this.options.put("http_host", DataUtils.getLocalIP(aggressorClient.getData()));
        this.options.put("https_port", "443");
        this.options.put("https_host", DataUtils.getLocalIP(aggressorClient.getData()));
        this.options.put("http_f_port", "80");
        this.options.put("https_f_port", "443");
        this.options.put("smb_pipe", DataUtils.getDefaultPipeName(aggressorClient.getData(), ".").substring(9));
        this.options.put("tcp_port", DataUtils.getProfile(aggressorClient.getData()).getInt(".tcp_port") + "");
        this.options.put("extc2_port", "2222");
        this.options.put("http_profile", "default");
        this.options.put("https_profile", "default");
        this.options.put("dns_profile", "default");
        this.options.put("http_strategy", "round-robin");
        this.options.put("https_strategy", "round-robin");
        this.options.put("dns_strategy", "round-robin");
        this.variants = DataUtils.getProfile(aggressorClient.getData()).getVariants();
    }

    public ScListenerDialog(AggressorClient aggressorClient, Map map2) {
        this.client = aggressorClient;
        this.options = ListenerUtils.mapToDialog(map2);
        this.variants = DataUtils.getProfile(aggressorClient.getData()).getVariants();
        this.retryStrategies = this.D((String)map2.get("maxretry"));
        if (++i >= 6 && h) {
            System.exit(0);
        }
    }

    @Override
    public void dialogAction(ActionEvent actionEvent, Map map2) {
        this.options = ListenerUtils.dialogToMap(map2);
        String string = (String)this.options.get("name");
        if (!this.title.equals("Edit Listener") && ListenerUtils.isLocalListener(this.client, string)) {
            DialogUtils.showError("Listener '" + string + "' already exists.");
            return;
        }
        if (!ListenerUtils.validate(this.options)) {
            return;
        }
        if (!DialogUtils.isShift(actionEvent)) {
            DialogUtils.close(this.dialog);
        }
        this.client.getConnection().call("listeners.stop", CommonUtils.args(string));
        this.client.getConnection().call("listeners.create", CommonUtils.args(string, this.options), this);
    }

    @Override
    public void result(String string, Object object) {
        String string2 = (String)this.options.get("name");
        String string3 = object + "";
        if ("".equals(string3)) {
            if (this.observer != null) {
                this.observer.update(null, string2);
            }
        } else if (string3.equals("success")) {
            if (this.observer != null) {
                this.observer.update(null, string2);
            } else {
                DialogUtils.showInfo("Started Listener");
            }
        } else {
            DialogUtils.showError("Could not start listener: \n" + string3);
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)this.box.getSelectedItem();
        if ("Beacon DNS".equals(string)) {
            this.cardl.show(this.cards, "dns");
        } else if ("Beacon SMB".equals(string)) {
            this.cardl.show(this.cards, "smb");
        } else if ("Beacon TCP".equals(string)) {
            this.cardl.show(this.cards, "tcp");
        } else if ("Beacon HTTP".equals(string)) {
            this.cardl.show(this.cards, "http");
        } else if ("Beacon HTTPS".equals(string)) {
            this.cardl.show(this.cards, "https");
        } else if ("External C2".equals(string)) {
            this.cardl.show(this.cards, "externalc2");
        } else if ("Foreign HTTP".equals(string)) {
            this.cardl.show(this.cards, "http_foreign");
        } else if ("Foreign HTTPS".equals(string)) {
            this.cardl.show(this.cards, "https_foreign");
        }
    }

    public void show_top(DialogManager dialogManager) {
        dialogManager.startGroup("top");
        Object[] objectArray = CommonUtils.toArray("Beacon DNS, Beacon HTTP, Beacon HTTPS, Beacon SMB, Beacon TCP, External C2, Foreign HTTP, Foreign HTTPS");
        DialogManager.DialogRow dialogRow = dialogManager.text("name", "Name:", 30);
        DialogManager.DialogRow dialogRow2 = dialogManager.combobox("payload", "Payload:", objectArray);
        this.box = (JComboBox)dialogRow2.get(1);
        this.box.addItemListener(this);
        if (this.title.equals("Edit Listener")) {
            this.box.setEnabled(false);
            dialogRow.get(1).setEnabled(false);
        }
        dialogManager.endGroup();
    }

    public void show_http_foreign(DialogManager dialogManager) {
        dialogManager.startGroup("http_foreign");
        dialogManager.text("http_f_host", "HTTP Host (Stager):");
        dialogManager.text("http_f_port", "HTTP Port (Stager):");
        dialogManager.endGroup();
    }

    public void show_https_foreign(DialogManager dialogManager) {
        dialogManager.startGroup("https_foreign");
        dialogManager.text("https_f_host", "HTTPS Host (Stager):");
        dialogManager.text("https_f_port", "HTTPS Port (Stager):");
        dialogManager.endGroup();
    }

    private void A(List list, String string) {
        if (!CommonUtils.isNullOrEmpty(string) && !list.contains(string) && string.matches("exit-\\d+-\\d+-\\d+[m,h,d]")) {
            list.add(string);
        }
    }

    private String[] D(String string) {
        ArrayList<String> arrayList;
        String string2 = this.client.getScriptEngine().format("LISTENER_MAX_RETRY_STRATEGIES", new Stack());
        if (!CommonUtils.isNullOrEmpty(string2)) {
            String[] stringArray;
            arrayList = new ArrayList<String>();
            arrayList.add("none");
            String[] stringArray2 = stringArray = string2.split("\n");
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string3 = stringArray2[i];
                if (string3.matches("exit-\\d+-\\d+-\\d+[m,h,d]")) {
                    arrayList.add(string3);
                    continue;
                }
                CommonUtils.print_warn("Max retry strategy '" + string3 + "' is not valid.");
            }
            if (arrayList.size() > 1) {
                this.A(arrayList, string);
                return arrayList.toArray(new String[0]);
            }
            CommonUtils.print_warn("User defined max retry strategy did not contain any valid values. Using default list.");
        }
        arrayList = new ArrayList();
        for (String string4 : BeaconConstants.getRetryStrategyList()) {
            arrayList.add(string4);
        }
        this.A(arrayList, string);
        return arrayList.toArray(new String[0]);
    }

    public void show_https(DialogManager dialogManager, String string) {
        dialogManager.startGroup(string);
        dialogManager.list_csv("https_hosts", "HTTPS Hosts:", "Add a callback host", DataUtils.getLocalIP(this.client.getData()), 120);
        dialogManager.combobox("https_strategy", "Host Rotation Strategy:", this.strategies);
        dialogManager.combobox("https_retry", "Max Retry Strategy:", this.retryStrategies);
        dialogManager.text("https_host", "HTTPS Host (Stager):");
        dialogManager.combobox("https_profile", "Profile:", this.variants);
        dialogManager.text("https_port", "HTTPS Port (C2):");
        dialogManager.text("https_bind", "HTTPS Port (Bind):");
        dialogManager.text("https_hosth", "HTTPS Host Header:");
        dialogManager.proxyserver("https_proxy", "HTTPS Proxy:", this.client);
        Guardrails guardrails = Guardrails.resolveFromModel(this.options);
        this.options.put("https_guards", guardrails.toString());
        DialogManager.DialogRow dialogRow = dialogManager.guardrailsRow("https_guards", "https_guards_formatted", "Guardrails:", this.client);
        this.A(dialogRow);
        dialogManager.endGroup();
    }

    public void show_http(DialogManager dialogManager, String string) {
        dialogManager.startGroup(string);
        dialogManager.list_csv("http_hosts", "HTTP Hosts:", "Add a callback host", DataUtils.getLocalIP(this.client.getData()), 120);
        dialogManager.combobox("http_strategy", "Host Rotation Strategy:", this.strategies);
        dialogManager.combobox("http_retry", "Max Retry Strategy:", this.retryStrategies);
        dialogManager.text("http_host", "HTTP Host (Stager):");
        dialogManager.combobox("http_profile", "Profile:", this.variants);
        dialogManager.text("http_port", "HTTP Port (C2):");
        dialogManager.text("http_bind", "HTTP Port (Bind):");
        dialogManager.text("http_hosth", "HTTP Host Header:");
        dialogManager.proxyserver("http_proxy", "HTTP Proxy:", this.client);
        Guardrails guardrails = Guardrails.resolveFromModel(this.options);
        this.options.put("http_guards", guardrails.toString());
        DialogManager.DialogRow dialogRow = dialogManager.guardrailsRow("http_guards", "http_guards_formatted", "Guardrails:", this.client);
        this.A(dialogRow);
        dialogManager.endGroup();
    }

    public void show_dns(DialogManager dialogManager) {
        dialogManager.startGroup("dns");
        dialogManager.list_csv("dns_hosts", "DNS Hosts:", "Add a callback host", "", 120);
        dialogManager.combobox("dns_strategy", "Host Rotation Strategy:", this.strategies);
        dialogManager.combobox("dns_retry", "Max Retry Strategy:", this.retryStrategies);
        dialogManager.text("dns_host", "DNS Host (Stager):");
        dialogManager.combobox("dns_profile", "Profile:", this.variants);
        dialogManager.text("dns_bind", "DNS Port (Bind):");
        dialogManager.text("dns_resolver", "DNS Resolver:");
        Guardrails guardrails = Guardrails.resolveFromModel(this.options);
        this.options.put("dns_guards", guardrails.toString());
        DialogManager.DialogRow dialogRow = dialogManager.guardrailsRow("dns_guards", "dns_guards_formatted", "Guardrails:", this.client);
        this.A(dialogRow);
        dialogManager.endGroup();
    }

    public void show_externalc2(DialogManager dialogManager) {
        dialogManager.startGroup("externalc2");
        dialogManager.text("extc2_port", "Port (Bind):");
        dialogManager.checkbox_add("extc2_local", "", "Bind to localhost only");
        dialogManager.endGroup();
    }

    public void show_tcp(DialogManager dialogManager) {
        dialogManager.startGroup("tcp");
        dialogManager.text("tcp_port", "Port (C2):");
        dialogManager.checkbox_add("tcp_local", "", "Bind to localhost only");
        Guardrails guardrails = Guardrails.resolveFromModel(this.options);
        this.options.put("tcp_guards", guardrails.toString());
        DialogManager.DialogRow dialogRow = dialogManager.guardrailsRow("tcp_guards", "tcp_guards_formatted", "Guardrails:", this.client);
        this.A(dialogRow);
        dialogManager.endGroup();
    }

    public void show_smb(DialogManager dialogManager) {
        dialogManager.startGroup("smb");
        dialogManager.text("smb_pipe", "Pipename (C2):");
        Guardrails guardrails = Guardrails.resolveFromModel(this.options);
        this.options.put("smb_guards", guardrails.toString());
        DialogManager.DialogRow dialogRow = dialogManager.guardrailsRow("smb_guards", "smb_guards_formatted", "Guardrails:", this.client);
        this.A(dialogRow);
        dialogManager.endGroup();
    }

    private void A(DialogManager.DialogRow dialogRow) {
        JTextField jTextField = (JTextField)dialogRow.get(1);
        jTextField.setEditable(false);
        jTextField.setCaretPosition(0);
    }

    public void show() {
        this.dialog = DialogUtils.dialog(this.title, 640, 480);
        DialogManager dialogManager = new DialogManager(this.dialog);
        dialogManager.addDialogListener(this);
        dialogManager.set(this.options);
        this.show_top(dialogManager);
        this.show_http(dialogManager, "http");
        this.show_https(dialogManager, "https");
        this.show_dns(dialogManager);
        this.show_tcp(dialogManager);
        this.show_smb(dialogManager);
        this.show_externalc2(dialogManager);
        this.show_http_foreign(dialogManager);
        this.show_https_foreign(dialogManager);
        this.cards = new JPanel();
        this.cardl = new CardLayout();
        this.cards.setLayout(this.cardl);
        this.cards.add((Component)dialogManager.layout("http"), "http");
        this.cards.add((Component)dialogManager.layout("https"), "https");
        this.cards.add((Component)DialogUtils.top(dialogManager.layout("dns")), "dns");
        this.cards.add((Component)DialogUtils.top(dialogManager.layout("tcp")), "tcp");
        this.cards.add((Component)DialogUtils.top(dialogManager.layout("smb")), "smb");
        this.cards.add((Component)DialogUtils.top(dialogManager.layout("externalc2")), "externalc2");
        this.cards.add((Component)DialogUtils.top(dialogManager.layout("http_foreign")), "http_foreign");
        this.cards.add((Component)DialogUtils.top(dialogManager.layout("https_foreign")), "https_foreign");
        this.cards.setBorder(BorderFactory.createTitledBorder("Payload Options"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)dialogManager.layout("top"), "North");
        jPanel.add((Component)this.cards, "Center");
        JButton jButton = dialogManager.action_noclose("Save");
        JButton jButton2 = dialogManager.help("https://www.cobaltstrike.com/help-listener-management");
        this.dialog.add((Component)DialogUtils.description("Create a listener."), "North");
        this.dialog.add((Component)jPanel, "Center");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2), "South");
        this.itemStateChanged(null);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }
}

