/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import aggressor.browsers.Beacons;
import aggressor.windows.BeaconConsole;
import common.AObject;
import common.BeaconEntry;
import common.CommonUtils;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BeaconBrowser
extends AObject
implements ActionListener {
    protected AggressorClient client = null;
    protected Beacons browser;

    public BeaconBrowser(AggressorClient aggressorClient) {
        this.client = aggressorClient;
        this.browser = new Beacons(aggressorClient, true);
    }

    public ActionListener cleanup() {
        return this.browser.cleanup();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("Interact".equals(actionEvent.getActionCommand())) {
            String string = this.browser.getSelectedValue() + "";
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), string);
            BeaconConsole beaconConsole = new BeaconConsole(string, this.client);
            this.client.getTabManager().addTab(beaconEntry.title(), beaconConsole.getConsole(), beaconConsole.cleanup(), "Beacon console");
        } else if ("Remove".equals(actionEvent.getActionCommand())) {
            Object[] objectArray = this.browser.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.client.getConnection().call("beacons.remove", CommonUtils.args(objectArray[i]));
            }
        }
    }

    public JComponent getContent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JButton jButton = new JButton("Interact");
        JButton jButton2 = new JButton("Remove");
        JButton jButton3 = new JButton("Help");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(DialogUtils.gotoURL("https://www.cobaltstrike.com/help-beacon"));
        jPanel.add((Component)this.browser.getContent(), "Center");
        jPanel.add((Component)DialogUtils.center(jButton, jButton2, jButton3), "South");
        return jPanel;
    }
}

