/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.AggressorClient;
import aggressor.browsers.Credentials;
import aggressor.dialogs.CredentialDialog;
import common.AObject;
import common.CommonUtils;
import common.Helper;
import common.MudgeSanity;
import dialog.ActivityPanel;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import dialog.SafeDialogsFileFilter;
import importers.CredentialsHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;

public class CredentialManager
extends AObject
implements ActionListener {
    protected AggressorClient client = null;
    protected Credentials browser = null;
    protected ActivityPanel dialog;

    public CredentialManager(AggressorClient aggressorClient) {
        this.client = aggressorClient;
        this.browser = new Credentials(aggressorClient);
        Helper helper = new Helper();
        if (!helper.startHelper(this.getClass())) {
            System.exit(0);
        }
    }

    public ActionListener cleanup() {
        return this.browser.cleanup();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("Add".equals(actionEvent.getActionCommand())) {
            new CredentialDialog(this.client).show();
        } else if ("Edit".equals(actionEvent.getActionCommand())) {
            if (!this.browser.hasSelectedRows()) {
                DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                return;
            }
            Map[] mapArray = this.browser.getSelectedRows();
            for (int i = 0; i < mapArray.length; ++i) {
                new CredentialDialog(this.client, mapArray[i]).show();
            }
        } else if ("Remove".equals(actionEvent.getActionCommand())) {
            if (!this.browser.hasSelectedRows()) {
                DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                return;
            }
            Map[] mapArray = this.browser.getSelectedRows();
            for (int i = 0; i < mapArray.length; ++i) {
                this.client.getConnection().call("credentials.remove", CommonUtils.args(CommonUtils.CredKey(mapArray[i])));
            }
            this.client.getConnection().call("credentials.push");
        } else if ("Copy".equals(actionEvent.getActionCommand())) {
            if (!this.browser.hasSelectedRows()) {
                DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            Map[] mapArray = this.browser.getSelectedRows();
            for (int i = 0; i < mapArray.length; ++i) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                if (!"".equals(mapArray[i].get("realm"))) {
                    stringBuffer.append(mapArray[i].get("realm"));
                    stringBuffer.append("\\");
                }
                stringBuffer.append(mapArray[i].get("user"));
                stringBuffer.append(" ");
                stringBuffer.append(mapArray[i].get("password"));
            }
            DialogUtils.addToClipboard(stringBuffer.toString());
        } else if ("Export".equals(actionEvent.getActionCommand())) {
            Iterator iterator = this.client.getData().getListSafe("credentials").iterator();
            if (!iterator.hasNext()) {
                DialogUtils.showError("There are no credentials to export.");
                return;
            }
            final StringBuffer stringBuffer = this.A(iterator);
            CredentialsHelper credentialsHelper = new CredentialsHelper();
            iterator = this.client.getData().getListSafe("credentials").iterator();
            final StringBuffer stringBuffer2 = credentialsHelper.formatExport(iterator);
            if (stringBuffer2 == null) {
                return;
            }
            SafeDialogsFileFilter safeDialogsFileFilter = new SafeDialogsFileFilter(".tsv", "Tab Separated Values format (*.tsv)", "credentials.tsv");
            SafeDialogsFileFilter safeDialogsFileFilter2 = new SafeDialogsFileFilter(".txt", "PWDump format (*.txt)", "credentials.txt");
            FileFilter[] fileFilterArray = new FileFilter[]{safeDialogsFileFilter, safeDialogsFileFilter2};
            SafeDialogs.saveFile(null, "credentials.tsv", fileFilterArray, new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    File file = new File(string);
                    if (string.toLowerCase().endsWith(".tsv")) {
                        CommonUtils.writeToFile(file, CommonUtils.toBytes(stringBuffer2.toString()));
                        DialogUtils.showInfo("Exported Credentials in TSV format: " + file.getName());
                    } else if (string.toLowerCase().endsWith(".txt")) {
                        CommonUtils.writeToFile(file, CommonUtils.toBytes(stringBuffer.toString()));
                        DialogUtils.showInfo("Exported Credentials in PWDump format: " + file.getName());
                    } else {
                        DialogUtils.showError("Export file names must be '*.tsv' (Tab Separated Values format) or '*.txt' (PWDump format).");
                    }
                }
            });
        } else if ("Import".equals(actionEvent.getActionCommand())) {
            String string = "Open TSV Credential File";
            SafeDialogCallback safeDialogCallback = new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    if (string != null && string.length() > 0) {
                        try {
                            if (!string.toLowerCase().endsWith(".tsv")) {
                                DialogUtils.showError("Import file for credentials must be '*.tsv' for Tab Separated Value format.");
                                return;
                            }
                            CredentialsHelper credentialsHelper = new CredentialsHelper();
                            int n = credentialsHelper.importFile(string, CredentialManager.this.client);
                            if (n > 0) {
                                DialogUtils.showInfo("Imported " + n + " credentials");
                            }
                        }
                        catch (Throwable throwable) {
                            MudgeSanity.logException(throwable.getMessage(), throwable, true);
                            DialogUtils.showError(throwable.getMessage());
                        }
                    }
                }
            };
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(".tsv") || file.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Tab Separated Values (*.tsv)";
                }
            };
            FileFilter[] fileFilterArray = new FileFilter[]{fileFilter};
            SafeDialogs.openFile(string, null, null, false, false, fileFilterArray, safeDialogCallback);
        }
    }

    private StringBuffer A(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# Cobalt Strike Credential Export\n");
        stringBuffer.append("# " + CommonUtils.formatTime(System.currentTimeMillis()) + "\n\n");
        while (iterator.hasNext()) {
            Map map2 = (Map)iterator.next();
            if (!"".equals(map2.get("realm"))) {
                stringBuffer.append(map2.get("realm"));
                stringBuffer.append("\\");
            }
            String string = map2.get("user") + "";
            String string2 = map2.get("password") + "";
            if (string2.length() == 32) {
                stringBuffer.append(string);
                stringBuffer.append(":::");
                stringBuffer.append(string2);
                stringBuffer.append(":::");
            } else {
                stringBuffer.append(string);
                stringBuffer.append(" ");
                stringBuffer.append(string2);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public JComponent getContent() {
        this.dialog = new ActivityPanel();
        this.dialog.setLayout(new BorderLayout());
        this.browser.notifyOnResult(this.dialog);
        JButton jButton = new JButton("Add");
        JButton jButton2 = new JButton("Edit");
        JButton jButton3 = new JButton("Copy");
        JButton jButton4 = new JButton("Remove");
        JButton jButton5 = new JButton("Export");
        JButton jButton6 = new JButton("Import");
        JButton jButton7 = new JButton("Help");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        jButton5.addActionListener(this);
        jButton6.addActionListener(this);
        jButton7.addActionListener(DialogUtils.gotoURL("https://www.cobaltstrike.com/help-credential-management"));
        this.dialog.add((Component)this.browser.getContent(), "Center");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2, jButton3, jButton5, jButton6, jButton4, jButton7), "South");
        return this.dialog;
    }
}

