/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.AggressorClient;
import aggressor.TranscriptEditor;
import common.AObject;
import common.AdjustData;
import common.DeleteDownloadFiles;
import common.Download;
import common.DownloadFiles;
import common.ScriptUtils;
import dialog.ActivityPanel;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import sleep.runtime.Scalar;
import ui.ATable;
import ui.GenericTableModel;
import ui.TablePopup;

public class DownloadBrowser
extends AObject
implements AdjustData,
ActionListener,
SafeDialogCallback,
TablePopup {
    protected AggressorClient client = null;
    protected ActivityPanel dialog = null;
    protected TranscriptEditor editor = new TranscriptEditor();
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{"host", "name", "path", "size", "date"};

    public DownloadBrowser(AggressorClient aggressorClient) {
        this.client = aggressorClient;
        aggressorClient.getData().populateAndSubscribe("accents", this);
        aggressorClient.getData().populateAndSubscribe("downloads.delete", this);
    }

    public ActionListener cleanup() {
        return this.client.getData().unsubOnClose("downloads, accents", this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.model.hasSelectedRows(this.table)) {
            DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
            return;
        }
        if ("Sync Files".equals(actionEvent.getActionCommand())) {
            SafeDialogs.openFile("Sync downloads to?", null, null, false, true, this);
        } else if ("Delete Files".equals(actionEvent.getActionCommand())) {
            SafeDialogs.askYesNo("Are you sure you want to delete these downloads?", "Delete Downloads", new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    if ("yes".equalsIgnoreCase(string)) {
                        new DeleteDownloadFiles(DownloadBrowser.this.client.getConnection(), DownloadBrowser.this.model.getSelectedRows(DownloadBrowser.this.table)).start();
                    }
                }
            });
        }
    }

    @Override
    public void dialogResult(String string) {
        if (string == null) {
            return;
        }
        new DownloadFiles(this.client.getConnection(), this.model.getSelectedRows(this.table), new File(string)).startNextDownload();
    }

    public JComponent getContent() {
        LinkedList linkedList = this.client.getData().populateAndSubscribe("downloads", this);
        this.model = DialogUtils.setupModel("lpath", this.cols, linkedList);
        this.dialog = new ActivityPanel();
        this.dialog.setLayout(new BorderLayout());
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, true);
        this.table.setPopupMenu(this);
        this.editor.setTable(this.table, this.model);
        DialogUtils.setupDateRenderer(this.table, "date");
        DialogUtils.setupSizeRenderer(this.table, "size");
        JButton jButton = new JButton("Sync Files");
        JButton jButton2 = new JButton("Delete Files");
        JButton jButton3 = new JButton("Help");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(DialogUtils.gotoURL("https://www.cobaltstrike.com/help-manage-downloads"));
        this.dialog.add((Component)DialogUtils.FilterAndScroll(this.table), "Center");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2, jButton3), "South");
        return this.dialog;
    }

    @Override
    public Map format(String string, Object object) {
        if (this.editor.processTranscriptFormat(string, object)) {
            return null;
        }
        Download download = (Download)object;
        return this.editor.decorate((Download)object, download.toMap());
    }

    @Override
    public void result(String string, Object object) {
        if (this.editor.processTranscriptResult(string, object)) {
            return;
        }
        if ("downloads.delete".equals(string) && object instanceof String[]) {
            this.table.clearSelection();
            for (String string2 : (String[])object) {
                DialogUtils.removeFromTable(this.table, this.model, "lpath", string2);
            }
        } else {
            DialogUtils.addToTable(this.table, this.model, this.format(string, object));
        }
        this.dialog.touch();
    }

    @Override
    public void showPopup(MouseEvent mouseEvent) {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(ScriptUtils.convertAll(this.model.getSelectedRows(this.table)));
        this.client.getScriptEngine().getMenuBuilder().installMenu(mouseEvent, "downloads", stack);
    }
}

