/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.DataManager;
import aggressor.DataUtils;
import aggressor.WindowCleanup;
import common.AObject;
import common.Callback;
import common.CommandParser;
import common.CommonUtils;
import common.Do;
import common.LoggedEvent;
import common.TeamQueue;
import common.Timers;
import console.ActivityConsole;
import console.Colors;
import console.Console;
import console.ConsolePopup;
import console.GenericTabCompletion;
import cortana.Cortana;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import javax.swing.JTextField;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class EventLog
extends AObject
implements ActionListener,
ConsolePopup,
Callback,
Do {
    protected Console console = null;
    protected TeamQueue conn = null;
    protected Cortana engine = null;
    protected DataManager data = null;
    protected String nick = null;
    protected WindowCleanup state = null;
    protected String lag = "??";

    protected Stack sbarArgs(String string) {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(string));
        return stack;
    }

    public EventLog(DataManager dataManager, Cortana cortana, TeamQueue teamQueue) {
        this.engine = cortana;
        this.conn = teamQueue;
        this.data = dataManager;
        this.nick = DataUtils.getNick(dataManager);
        this.console = new ActivityConsole(true);
        this.console.updatePrompt(Colors.underline("event") + "> ");
        this.console.getInput().addActionListener(this);
        String string = cortana.format("EVENT_SBAR_LEFT", this.sbarArgs("00"));
        String string2 = cortana.format("EVENT_SBAR_RIGHT", this.sbarArgs("00"));
        this.console.getStatusBar().set(string, string2);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = dataManager.getTranscriptAndSubscribeSafe("eventlog", this).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.format("eventlog", iterator.next()));
        }
        this.console.append(stringBuffer.toString());
        this.state = dataManager.unsubOnClose("eventlog", this);
        new _A();
        this.console.setPopupMenu(this);
        Timers.getTimers().every(1000L, "time", this);
        Timers.getTimers().every(10000L, "lag", this);
    }

    @Override
    public boolean moment(String string) {
        if ("time".equals(string) && this.console.isShowing()) {
            String string2 = CommonUtils.padr(this.lag, "0", 2);
            String string3 = this.engine.format("EVENT_SBAR_LEFT", this.sbarArgs(string2));
            String string4 = this.engine.format("EVENT_SBAR_RIGHT", this.sbarArgs(string2));
            this.console.getStatusBar().set(string3, string4);
        } else if ("lag".equals(string)) {
            this.lag = "??";
            this.conn.call("aggressor.ping", CommonUtils.args(new Long(System.currentTimeMillis())), new Callback(){

                @Override
                public void result(String string, Object object) {
                    Long l = (Long)object;
                    EventLog.this.lag = (int)((double)(System.currentTimeMillis() - l) / 1000.0) + "";
                }
            });
        }
        return this.state.isOpen();
    }

    public ActionListener cleanup() {
        return this.state;
    }

    public Console getConsole() {
        return this.console;
    }

    @Override
    public void result(String string, Object object) {
        this.console.append(this.format(string, object));
    }

    public String format(String string, Object object) {
        LoggedEvent loggedEvent = (LoggedEvent)object;
        String string2 = loggedEvent.eventName();
        Stack stack = loggedEvent.eventArguments();
        String string3 = this.engine.format(string2.toUpperCase(), stack);
        if (string3 == null) {
            return "";
        }
        return string3 + "\n";
    }

    @Override
    public void showPopup(String string, MouseEvent mouseEvent) {
        this.engine.getMenuBuilder().installMenu(mouseEvent, "eventlog", new Stack());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        ((JTextField)actionEvent.getSource()).setText("");
        try {
            object = this.console.processHistoryBang(string);
            if (!((String)object).isEmpty()) {
                string = object;
            }
        }
        catch (Exception exception) {
            this.console.append(exception.getMessage() + "\n");
            return;
        }
        this.console.addCommandToHistory(string);
        object = new CommandParser(string);
        if (((CommandParser)object).is("/msg")) {
            if (((CommandParser)object).verify("AZ")) {
                String string2 = ((CommandParser)object).popString();
                String string3 = ((CommandParser)object).popString();
                this.conn.call("aggressor.event", CommonUtils.args(LoggedEvent.Private(this.nick, string3, string2)), null);
            }
        } else if (((CommandParser)object).is("/names") || ((CommandParser)object).is("/sc")) {
            LinkedList linkedList = new LinkedList(DataUtils.getUsers(this.data));
            Collections.sort(linkedList);
            Stack<Scalar> stack = new Stack<Scalar>();
            stack.push(SleepUtils.getArrayWrapper(linkedList));
            this.console.append(this.engine.format("EVENT_USERS", stack) + "\n");
        } else if (((CommandParser)object).is("/me")) {
            if (((CommandParser)object).verify("Z")) {
                this.conn.call("aggressor.event", CommonUtils.args(LoggedEvent.Action(this.nick, ((CommandParser)object).popString())), null);
            }
        } else {
            if (((CommandParser)object).is("history")) {
                int n = ((CommandParser)object).popHistoryArgument();
                if (((CommandParser)object).hasError()) {
                    this.console.append(((CommandParser)object).error() + "\n");
                } else {
                    this.getConsole().showHistory(n);
                }
                return;
            }
            if (string.length() > 0) {
                this.conn.call("aggressor.event", CommonUtils.args(LoggedEvent.Public(this.nick, string)), null);
            }
        }
    }

    private class _A
    extends GenericTabCompletion {
        public _A() {
            super(EventLog.this.console);
        }

        @Override
        public Collection getOptions(String string) {
            LinkedList linkedList = new LinkedList(DataUtils.getUsers(EventLog.this.data));
            LinkedList<String> linkedList2 = new LinkedList<String>();
            linkedList2.add("/me");
            linkedList2.add("/msg");
            linkedList2.add("/names");
            linkedList2.add("/sc");
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next() + "";
                if (string.indexOf(" ") > -1) {
                    linkedList2.add("/msg " + string2);
                }
                linkedList2.add(string2);
            }
            Collections.sort(linkedList2);
            Cortana.filterList(linkedList2, string);
            return linkedList2;
        }
    }
}

