/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.AggressorClient;
import aggressor.ColorManager;
import aggressor.DataManager;
import aggressor.DataUtils;
import aggressor.dialogs.ScListenerDialog;
import common.AObject;
import common.AdjustData;
import common.BeaconEntry;
import common.Callback;
import common.CommonUtils;
import common.ListenerTasks;
import common.TeamQueue;
import cortana.Cortana;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.table.TableModel;
import sleep.runtime.Scalar;
import ui.ATable;
import ui.GenericTableModel;
import ui.QueryableTable;
import ui.TablePopup;

public class ListenerManager
extends AObject
implements AdjustData,
Callback,
ActionListener,
TablePopup {
    protected TeamQueue conn = null;
    protected Cortana engine = null;
    protected DataManager data = null;
    protected AggressorClient client = null;
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{"name", "payload", "host", "port", "bindto", "beacons", "profile"};

    public ListenerManager(AggressorClient aggressorClient) {
        this.engine = aggressorClient.getScriptEngine();
        this.conn = aggressorClient.getConnection();
        this.data = aggressorClient.getData();
        this.client = aggressorClient;
        this.model = DialogUtils.setupModel("name", this.cols, CommonUtils.apply("listeners", DataUtils.getListenerModel(this.data), this));
        this.data.subscribe("listeners", this);
    }

    public ActionListener cleanup() {
        return this.data.unsubOnClose("listeners", this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!"Add".equals(actionEvent.getActionCommand())) break block5;
                        new ScListenerDialog(this.client).show();
                        break block6;
                    }
                    if (!"Edit".equals(actionEvent.getActionCommand())) break block7;
                    if (!this.model.hasSelectedRows(this.table)) {
                        DialogUtils.showError(DialogUtils.MessageID.A_ROW_MUST_BE_SELECTED);
                        return;
                    }
                    String string = this.model.getSelectedValue(this.table) + "";
                    new ListenerTasks(this.client, string).edit();
                    break block6;
                }
                if (!"Remove".equals(actionEvent.getActionCommand())) break block8;
                Object[] objectArray = this.model.getSelectedValues(this.table);
                if (objectArray.length == 0) {
                    DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                    return;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    new ListenerTasks(this.client, (String)objectArray[i]).remove();
                }
                break block6;
            }
            if (!"Restart".equals(actionEvent.getActionCommand())) break block6;
            Object[] objectArray = this.model.getSelectedValues(this.table);
            if (objectArray.length == 0) {
                DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                return;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                this.conn.call("listeners.restart", CommonUtils.args(objectArray[i]), new Callback(){

                    @Override
                    public void result(String string, Object object) {
                        if (object != null) {
                            DialogUtils.showInfo("Updated and restarted listener: " + object);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void showPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu jMenu = new JMenu("Color");
        jMenu.add(new ColorManager(this.client, new QueryableTable(this.table, this.model), "listeners").getColorPanel());
        jPopupMenu.add(jMenu);
        Object[] objectArray = this.model.getSelectedValues(this.table);
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(CommonUtils.toSleepArray(objectArray));
        this.client.getScriptEngine().getMenuBuilder().setupMenu(jPopupMenu, "listeners", stack);
        jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
    }

    public JComponent getContent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, true);
        this.table.setPopupMenu(this);
        DialogUtils.setupListenerStatusRenderer(this.table, this.model, "name");
        DialogUtils.setTableColumnWidths(this.table, DialogUtils.toMap("name: 125, payload: 250, host: 125, port: 60, bindto: 60, beacons: 250, profile: 125"));
        DialogUtils.sortby(this.table, 0);
        JButton jButton = new JButton("Add");
        JButton jButton2 = new JButton("Edit");
        JButton jButton3 = new JButton("Remove");
        JButton jButton4 = new JButton("Restart");
        JButton jButton5 = new JButton("Help");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        jButton5.addActionListener(DialogUtils.gotoURL("https://www.cobaltstrike.com/help-listener-management"));
        jPanel.add((Component)DialogUtils.FilterAndScroll(this.table), "Center");
        jPanel.add((Component)DialogUtils.center(jButton, jButton2, jButton3, jButton4, jButton5), "South");
        return jPanel;
    }

    @Override
    public Map format(String string, Object object) {
        Map map2 = (Map)object;
        String string2 = DialogUtils.string(map2, "bid");
        String string3 = DialogUtils.string(map2, "payload");
        if ("".equals(string2) || !"windows/beacon_reverse_tcp".equals(string3)) {
            return map2;
        }
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string2);
        if (beaconEntry == null) {
            map2.put("status", "pivot session does not exist");
        } else if (!beaconEntry.isAlive()) {
            map2.put("status", "pivot session is not alive");
        }
        return map2;
    }

    @Override
    public void result(String string, Object object) {
        LinkedList linkedList = CommonUtils.apply(string, ((Map)object).values(), this);
        DialogUtils.setTable(this.table, this.model, linkedList);
    }
}

